/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VProperty {
    protected static final HashSet<String> MULTIVALUED_PROPERTIES = new HashSet();
    protected String key;
    protected List<Param> params;
    protected List<String> values;

    public VProperty(String name, String value) {
        this.setKey(name);
        this.setValue(value);
    }

    public VProperty(String line) {
        if (line != null && !"END:VCARD".equals(line)) {
            State state = State.KEY;
            String paramName = null;
            List<String> paramValues = null;
            int startIndex = 0;
            for (int i = 0; i < line.length(); ++i) {
                char currentChar = line.charAt(i);
                if (state == State.KEY) {
                    if (currentChar == ':') {
                        this.setKey(line.substring(startIndex, i));
                        state = State.VALUE;
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar != ';') continue;
                    this.setKey(line.substring(startIndex, i));
                    state = State.PARAM_NAME;
                    startIndex = i + 1;
                    continue;
                }
                if (state == State.PARAM_NAME) {
                    if (currentChar == '=') {
                        paramName = line.substring(startIndex, i).toUpperCase();
                        state = State.PARAM_VALUE;
                        paramValues = new ArrayList<String>();
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar == ';') {
                        paramName = line.substring(startIndex, i).toUpperCase();
                        this.addParam(paramName);
                        state = State.PARAM_NAME;
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar != ':') continue;
                    paramName = line.substring(startIndex, i).toUpperCase();
                    this.addParam(paramName);
                    state = State.VALUE;
                    startIndex = i + 1;
                    continue;
                }
                if (state == State.PARAM_VALUE) {
                    if (currentChar == '\"') {
                        state = State.QUOTED_PARAM_VALUE;
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar == ':') {
                        if (startIndex < i) {
                            paramValues = this.addParamValue(paramValues, line.substring(startIndex, i));
                        }
                        this.addParam(paramName, paramValues);
                        state = State.VALUE;
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar == ';') {
                        if (startIndex < i) {
                            paramValues = this.addParamValue(paramValues, line.substring(startIndex, i));
                        }
                        this.addParam(paramName, paramValues);
                        state = State.PARAM_NAME;
                        startIndex = i + 1;
                        continue;
                    }
                    if (currentChar != ',') continue;
                    if (startIndex < i) {
                        paramValues = this.addParamValue(paramValues, line.substring(startIndex, i));
                    }
                    startIndex = i + 1;
                    continue;
                }
                if (state == State.QUOTED_PARAM_VALUE) {
                    if (currentChar != '\"') continue;
                    state = State.PARAM_VALUE;
                    paramValues = this.addParamValue(paramValues, line.substring(startIndex, i));
                    startIndex = i + 1;
                    continue;
                }
                if (state == State.VALUE) {
                    if (currentChar == '\\') {
                        state = State.BACKSLASH;
                        continue;
                    }
                    if (currentChar != ';' && (!MULTIVALUED_PROPERTIES.contains(this.key) || currentChar != ',')) continue;
                    this.addValue(line.substring(startIndex, i));
                    startIndex = i + 1;
                    continue;
                }
                if (state != State.BACKSLASH) continue;
                state = State.VALUE;
            }
            if (state == State.VALUE) {
                this.addValue(line.substring(startIndex));
            } else {
                throw new IllegalArgumentException("Invalid property line: " + line);
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public List<String> getValues() {
        return this.values;
    }

    public Map<String, String> getValuesAsMap() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (this.values != null) {
            for (String value : this.values) {
                if (!value.contains("=")) continue;
                int index = value.indexOf("=");
                valuesMap.put(value.substring(0, index), value.substring(index + 1));
            }
        }
        return valuesMap;
    }

    public boolean hasParam(String paramName, String paramValue) {
        return this.params != null && this.getParam(paramName) != null && this.containsIgnoreCase(this.getParam((String)paramName).values, paramValue);
    }

    public boolean hasParam(String paramName) {
        return this.params != null && this.getParam(paramName) != null;
    }

    public void removeParam(String paramName) {
        Param param;
        if (this.params != null && (param = this.getParam(paramName)) != null) {
            this.params.remove(param);
        }
    }

    protected boolean containsIgnoreCase(List<String> stringCollection, String value) {
        for (String collectionValue : stringCollection) {
            if (!value.equalsIgnoreCase(collectionValue)) continue;
            return true;
        }
        return false;
    }

    protected List<String> addParamValue(List<String> paramValues, String value) {
        List<String> result = paramValues;
        if (result == null) {
            result = new ArrayList<String>();
        }
        result.add(value);
        return result;
    }

    protected void addParam(String paramName) {
        this.addParam(paramName, (String)null);
    }

    public void setParam(String paramName, String paramValue) {
        Param currentParam = this.getParam(paramName);
        if (currentParam != null) {
            this.params.remove(currentParam);
        }
        this.addParam(paramName, paramValue);
    }

    public void addParam(String paramName, String paramValue) {
        if (paramValue != null) {
            ArrayList<String> paramValues = new ArrayList<String>();
            paramValues.add(paramValue);
            this.addParam(paramName, paramValues);
        }
    }

    protected void addParam(String paramName, List<String> paramValues) {
        Param currentParam;
        if (this.params == null) {
            this.params = new ArrayList<Param>();
        }
        if ((currentParam = this.getParam(paramName)) == null) {
            currentParam = new Param();
            currentParam.name = paramName;
            this.params.add(currentParam);
        }
        currentParam.addAll(paramValues);
    }

    protected Param getParam(String paramName) {
        if (this.params != null && paramName != null) {
            for (Param param : this.params) {
                if (!paramName.equals(param.name)) continue;
                return param;
            }
        }
        return null;
    }

    public String getParamValue(String paramName) {
        Param param = this.getParam(paramName);
        if (param != null) {
            return param.getValue();
        }
        return null;
    }

    protected List<Param> getParams() {
        return this.params;
    }

    protected void setParams(List<Param> params) {
        this.params = params;
    }

    protected void setValue(String value) {
        if (value == null) {
            this.values = null;
        } else {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            } else {
                this.values.clear();
            }
            this.values.add(this.decodeValue(value));
        }
    }

    protected void addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(this.decodeValue(value));
    }

    public void removeValue(String value) {
        if (this.values != null) {
            int index = -1;
            for (int i = 0; i < this.values.size(); ++i) {
                if (!value.equals(this.values.get(i))) continue;
                index = i;
            }
            if (index >= 0) {
                this.values.remove(index);
            }
        }
    }

    protected String decodeValue(String value) {
        if (value == null || value.indexOf(92) < 0 && value.indexOf(44) < 0) {
            return value;
        }
        StringBuilder decodedValue = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            int c = value.charAt(i);
            if (c == 92) {
                if (++i == value.length()) break;
                c = value.charAt(i);
                if (c == 110 || c == 78) {
                    c = 10;
                } else if (c == 114) {
                    c = 13;
                }
            }
            if (c == 44 && ("N".equals(this.key) || "NICKNAME".equals(this.key))) {
                c = 10;
            }
            decodedValue.append((char)c);
        }
        return decodedValue.toString();
    }

    public void setKey(String key) {
        int dotIndex = key.indexOf(46);
        this.key = dotIndex < 0 ? key : key.substring(dotIndex + 1);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.key);
        if (this.params != null) {
            for (Param param : this.params) {
                buffer.append(';').append(param.name);
                this.appendParamValues(buffer, param);
            }
        }
        buffer.append(':');
        if (this.values != null) {
            boolean firstValue = true;
            for (String value : this.values) {
                if (firstValue) {
                    firstValue = false;
                } else if (MULTIVALUED_PROPERTIES.contains(this.key)) {
                    buffer.append(',');
                } else {
                    buffer.append(';');
                }
                this.appendMultilineEncodedValue(buffer, value);
            }
        }
        return buffer.toString();
    }

    protected void appendParamValues(StringBuilder buffer, Param param) {
        if (param.values != null) {
            buffer.append('=');
            boolean first = true;
            for (String value : param.values) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                if ("CN".equalsIgnoreCase(param.name) || value.indexOf(59) >= 0 || value.indexOf(44) >= 0 || value.indexOf(40) >= 0 || value.indexOf(47) >= 0 || value.indexOf(58) >= 0) {
                    buffer.append('\"').append(value).append('\"');
                    continue;
                }
                buffer.append(value);
            }
        }
    }

    protected void appendMultilineEncodedValue(StringBuilder buffer, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\n') {
                buffer.append("\\n");
                continue;
            }
            if (MULTIVALUED_PROPERTIES.contains(this.key) && c == ',') {
                buffer.append('\\').append(',');
                continue;
            }
            if (c == '\r') continue;
            buffer.append(value.charAt(i));
        }
    }

    static {
        MULTIVALUED_PROPERTIES.add("RESOURCES");
        MULTIVALUED_PROPERTIES.add("LOCATION");
    }

    protected static class Param {
        String name;
        List<String> values;

        protected Param() {
        }

        public void addAll(List<String> paramValues) {
            if (this.values == null) {
                this.values = new ArrayList<String>();
            }
            this.values.addAll(paramValues);
        }

        protected String getValue() {
            if (this.values != null && !this.values.isEmpty()) {
                return this.values.get(0);
            }
            return null;
        }
    }

    protected static enum State {
        KEY,
        PARAM_NAME,
        PARAM_VALUE,
        QUOTED_PARAM_VALUE,
        VALUE,
        BACKSLASH;

    }
}

