/*
 * Decompiled with CFR 0.152.
 */
package davmail.exchange;

import davmail.Settings;
import davmail.exchange.ExchangeSession;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class MessageCreateThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(MessageCreateThread.class);
    boolean isComplete = false;
    ExchangeSession session;
    String folderPath;
    String messageName;
    HashMap<String, String> properties;
    MimeMessage mimeMessage;
    IOException exception;

    MessageCreateThread(String threadName, ExchangeSession session, String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage) {
        super(threadName + "-MessageCreate");
        this.setDaemon(true);
        this.session = session;
        this.folderPath = folderPath;
        this.messageName = messageName;
        this.properties = properties;
        this.mimeMessage = mimeMessage;
    }

    @Override
    public void run() {
        try {
            this.session.createMessage(this.folderPath, this.messageName, this.properties, this.mimeMessage);
        }
        catch (IOException e) {
            this.exception = e;
        }
        finally {
            this.isComplete = true;
        }
    }

    public static void createMessage(ExchangeSession session, String folderPath, String messageName, HashMap<String, String> properties, MimeMessage mimeMessage, OutputStream outputStream, String capabilities) throws InterruptedException, IOException {
        MessageCreateThread messageCreateThread = new MessageCreateThread(MessageCreateThread.currentThread().getName(), session, folderPath, messageName, properties, mimeMessage);
        messageCreateThread.start();
        while (!messageCreateThread.isComplete) {
            messageCreateThread.join(20000L);
            if (messageCreateThread.isComplete || !Settings.getBooleanProperty("davmail.enableKeepAlive", false)) continue;
            LOGGER.debug((Object)"Still loading message, send capabilities untagged response to avoid timeout");
            try {
                LOGGER.debug((Object)("* " + capabilities));
                outputStream.write(("* " + capabilities).getBytes(StandardCharsets.US_ASCII));
                outputStream.write(13);
                outputStream.write(10);
                outputStream.flush();
            }
            catch (SocketException e) {
                messageCreateThread.interrupt();
                throw e;
            }
        }
        if (messageCreateThread.exception != null) {
            throw messageCreateThread.exception;
        }
    }
}

