/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.gui.error;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.gui.error.ThrowableTreeCellRend;

class DThrowableDetail
extends PortecleJDialog {
    private final Throwable m_throwable;

    public DThrowableDetail(Window window, Throwable throwable) {
        super(window, true);
        this.m_throwable = throwable;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = this.getOkButton(true);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(FPortecle.RB.getString("DThrowableDetail.jbCopy.text"));
        jButton2.setMnemonic(FPortecle.RB.getString("DThrowableDetail.jbCopy.mnemonic").charAt(0));
        jButton2.setToolTipText(FPortecle.RB.getString("DThrowableDetail.jbCopy.tooltip"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DThrowableDetail.this.copyPressed();
            }
        });
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTree jTree = new JTree(this.createThrowableNodes());
        jTree.setRowHeight(18);
        jTree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(jTree);
        jTree.setCellRenderer(new ThrowableTreeCellRend());
        JScrollPane jScrollPane = new JScrollPane(jTree, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(500, 250));
        jPanel2.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle(FPortecle.RB.getString("DThrowableDetail.Title"));
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        this.setResizable(true);
        jButton.requestFocusInWindow();
    }

    private DefaultMutableTreeNode createThrowableNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(FPortecle.RB.getString("DThrowableDetail.RootNode.text"));
        for (Throwable throwable = this.m_throwable; throwable != null; throwable = throwable.getCause()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(throwable);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(stackTraceElement));
            }
        }
        return defaultMutableTreeNode;
    }

    private void copyPressed() {
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable = this.m_throwable;
        while (throwable != null) {
            stringBuilder.append(throwable);
            stringBuilder.append('\n');
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuilder.append('\t');
                stringBuilder.append(stackTraceElement);
                stringBuilder.append('\n');
            }
            if ((throwable = throwable.getCause()) == null) continue;
            stringBuilder.append('\n');
        }
        StackTraceElement[] stackTraceElementArray = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        stackTraceElementArray.setContents(stringSelection, stringSelection);
    }
}

