/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle.crypto;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.sf.portecle.crypto.KeyPairType;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public enum SignatureType {
    MD2withRSA(PKCSObjectIdentifiers.md2WithRSAEncryption.getId()),
    MD5withRSA(PKCSObjectIdentifiers.md5WithRSAEncryption.getId()),
    SHA1withRSA(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId()),
    SHA224withRSA(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId()),
    SHA256withRSA(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId()),
    SHA384withRSA(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId()),
    SHA512withRSA(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId()),
    RIPEMD128withRSA(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128.getId()),
    RIPEMD160withRSA(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160.getId()),
    RIPEMD256withRSA(TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256.getId()),
    SHA1withDSA(X9ObjectIdentifiers.id_dsa_with_sha1.getId()),
    SHA224withDSA(NISTObjectIdentifiers.dsa_with_sha224.getId()),
    SHA256withDSA(NISTObjectIdentifiers.dsa_with_sha256.getId()),
    SHA384withDSA(NISTObjectIdentifiers.dsa_with_sha384.getId()),
    SHA512withDSA(NISTObjectIdentifiers.dsa_with_sha512.getId()),
    SHA1withECDSA(X9ObjectIdentifiers.ecdsa_with_SHA1.getId()),
    SHA224withECDSA(X9ObjectIdentifiers.ecdsa_with_SHA224.getId()),
    SHA256withECDSA(X9ObjectIdentifiers.ecdsa_with_SHA256.getId()),
    SHA384withECDSA(X9ObjectIdentifiers.ecdsa_with_SHA384.getId()),
    SHA512withECDSA(X9ObjectIdentifiers.ecdsa_with_SHA512.getId());

    private static final Map<String, SignatureType> OID_MAP;
    private static final Map<KeyPairType, Collection<SignatureType>> KEYPAIR_MAP;
    private final String oid;

    private SignatureType(String string2) {
        this.oid = string2;
    }

    public static Collection<SignatureType> valuesFor(KeyPairType keyPairType) {
        Collection<SignatureType> collection = KEYPAIR_MAP.get((Object)keyPairType);
        if (collection == null) {
            collection = Collections.emptySet();
        }
        return collection;
    }

    public static SignatureType defaultFor(KeyPairType keyPairType) {
        switch (keyPairType) {
            case RSA: {
                return SHA256withRSA;
            }
            case DSA: {
                return SHA1withDSA;
            }
            case ECDSA: {
                return SHA1withECDSA;
            }
        }
        return null;
    }

    public static SignatureType valueOfOid(String string) {
        return OID_MAP.get(string);
    }

    public static String toString(String string) {
        SignatureType signatureType = SignatureType.valueOfOid(string);
        if (signatureType != null) {
            return signatureType.toString();
        }
        return string;
    }

    static {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (SignatureType signatureType : SignatureType.values()) {
            hashMap.put(signatureType.oid, (Object)signatureType);
        }
        OID_MAP = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put((Object)KeyPairType.DSA, Collections.unmodifiableSet(EnumSet.of(SHA1withDSA, SHA224withDSA, SHA256withDSA, SHA384withDSA, SHA512withDSA)));
        hashMap.put((Object)KeyPairType.RSA, Collections.unmodifiableSet(EnumSet.of(MD2withRSA, new SignatureType[]{MD5withRSA, SHA1withRSA, SHA224withRSA, SHA256withRSA, SHA384withRSA, SHA512withRSA, RIPEMD128withRSA, RIPEMD160withRSA, RIPEMD256withRSA})));
        hashMap.put((Object)KeyPairType.ECDSA, Collections.unmodifiableSet(EnumSet.of(SHA1withECDSA, SHA224withECDSA, SHA256withECDSA, SHA384withECDSA, SHA512withECDSA)));
        KEYPAIR_MAP = Collections.unmodifiableMap(hashMap);
    }
}

