# New and Noteworthy in OGRE 1.11

This is only a high level overview. For detailed changes, see the git changelog.

## Core changes

Ogre now requires a C++11 conforming compiler (at least gcc 4.8 or VS2013). Furthermore internal headers were moved into the src/ directory and are not installed any more when creating the SDK. This prevents you from accidentally using private API, while giving us more flexibility to change the implementation.

* Reduced Memory consumption of core classes
  - by reducing padding and using bitfields for flags, the memory consumption of e.g. `Pass` could be reduced by 11%.
  - see https://github.com/OGRECave/ogre/pull/665 for numbers of other classes

* Added strong typed `Affine3` matrix class.
  - overloads of `operator*`: no need to remember to call `transformAffine`, `concatenateAffine` etc. any more - everything is done and checked by the compiler automatically.
  - affine only methods moved from `Matrix4` to `Affine3`. e.g. `decomposition`, `getTrans`.
  - scale related functions moved from `Matrix4` to `Matrix3`: porting `.hasScale()` &rarr;  `.linear().hasScale()`
  - similarly `transformDirectionAffine` is now done by extracting the linear part via `linear()` and using `operator*` of `Matrix3`, that has now improved performance.

* New `SceneLoaderManager` API
  * you can now register classes derived from `SceneLoader`
  * calling `SceneLoaderManager::load("filename.ext", "Group", rootNode)` will then dispatch to a Loader supporting ".ext" (if available) and populate the given SceneManager starting at `rootNode`.

* `Image::flipAroundX/Y` now operate in-place instead of allocating temporary memory.

* `PF_DEPTH` now correctly works with `TU_RENDERTARGET`. This will create a depth-only FBO and give you the raw depth values, without needing any special shaders.

* Generic Image codecs (STB Image, FreeImage) are now plugins. For distribution you should use compressed textures (e.g. DDS) with precomputed mipmaps. Having the generic codecs as plugins allows you to easily disable them. Editing software on the other hand can now easily swap in a custom implementation (like QImage).

### Use plain STL where possible

* C++11ifycation: replace core classes by C++11 equivalents - particularly
  - SharedPtr -> `std::shared_ptr`. Note that due to its widespread usage, a SharedPtr wrapper class still exists for backwards compatibility.
  - AtomicScalar -> `std::atomic`
  - OGRE_HashMap -> `std::unordered_map`
  - _StringHash -> `std::hash< string >`
  - Timer: the platform specific implementations were replaced by wrapping 
  `std::chrono`.

* Removed container indirections. `Ogre::vector<int>::type`, is now just plain `std::vector<int>`. The Ogre version is still there to ease porting, but will generate a deprecation warning.

* drop Threading backport from 2.x, `std::thread` is now the preferred API.

* Memory Allocation cleanup
    * Drop MemoryTracker API. Nowadays [MSan](https://github.com/google/sanitizers/wiki/MemorySanitizer) is the better alternative.
    * drop builtin support for custom memory allocators. Consequently drop nedmalloc. Was only needed on WinXP. Empty class definitions are still there for compatibility. If you still want a different allocator you have to [do so globally](http://en.cppreference.com/w/cpp/memory/new/operator_new#Global_replacements).

### Platform independant OgreMain

Linking against OgreMain will no longer pull in any platform UI libraries (e.g. Cocoa, X11). The respective code was moved to OgreBites.

* `WindowEventUtilities` were moved to the Bites Component. They rely on low level platform code (like X11 on linux) and are mostly obsoleted by the ApplicationContext class. Generally you should be using SDL2/ Qt for windowing and just embed Ogre.

  Windows porting note: to continue using `WindowEventUtilities`, you now must explicitly register `_WndProc` for each window you create:
  ```
  NameValuePairList miscParams;
  miscParams["windowProc"] = 
      StringConverter::toString((size_t)WindowEventUtilities::_WndProc);
  RenderWindow* renderWindow = 
      Root::getSingleton().createRenderWindow(name, width, height, isFullScreen, &miscParams);
  WindowEventUtilities::_addRenderWindow(renderWindow);
  ```
  i.e. `Ogre::Root::initialise(True, ...)` does no longer work.

* similarly the `ConfigDialog` was moved to the Bites Component.

* unused `ErrorDialog` API was dropped

### Breaking non-API changes

These changes require unit testing on your side as compilation will succeed, but the rendering result may vary compared to 1.10.

* `TextureUnit` no longer caches any `Texture` state. All texture related calls now forward to the assigned Texture. If there is no Texture assigned, calls to e.g. `TextureUnitState::setNumMipmaps` have no effect.

* Textures must not be declared in an Ogre Script *and* be manually created. Ogre now immediately creates all Textures declared in scripts (in unloaded state). Previously it was possible to declare a texture name in the Material and create a manual texture before the material was fully loaded. This is not possible any more.
If you were relying on the old behaviour, you now must explicitly set the texture via `pass->getTextureUnitState(..)->setTexture(manualTex)`.

* default Light direction changed from `UNIT_Z` to `NEGATIVE_UNIT_Z` to be consistent with Cameras and SceneNodes. This will only cause issues if you were relying on the default direction. If you manually set it directly or via SceneNodes the results are the same. For legacy code with Lights attached to SceneNodes, just drop the `localDirectionVector` param.

* Mesh: does not use CPU shadow buffers by default any more. If you were relying on fast read access, you will have to explicitly request shadow buffers. Everybody else just saves memory now.

* AxisAlignedBox: do not cache corner positions to reduce memory usage

### Other

* drop RenderSystemCapabilities that were never set or that are supported everywhere

* `Archive` specializations e.g. `FileSystemArchive`, `ZipArchive` are now fully hidden. You must now use the respective Factories to create them.

* SceneManager: factored out SkyRenderer and ShadowRenderer helper classes. They enforce encapsulation and allow easier maintenance of the respective algorithms. In future this will be pluggable to allow for more sophisticated algorithms.


## CMake/ Build

Precompiled headers (PCH) support was rewritten and now works on GCC too (not yet with clang).
* PCHs are the predecessors of the Module TS (C++20)
* on both MSVC and GCC they speed up the build by about 2x
* Consequently the "Unity build" (rather hack) option was dropped

The `FindOGRE.cmake` script (deprecated in 1.10) was dropped in favour of the modern `OGREConfig.cmake` config-file package.
Additionally `OGREConfig.cmake` was upgraded to use export targets instead of variables.

This means that you now can just write
```python
target_link_libraries(YourApp OgreMain)
```
and all include path and additional libraries will be automatically handled. Using `${OGRE_INCLUDE_DIRS}` is not necessary any more.

New `OGRE_RESOURCEMANAGER_STRICT` options:

0. legacy mode that searches through all groups (slow)
1. pedantic mode that forces you to specify a resource group (cumbersome)
2. new strict mode that defaults to the default group

Note that you have to clear your CMake cache variable for the new values to work. Otherwise you will get compile errors due to the old values (ON/ OFF).

## Platforms
All platform headers were hidden and are now only available for internal usage. You are forced to use the cross platform API now. Alongside support for some obsolete platforms was dropped.
* Android: Android specific classes are now declared in the respective Main headers. e.g. APKZipArchive is in `OgreZip.h`
* iOS/ OSX: `macUtils.h` is hidden. Use the cross-platform alternatives in `FileSystemLayer` e.g. 
   - `iOSDocumentsDirectory()` -> `getWritablePath`
   - `macBundlePath()` -> `resolveBundlePath`
* Google NaCl platform support was removed. [See the official migration guide](https://developer.chrome.com/native-client/migration)
* MinGW (mingw-w64) is support again, including the D3D9 RenderSystem

## RT Shader System

Extend API for additional shader types (e.g. Geometry) and drop the separate HLSL4 handling. With D3D11 we now use the HLSL4 legacy mode which allows us to use the same shaders like for D3D9. This unifies the code and improves RTSS compatibility with D3D11.

## Overlay
Overlay scripts now support the standard ogrescript syntax and the `template` keyword is now optional. 
Furthermore the the `overlay_element` keyword unifies `container` and `element`, as there was little difference between those two.
So if you had a script like this

```cpp
template container BorderPanel(MyTemplates/BasicBorderPanel)
{
  ...
}

MyOverlays/AnotherOverlay
{
    zorder 490
    container BorderPanel(MyElements/BackPanel) : MyTemplates/BasicBorderPanel
    {
      ...
    }
}
```

you can (and should) now write

```cpp
overlay_element MyTemplates/BasicBorderPanel BorderPanel
{
  ...
}

overlay MyOverlays/AnotherOverlay
{
    zorder 490
    overlay_element MyElements/BackPanel BorderPanel : MyTemplates/BasicBorderPanel
    {
      ...
    }
}
```

in a later release the custom parser will be replaced by a standard ScriptTranslator. However to retain support for the old syntax it is kept for now. Consequently this means that script variables and abstract objects are not yet supported.

### Fontdef

The generic Ogre Script parser is now used for .fontdef scripts as well. Basically the same rule as for overlay scripts apply:

Where you had
```
MyFont
{
    type image
    source atlas.png
    glyph " 0.691406 0.343750 0.796875 0.515625
    ...
}
```

you should now write

```cpp
font MyFont
{
    type image
    source atlas.png
    glyph "\"" 0.691406 0.343750 0.796875 0.515625
    ...
}
```

Here, the glyph property needs extra care, as it may contain ogre script separators like `", }, :`, which must be explicitly marked as strings now, by wrapping them in `""` (as done in the sample above).

## BSP Plugin
* ported to the new `SceneLoader` API. Consequently `BspResourceManager` was replaced by `BspSceneLoader`.

## RenderSystems
* GL: bump required OpenGL version to 1.5 (Hardware from 2003)
* GL: no longer depends on GLU (deprecated since 2009)
* D3D9: improved compatibility with MinGW-w64
* GLES1: dropped GLES1 RenderSystem (deprecated since 1.8)

## Bites
This component finalized which allows us to drop the BETA status
* SDL2 classes are no longer exported through headers.
  * OgreBites SDLK_.. enum moved into the `OgreBites` namespace. Internal SDL2 fields no longer accessible.
* While the API still resembles SDL2, we can now swap the implementation to e.g. Qt without API breaks.

## Samples
Build all included samples as on SamplePlugin "DefaultSamples". This greatly simplifies the build and reduces build time while external Plugins are still supported.

