/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

class IFFUtil {
    private static final long[][] RTABLE = new long[][]{IFFUtil.rtable(0), IFFUtil.rtable(1), IFFUtil.rtable(2), IFFUtil.rtable(3), IFFUtil.rtable(4), IFFUtil.rtable(5), IFFUtil.rtable(6), IFFUtil.rtable(7)};

    IFFUtil() {
    }

    private static long[] rtable(int n) {
        return new long[]{0L << n, 1L << n, 256L << n, 257L << n, 65536L << n, 65537L << n, 65792L << n, 65793L << n, 0x1000000L << n, 0x1000001L << n, 0x1000100L << n, 0x1000101L << n, 0x1010000L << n, 0x1010001L << n, 0x1010100L << n, 0x1010101L << n};
    }

    static void bitRotateCW(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < 8; ++i) {
            int n6 = byArray[n5] & 0xF;
            int n7 = byArray[n5] >> 4 & 0xF;
            l |= RTABLE[i][n6];
            l2 |= RTABLE[i][n7];
            n5 += n2;
        }
        n5 = n3;
        byArray2[n5] = (byte)(l2 >> 24 & 0xFFL);
        if ((n5 += n4) < byArray2.length) {
            byArray2[n5] = (byte)(l2 >> 16 & 0xFFL);
            if ((n5 += n4) < byArray2.length) {
                byArray2[n5] = (byte)(l2 >> 8 & 0xFFL);
                if ((n5 += n4) < byArray2.length) {
                    byArray2[n5] = (byte)(l2 & 0xFFL);
                    n5 += n4;
                }
            }
        }
        if (n5 < byArray2.length) {
            byArray2[n5] = (byte)(l >> 24 & 0xFFL);
            if ((n5 += n4) < byArray2.length) {
                byArray2[n5] = (byte)(l >> 16 & 0xFFL);
                if ((n5 += n4) < byArray2.length) {
                    byArray2[n5] = (byte)(l >> 8 & 0xFFL);
                    if ((n5 += n4) < byArray2.length) {
                        byArray2[n5] = (byte)(l & 0xFFL);
                    }
                }
            }
        }
    }

    static void bitRotateCCW(int[] nArray, int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n;
        long l = 0L;
        long l2 = 0L;
        for (int i = 7; i >= 0; --i) {
            int n6 = nArray[n5] & 0xF;
            int n7 = nArray[n5] >> 4 & 0xF;
            l |= RTABLE[i][n6];
            l2 |= RTABLE[i][n7];
            n5 += n2;
        }
        n5 = n3;
        byArray[n5] = (byte)(l & 0xFFL);
        byArray[n5 += n4] = (byte)(l >> 8 & 0xFFL);
        byArray[n5 += n4] = (byte)(l >> 16 & 0xFFL);
        byArray[n5 += n4] = (byte)(l >> 24 & 0xFFL);
        byArray[n5 += n4] = (byte)(l2 & 0xFFL);
        byArray[n5 += n4] = (byte)(l2 >> 8 & 0xFFL);
        byArray[n5 += n4] = (byte)(l2 >> 16 & 0xFFL);
        byArray[n5 += n4] = (byte)(l2 >> 24 & 0xFFL);
    }

    static void bitRotateCCW(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n;
        long l = 0L;
        long l2 = 0L;
        for (int i = 7; i >= 0; --i) {
            int n6 = byArray[n5] & 0xF;
            int n7 = byArray[n5] >> 4 & 0xF;
            l |= RTABLE[i][n6];
            l2 |= RTABLE[i][n7];
            n5 += n2;
        }
        n5 = n3;
        byArray2[n5] = (byte)(l & 0xFFL);
        byArray2[n5 += n4] = (byte)(l >> 8 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l >> 16 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l >> 24 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l2 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l2 >> 8 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l2 >> 16 & 0xFFL);
        byArray2[n5 += n4] = (byte)(l2 >> 24 & 0xFFL);
    }

    static int toInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    static String toChunkStr(int n) {
        return new String(new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)});
    }
}

