/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.sessioninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrame;
import net.sourceforge.squirrel_sql.plugins.oracle.OracleInternalFrameCallback;
import net.sourceforge.squirrel_sql.plugins.oracle.sessioninfo.GetSessionInfoAction;
import net.sourceforge.squirrel_sql.plugins.oracle.sessioninfo.SessionInfoPanel;

public class SessionInfoInternalFrame
extends OracleInternalFrame {
    private static final String PREF_PART_INFO_FRAME = "InfoFrame";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionInfoInternalFrame.class);
    private SessionInfoPanel _sessionInfoPanel;
    private SessionInfoToolBar _toolBar;
    private Resources _resources;

    public SessionInfoInternalFrame(ISession session, Resources resources) {
        super(session, s_stringMgr.getString("oracle.infoTitle", new Object[]{session.getTitle()}));
        this._resources = resources;
        this.createGUI(session);
    }

    public SessionInfoPanel getDBOutputPanel() {
        return this._sessionInfoPanel;
    }

    private void createGUI(ISession session) {
        this.addWidgetListener((WidgetListener)new WidgetAdapter(){

            public boolean widgetClosing(WidgetEvent e) {
                SessionInfoInternalFrame.super.internalFrameClosing(SessionInfoInternalFrame.this._toolBar.isStayOnTop(), SessionInfoInternalFrame.this._sessionInfoPanel.getAutoRefreshPeriod());
                SessionInfoInternalFrame.this._sessionInfoPanel.setAutoRefresh(false);
                return true;
            }
        });
        ImageIcon icon = this._resources.getIcon(((Object)((Object)this)).getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        OracleInternalFrameCallback cb = new OracleInternalFrameCallback(){

            @Override
            public void createPanelAndToolBar(boolean stayOnTop, int autoRefeshPeriod) {
                SessionInfoInternalFrame.this._sessionInfoPanel = new SessionInfoPanel(SessionInfoInternalFrame.this.getSession(), autoRefeshPeriod);
                SessionInfoInternalFrame.this._toolBar = new SessionInfoToolBar(SessionInfoInternalFrame.this.getSession(), stayOnTop, autoRefeshPeriod);
                JPanel contentPanel = new JPanel(new BorderLayout());
                contentPanel.add((Component)((Object)SessionInfoInternalFrame.this._toolBar), "North");
                contentPanel.add((Component)SessionInfoInternalFrame.this._sessionInfoPanel, "Center");
                SessionInfoInternalFrame.this.setContentPane(contentPanel);
                SessionInfoInternalFrame.this._sessionInfoPanel.setAutoRefreshPeriod(autoRefeshPeriod);
            }
        };
        this.initFromPrefs(PREF_PART_INFO_FRAME, cb);
    }

    private class SessionInfoToolBar
    extends OracleInternalFrame.OracleToolBar {
        SessionInfoToolBar(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            this.createGUI(session, stayOnTop, autoRefeshPeriod);
        }

        private void createGUI(ISession session, boolean stayOnTop, int autoRefeshPeriod) {
            IApplication app = session.getApplication();
            this.setUseRolloverButtons(true);
            this.setFloatable(false);
            this.add((Action)((Object)new GetSessionInfoAction(app, SessionInfoInternalFrame.this._resources, SessionInfoInternalFrame.this._sessionInfoPanel)));
            this.addStayOnTop(stayOnTop);
            final JCheckBox autoRefresh = new JCheckBox(s_stringMgr.getString("oracle.auotRefresh2"), false);
            autoRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SessionInfoInternalFrame.this._sessionInfoPanel.setAutoRefresh(autoRefresh.isSelected());
                }
            });
            this.add(autoRefresh);
            final SpinnerNumberModel model = new SpinnerNumberModel(autoRefeshPeriod, 1, 60, 5);
            JSpinner refreshRate = new JSpinner(model);
            refreshRate.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SessionInfoInternalFrame.this._sessionInfoPanel.setAutoRefreshPeriod(model.getNumber().intValue());
                }
            });
            this.add(refreshRate);
            this.add(new JLabel(s_stringMgr.getString("oracle.secons3")));
        }
    }
}

