/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.PersistentCollectionType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.RootResultController;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.RootType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResultController;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelResultController;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.TupelType;

public class ResultsController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultsController.class);
    private JPanel _pnlResults;
    private ArrayList<MappedClassInfo> _allMappedClassInfos;
    private ISession _session;
    private MultipleLineLabel _lblClear;

    public ResultsController(JPanel pnlResults, String hqlQuery, ArrayList<MappedClassInfo> allMappedClassInfos, ISession session) {
        this._pnlResults = pnlResults;
        this._allMappedClassInfos = allMappedClassInfos;
        this._session = session;
        this._lblClear = this.createClearLabel(hqlQuery);
        this.clear();
    }

    private MultipleLineLabel createClearLabel(String hqlQuery) {
        MultipleLineLabel ret = new MultipleLineLabel(s_stringMgr.getString("ResultsController.resultDescription", new Object[]{hqlQuery}));
        return ret;
    }

    public void typeChanged(Object type) {
        if (type instanceof RootType) {
            new RootResultController((RootType)type, this._pnlResults, this._allMappedClassInfos);
        } else if (type instanceof TupelType) {
            new TupelResultController((TupelType)type, this._pnlResults, this._allMappedClassInfos);
        } else if (type instanceof SingleType) {
            new SingleResultController((SingleType)type, this._pnlResults, this._session);
        } else if (type instanceof PersistentCollectionType) {
            PersistentCollectionType persistentCollectionType = (PersistentCollectionType)type;
            new SingleResultController(persistentCollectionType.getSingleType(), this._pnlResults, this._session);
        }
        this._pnlResults.validate();
        this._pnlResults.repaint();
    }

    public void clear() {
        this._pnlResults.removeAll();
        this._pnlResults.add(new JScrollPane((Component)this._lblClear));
        this._lblClear.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this._pnlResults.validate();
        this._pnlResults.repaint();
    }
}

