/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;
import unity.mapping.DatabaseMapping;
import unity.operators.MergeSort;
import unity.operators.Operator;
import unity.operators.SortGrouper;
import unity.predicates.ExprSortComparator;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GlobalQuery;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQGroupByNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private ArrayList<LQExprNode> groupList = new ArrayList();
    private ArrayList<LQExprNode> functionList = new ArrayList();

    public LQGroupByNode() {
        this.type = 5;
    }

    public void addGroupByExpression(LQExprNode lQExprNode) {
        this.groupList.add(lQExprNode);
    }

    public LQExprNode findAggregateFunction(LQExprNode lQExprNode) {
        String string = lQExprNode.toString();
        for (int i = 0; i < this.functionList.size(); ++i) {
            LQExprNode lQExprNode2 = this.functionList.get(i);
            if (!lQExprNode2.toString().equals(string)) continue;
            return lQExprNode2;
        }
        return null;
    }

    public void addAggregateFunction(LQExprNode lQExprNode) {
        this.functionList.add(lQExprNode);
    }

    public boolean isEmpty() {
        return this.groupList.size() == 0 && this.functionList.size() == 0;
    }

    public boolean isEmptyGrouping() {
        return this.groupList.size() == 0;
    }

    public void validateField(LQExprNode lQExprNode) throws SQLException {
        Object object;
        Cloneable cloneable;
        for (int i = 0; i < this.groupList.size(); ++i) {
            cloneable = this.groupList.get(i);
            if (((LQExprNode)cloneable).toString().equals(lQExprNode.toString())) {
                return;
            }
            if (lQExprNode.getType() != 103) continue;
            object = lQExprNode.getChild(0).toString();
            if (((String)object).equalsIgnoreCase(((LQExprNode)cloneable).toString())) {
                return;
            }
            object = lQExprNode.getChild(1).toString();
            if (!((String)object).equalsIgnoreCase(((LQExprNode)cloneable).toString())) continue;
            return;
        }
        Stack<LQNode> stack = new Stack<LQNode>();
        stack.push(lQExprNode);
        cloneable = new ArrayList();
        while (!stack.empty()) {
            object = (LQExprNode)stack.pop();
            if (((LQNode)object).getType() == 100) {
                ((ArrayList)cloneable).add(((LQNode)object).getContent());
                continue;
            }
            if (((LQNode)object).getType() == 103) {
                stack.push(((LQNode)object).getChild(0));
                continue;
            }
            if (((LQNode)object).getType() == 17 || ((LQNode)object).getType() == 125) continue;
            for (int i = 0; i < ((LQNode)object).getNumChildren(); ++i) {
                stack.push(((LQNode)object).getChild(i));
            }
        }
        int n = 0;
        if (n < ((ArrayList)cloneable).size()) {
            GQFieldRef gQFieldRef = (GQFieldRef)((ArrayList)cloneable).get(n);
            for (int i = 0; i < this.groupList.size(); ++i) {
                LQExprNode lQExprNode2 = this.groupList.get(i);
                if (lQExprNode2.getContent() != gQFieldRef) continue;
                return;
            }
            throw new SQLException("Field: " + gQFieldRef.getName() + " is not in GROUP BY or aggregate function in a GROUPING query.");
        }
    }

    public static boolean isAggregateFunction(String string) {
        if (string.equalsIgnoreCase("COUNT") || string.equalsIgnoreCase("MAX") || string.equalsIgnoreCase("MIN") || string.equalsIgnoreCase("AVG") || string.equalsIgnoreCase("SUM") || string.equalsIgnoreCase("GROUP_CONCAT") || string.equalsIgnoreCase("STD") || string.equalsIgnoreCase("STDDEV") || string.equalsIgnoreCase("VARIANCE") || string.equalsIgnoreCase("BIT_AND") || string.equalsIgnoreCase("BIT_OR") || string.equalsIgnoreCase("BIT_XOR")) {
            return true;
        }
        Class clazz = LQExprNode.findClass("A_" + LQExprNode.formatFunctionName(string));
        if (clazz != null) {
            try {
                clazz.asSubclass(Aggregate_Function.class);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return clazz != null;
    }

    @Override
    public String generateSQL() {
        if (this.groupList == null || this.groupList.size() == 0) {
            return "";
        }
        if (this.groupList.size() > 0) {
            String string = this.groupList.get(0).generateSQL();
            for (int i = 1; i < this.groupList.size(); ++i) {
                LQExprNode lQExprNode = this.groupList.get(i);
                string = string + ", " + lQExprNode.generateSQL();
            }
            return string;
        }
        return null;
    }

    @Override
    public String toString() {
        String string = this.generateSQL();
        if (string.equals("")) {
            string = "(no grouping attributes)";
        }
        String string2 = "";
        for (int i = 0; i < this.functionList.size(); ++i) {
            LQExprNode lQExprNode = this.functionList.get(i);
            string2 = string2 + lQExprNode.generateSQL() + " ";
        }
        return "GROUPBY: " + string + " Computed functions: " + string2 + super.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        SortGrouper sortGrouper;
        Attribute[] attributeArray = new Attribute[this.groupList.size() + this.functionList.size()];
        Relation relation = ((LQNode)this.children.get(0)).getOutputRelation();
        Expression[] expressionArray = new Expression[this.groupList.size()];
        for (int i = 0; i < this.groupList.size(); ++i) {
            attributeArray[i] = new Attribute();
            expressionArray[i] = this.groupList.get(i).buildExpression(relation, attributeArray[i], globalQuery, subQuery, null);
        }
        Aggregate_Function[] aggregate_FunctionArray = new Aggregate_Function[this.functionList.size()];
        for (int i = 0; i < this.functionList.size(); ++i) {
            attributeArray[i + this.groupList.size()] = new Attribute();
            aggregate_FunctionArray[i] = (Aggregate_Function)this.functionList.get(i).buildExpression(relation, attributeArray[i + this.groupList.size()], globalQuery, subQuery, null);
        }
        this.outputRelation = new Relation(attributeArray);
        if (this.groupList.size() > 0) {
            boolean[] blArray = new boolean[this.groupList.size()];
            for (int i = 0; i < this.groupList.size(); ++i) {
                blArray[i] = true;
            }
            ExprSortComparator exprSortComparator = new ExprSortComparator(expressionArray, blArray);
            int n = 10000000;
            MergeSort mergeSort = new MergeSort(operatorArray[0], n, exprSortComparator, this);
            sortGrouper = new SortGrouper(mergeSort, exprSortComparator, expressionArray, aggregate_FunctionArray, this.outputRelation, this);
        } else {
            sortGrouper = new SortGrouper(operatorArray[0], null, expressionArray, aggregate_FunctionArray, this.outputRelation, this);
        }
        this.setOperator(sortGrouper);
        return sortGrouper;
    }

    public ArrayList<Object> getProjectedFields(ArrayList<Object> arrayList) {
        for (int i = 0; i < this.groupList.size(); ++i) {
            LQExprNode lQExprNode = this.groupList.get(i);
            if (lQExprNode.getType() != 100) continue;
            arrayList.add(lQExprNode.getContent());
        }
        return arrayList;
    }

    public ArrayList<Object> getProjectedFunctionExpr(ArrayList<Object> arrayList) {
        for (int i = 0; i < this.functionList.size(); ++i) {
            LQExprNode lQExprNode = this.functionList.get(i);
            arrayList.addAll(lQExprNode.getRequiredFields());
        }
        return arrayList;
    }

    public ArrayList<LQExprNode> getExpressions() {
        return this.groupList;
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getProjectedFields(arrayList).addAll(this.getProjectedFunctionExpr(arrayList));
        return arrayList;
    }

    @Override
    public int numTuples() {
        if (this.getNumChildren() == 1) {
            return ((LQNode)this.children.get(0)).numTuples();
        }
        return 0;
    }

    @Override
    public int tupleSize() {
        ArrayList<Object> arrayList = this.getRequiredFields();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            GQFieldRef gQFieldRef = (GQFieldRef)arrayList.get(i);
            int n2 = gQFieldRef.getField().getByteSize();
            n += n2;
        }
        return n;
    }

    public ArrayList<LQExprNode> getFunctionList() {
        return this.functionList;
    }

    public ArrayList<LQExprNode> getGroupList() {
        return this.groupList;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        GQDatabaseRef gQDatabaseRef2;
        int n;
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (DatabaseMapping.isSupported("#GROUPBY#", this.database, null) != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        for (n = 0; n < this.groupList.size(); ++n) {
            gQDatabaseRef2 = this.groupList.get(n).setDatabase(this.getDatabase(), bl);
            if (gQDatabaseRef2 == null) continue;
            hashSet.add(gQDatabaseRef2);
        }
        for (n = 0; n < this.functionList.size(); ++n) {
            gQDatabaseRef2 = this.functionList.get(n).setDatabase(this.getDatabase(), bl);
            if (gQDatabaseRef2 == null) continue;
            hashSet.add(gQDatabaseRef2);
        }
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        int n = this.getChild(0).tupleSize();
        this.cost = (double)(3L * l) * (1.0 + 0.005 * (double)n);
        this.rows = l * 1L;
    }
}

