/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.io.Serializable;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.jdbc.UnityDriver;
import unity.predicates.JoinPredicate;
import unity.predicates.SelectionPredicate;
import unity.util.HashFunc;

public class ExprJoinPredicate
extends JoinPredicate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Expression[] exps1;
    private Expression[] exps2;
    private Object[] vals;

    public ExprJoinPredicate(Expression[] expressionArray, Expression[] expressionArray2, SelectionPredicate selectionPredicate) {
        this.exps1 = expressionArray;
        this.exps2 = expressionArray2;
        this.filterPredicate = selectionPredicate;
        this.vals = new Object[this.exps1.length];
    }

    @Override
    public JoinPredicate inversePredicate() {
        ExprJoinPredicate exprJoinPredicate = new ExprJoinPredicate(this.exps2, this.exps1, this.filterPredicate);
        exprJoinPredicate.inverse = true;
        return exprJoinPredicate;
    }

    @Override
    public boolean isEqual(Tuple tuple, Tuple tuple2) throws SQLException {
        try {
            for (int i = 0; i < this.exps1.length; ++i) {
                Object object = this.exps1[i].evaluate(tuple);
                if (object == null) {
                    return false;
                }
                Object object2 = this.exps2[i].evaluate(tuple2);
                if (object2 == null) {
                    return false;
                }
                if (JoinPredicate.compare(object, object2)) continue;
                return false;
            }
            if (this.filterPredicate == null) {
                return true;
            }
            return this.evaluateFilter(tuple, tuple2);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("JoinPredicate.ComparatorError") + exception);
        }
    }

    @Override
    public boolean isLessThan(Tuple tuple, Tuple tuple2) throws SQLException {
        try {
            for (int i = 0; i < this.exps1.length; ++i) {
                Comparable comparable = (Comparable)this.exps1[i].evaluate(tuple);
                Comparable comparable2 = (Comparable)this.exps2[i].evaluate(tuple2);
                if (comparable != null && comparable2 != null) {
                    int n = comparable.compareTo(comparable2);
                    if (n == 0) continue;
                    return n < 0;
                }
                if (comparable == null && comparable2 != null) {
                    return true;
                }
                if (comparable != null && comparable2 == null) {
                    return false;
                }
                if (comparable != null || comparable2 != null || i != this.exps1.length - 1) continue;
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("JoinPredicate.ComparatorError") + exception);
        }
    }

    @Override
    public String toString(Relation relation, Relation relation2) {
        StringBuilder stringBuilder = new StringBuilder(250);
        if (this.exps1.length > 0) {
            stringBuilder.append(this.exps1[0].toString(relation) + " = " + this.exps2[0].toString(relation2));
            for (int i = 1; i < this.exps1.length; ++i) {
                stringBuilder.append(" AND " + this.exps1[i].toString(relation) + " = " + this.exps2[i].toString(relation2));
            }
        }
        if (this.filterPredicate != null) {
            Relation relation3 = new Relation(relation);
            relation3.mergeRelation(relation2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.filterPredicate.toString(relation3));
        }
        return stringBuilder.toString();
    }

    @Override
    public int getHashKeyInput1(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.exps1);
    }

    @Override
    public int getHashKeyInput2(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.exps2);
    }

    private int getHashKey(Tuple tuple, Expression[] expressionArray) throws SQLException {
        for (int i = 0; i < expressionArray.length; ++i) {
            this.vals[i] = expressionArray[i].evaluate(tuple);
            if (this.vals[i] != null) continue;
            tuple.setStatus((byte)1);
            return 0;
        }
        tuple.setStatus((byte)0);
        return HashFunc.hash(this.vals);
    }

    @Override
    public boolean isEquiJoin() {
        return true;
    }
}

