/*
 * Decompiled with CFR 0.152.
 */
package unity.mapping;

import java.io.BufferedReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.CommonMethods;
import unity.annotation.SourceDatabase;
import unity.engine.Relation;
import unity.jdbc.UnityDriver;
import unity.mapping.Database;
import unity.mapping.DatabaseFunction;
import unity.mapping.Driver;
import unity.mapping.GlobalFunction;
import unity.mapping.TypeInfo;
import unity.query.GQDatabaseRef;
import unity.query.LQExprNode;
import unity.query.LQNode;

public class DatabaseMapping {
    private static HashMap<String, GlobalFunction> functions = new HashMap();
    private static HashMap<Integer, Database> databases = new HashMap();
    private static TreeMap<String, Driver> drivers = new TreeMap();
    private static HashMap<String, DatabaseFunction> dbfunctions = new HashMap();
    private static HashMap<Integer, TypeInfo> types = new HashMap();

    public static void load(BufferedReader bufferedReader) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Document document = null;
        try {
            object6 = DocumentBuilderFactory.newInstance();
            object5 = ((DocumentBuilderFactory)object6).newDocumentBuilder();
            object4 = new InputSource(bufferedReader);
            document = ((DocumentBuilder)object5).parse((InputSource)object4);
        }
        catch (Exception exception) {
            throw new SQLException(UnityDriver.i18n.getString("DatabaseMapping.ReadFileError") + exception.toString());
        }
        object6 = document.getDocumentElement();
        object5 = object6.getFirstChild();
        if (object5.getNodeType() == 3) {
            object5 = object5.getNextSibling();
        }
        for (object4 = object5.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            if (!object4.getNodeName().equals("UnityType")) continue;
            object3 = new TypeInfo();
            ((TypeInfo)object3).importXML((Node)object4);
            types.put(((TypeInfo)object3).getUnityId(), (TypeInfo)object3);
        }
        object3 = object5.getNextSibling();
        if (object3.getNodeType() == 3) {
            object3 = object3.getNextSibling();
        }
        for (object4 = object3.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            if (!object4.getNodeName().equals("Database")) continue;
            object2 = new Database();
            ((Database)object2).importXML((Node)object4);
            databases.put(((Database)object2).getDatabaseId(), (Database)object2);
        }
        object5 = object3.getNextSibling();
        if (object5.getNodeType() == 3) {
            object5 = object5.getNextSibling();
        }
        for (object4 = object5.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            if (!object4.getNodeName().equals("Driver")) continue;
            object2 = new Driver();
            ((Driver)object2).importXML((Node)object4);
            drivers.put(((Driver)object2).getName(), (Driver)object2);
        }
        object2 = object5.getNextSibling();
        if (object2.getNodeType() == 3) {
            object2 = object2.getNextSibling();
        }
        for (object4 = object2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            if (!object4.getNodeName().equals("Function")) continue;
            object = new GlobalFunction();
            ((GlobalFunction)object).importXML((Node)object4);
            functions.put(((GlobalFunction)object).getKey(), (GlobalFunction)object);
        }
        if ((object2 = object2.getNextSibling()).getNodeType() == 3) {
            object2 = object2.getNextSibling();
        }
        for (object4 = object2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
            String string;
            Database database;
            if (!object4.getNodeName().equals("Database")) continue;
            object = object4.getFirstChild();
            if (object.getNodeType() == 3) {
                object = object.getNextSibling();
            }
            if ((database = databases.get(Integer.parseInt(string = CommonMethods.getName((Node)object)))) == null) continue;
            if ((object = object.getNextSibling()).getNodeType() == 3) {
                object = object.getNextSibling();
            }
            for (object = object.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!object.getNodeName().equals("Function")) continue;
                DatabaseFunction databaseFunction = new DatabaseFunction(database);
                databaseFunction.importXML((Node)object);
                dbfunctions.put(databaseFunction.getKey(), databaseFunction);
            }
        }
    }

    public static String convert(LQExprNode lQExprNode) {
        StringBuffer stringBuffer = new StringBuffer(100);
        GQDatabaseRef gQDatabaseRef = lQExprNode.getDatabase();
        String string = lQExprNode.getContent().toString().toUpperCase();
        DatabaseFunction databaseFunction = DatabaseMapping.getMapping(string, gQDatabaseRef, lQExprNode);
        if (databaseFunction != null) {
            return databaseFunction.generate(lQExprNode);
        }
        GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
        if (globalFunction != null) {
            ArrayList<String> arrayList = DatabaseFunction.generateChildren(lQExprNode);
            return DatabaseFunction.generate(globalFunction.getExprText(), lQExprNode, arrayList);
        }
        stringBuffer.append(lQExprNode.getContent() + "(");
        if (lQExprNode.getNumChildren() > 0) {
            stringBuffer.append(((LQExprNode)lQExprNode.getChild(0)).generateSQL());
        }
        for (int i = 1; i < lQExprNode.getNumChildren(); ++i) {
            stringBuffer.append(',' + ((LQExprNode)lQExprNode.getChild(i)).generateSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String convertPig(LQExprNode lQExprNode, Relation relation) {
        StringBuffer stringBuffer = new StringBuffer(100);
        GQDatabaseRef gQDatabaseRef = lQExprNode.getDatabase();
        String string = lQExprNode.getContent().toString().toUpperCase();
        DatabaseFunction databaseFunction = DatabaseMapping.getMapping(string, gQDatabaseRef, lQExprNode);
        if (databaseFunction != null) {
            return databaseFunction.generate(lQExprNode);
        }
        GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
        if (globalFunction != null) {
            ArrayList<String> arrayList = DatabaseFunction.generateChildrenPig(lQExprNode, relation);
            return DatabaseFunction.generate(globalFunction.getExprText(), lQExprNode, arrayList);
        }
        stringBuffer.append(lQExprNode.getContent() + "(");
        if (lQExprNode.getNumChildren() > 0) {
            stringBuffer.append(((LQExprNode)lQExprNode.getChild(0)).generatePig(relation));
        }
        for (int i = 1; i < lQExprNode.getNumChildren(); ++i) {
            stringBuffer.append(',' + ((LQExprNode)lQExprNode.getChild(i)).generatePig(relation));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String convert(String string, LQNode lQNode, ArrayList<String> arrayList, LQExprNode lQExprNode) {
        StringBuffer stringBuffer = new StringBuffer(100);
        GQDatabaseRef gQDatabaseRef = lQNode.getDatabase();
        DatabaseFunction databaseFunction = DatabaseMapping.getMapping(string, gQDatabaseRef, lQExprNode);
        if (databaseFunction == null) {
            stringBuffer.append(lQNode.getContent());
            return stringBuffer.toString();
        }
        return DatabaseFunction.generate(databaseFunction.getExprText(), lQNode, arrayList);
    }

    public static String convertUnity(String string, LQNode lQNode, ArrayList<String> arrayList, LQExprNode lQExprNode) {
        GQDatabaseRef gQDatabaseRef = lQNode.getDatabase();
        String string2 = DatabaseMapping.getMappingText(string, gQDatabaseRef, lQExprNode);
        return DatabaseFunction.generate(string2, lQNode, arrayList);
    }

    public static int isSupported(String string, GQDatabaseRef gQDatabaseRef, LQExprNode lQExprNode) {
        GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
        if (globalFunction == null) {
            return 0;
        }
        if (gQDatabaseRef == null) {
            return 2;
        }
        AnnotatedSourceDatabase annotatedSourceDatabase = gQDatabaseRef.getDatabase();
        if (annotatedSourceDatabase == null) {
            return 2;
        }
        Database database = databases.get(annotatedSourceDatabase.getDatabaseId());
        if (database == null) {
            return 2;
        }
        DatabaseFunction databaseFunction = DatabaseMapping.findDatabaseFunction(database, globalFunction.getUnityId());
        if (databaseFunction != null) {
            return 1;
        }
        return 2;
    }

    public static DatabaseFunction findDatabaseFunction(Database database, int n) {
        Database database2 = database;
        while (true) {
            String string;
            DatabaseFunction databaseFunction;
            if ((databaseFunction = dbfunctions.get(string = database2.getDatabaseId() + "-" + n)) != null) {
                if (databaseFunction.isSupported()) {
                    return databaseFunction;
                }
                return null;
            }
            if (database2.getParentDialect() == 0) break;
            database2 = databases.get(database2.getParentDialect());
        }
        return null;
    }

    public static DatabaseFunction getMapping(String string, GQDatabaseRef gQDatabaseRef, LQExprNode lQExprNode) {
        GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
        if (globalFunction == null) {
            return null;
        }
        if (gQDatabaseRef == null) {
            return null;
        }
        AnnotatedSourceDatabase annotatedSourceDatabase = gQDatabaseRef.getDatabase();
        if (annotatedSourceDatabase == null) {
            return null;
        }
        Database database = databases.get(annotatedSourceDatabase.getDatabaseId());
        if (database == null) {
            return null;
        }
        DatabaseFunction databaseFunction = DatabaseMapping.findDatabaseFunction(database, globalFunction.getUnityId());
        return databaseFunction;
    }

    public static TypeInfo getUnityType(int n) {
        return types.get(n);
    }

    public static TypeInfo getDatabaseType(int n, int n2) {
        TypeInfo typeInfo;
        Database database = databases.get(n2);
        if (database != null && (typeInfo = DatabaseMapping.findDatabaseType(n, database)) != null) {
            return typeInfo;
        }
        return types.get(n);
    }

    public static TypeInfo findDatabaseType(int n, Database database) {
        Database database2 = database;
        while (true) {
            TypeInfo typeInfo;
            if ((typeInfo = database2.getType(n)) != null) {
                return typeInfo;
            }
            if (database2.getParentDialect() == 0) break;
            database2 = databases.get(database2.getParentDialect());
        }
        return null;
    }

    public static String getMappingText(String string, GQDatabaseRef gQDatabaseRef, LQExprNode lQExprNode) {
        if (gQDatabaseRef == null) {
            GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
            if (globalFunction == null) {
                return "";
            }
            return globalFunction.getExprText();
        }
        DatabaseFunction databaseFunction = DatabaseMapping.getMapping(string, gQDatabaseRef, lQExprNode);
        if (databaseFunction == null) {
            GlobalFunction globalFunction = DatabaseMapping.getFunction(string, lQExprNode);
            if (globalFunction == null) {
                return "";
            }
            return globalFunction.getExprText();
        }
        return databaseFunction.getExprText();
    }

    public static GlobalFunction getFunction(String string, LQExprNode lQExprNode) {
        String string2;
        GlobalFunction globalFunction;
        String string3 = string.toUpperCase();
        if (lQExprNode != null && (globalFunction = functions.get(string2 = string3 + '-' + lQExprNode.getNumChildren())) != null) {
            return globalFunction;
        }
        globalFunction = functions.get(string3);
        if (globalFunction != null) {
            return globalFunction;
        }
        return null;
    }

    public static Database getDatabase(SourceDatabase sourceDatabase) {
        String string = sourceDatabase.getDatabaseProductName().toLowerCase();
        String string2 = sourceDatabase.getDatabaseProductVersion();
        Database database = null;
        if (string.contains("microsoft sql")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            if (string3 == null || string4 == null) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2008");
            } else if (string3.equals("6")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 6.5");
            } else if (string3.equals("7")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 7.0");
            } else if (string3.equals("8")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2000");
            } else if (string3.equals("9")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2005");
            } else if (string3.equals("10") && string4.equals("00")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2008");
            } else if (string3.equals("11") && string4.equals("00")) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2010");
            }
            if (database == null) {
                database = DatabaseMapping.findDatabase("Microsoft SQL Server 2008");
            }
        } else if (string.contains("access")) {
            database = DatabaseMapping.findDatabase("Microsoft Access 2007");
            if (string2.contains("5.0")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 2010");
            } else if (string2.contains("4.0")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 2007");
            } else if (string2.contains("2003")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 2003");
            } else if (string2.contains("2002")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 2002");
            } else if (string2.contains("2000")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 2000");
            } else if (string2.contains("3.5")) {
                database = DatabaseMapping.findDatabase("Microsoft Access 97");
            }
        } else if (string.contains("mysql")) {
            database = string2.contains("5.5") ? DatabaseMapping.findDatabase("MySQL 5.5") : (string2.contains("5.1") ? DatabaseMapping.findDatabase("MySQL 5.1") : DatabaseMapping.findDatabase("MySQL 5.0"));
        } else if (string.contains("postgres")) {
            database = string2.length() > 0 && string2.charAt(0) == '9' ? DatabaseMapping.findDatabase("PostgreSQL 9") : (string2.length() > 0 && string2.charAt(0) == '8' ? DatabaseMapping.findDatabase("PostgreSQL 8") : (string2.length() > 0 && string2.charAt(0) == '7' ? DatabaseMapping.findDatabase("PostgreSQL 7") : (string2.length() > 0 && string2.charAt(0) == '6' ? DatabaseMapping.findDatabase("PostgreSQL 6") : DatabaseMapping.findDatabase("PostgreSQL 8"))));
        } else if (string.contains("hsql")) {
            database = string2.contains("2.2") ? DatabaseMapping.findDatabase("HSQLDB 2.2") : (string2.contains("2.1") ? DatabaseMapping.findDatabase("HSQLDB 2.1") : DatabaseMapping.findDatabase("HSQLDB 1.8"));
        } else if (string.contains("teradata")) {
            database = string2.contains("13") ? DatabaseMapping.findDatabase("Teradata 13") : (string2.contains("12") ? DatabaseMapping.findDatabase("Teradata 12") : DatabaseMapping.findDatabase("Teradata 13"));
        } else if (string.contains("anywhere")) {
            database = string2.contains("12") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 12") : (string2.contains("11") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 11") : (string2.contains("10") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 10") : (string2.contains("9") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 9") : (string2.contains("8") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 8") : (string2.contains("7") ? DatabaseMapping.findDatabase("Sybase SQL Anywhere 7") : DatabaseMapping.findDatabase("Sybase SQL Anywhere 12"))))));
        } else if (string.contains("adaptive")) {
            database = DatabaseMapping.findDatabase("Sybase Adaptive Enterprise Server 15.5");
        } else if (string.contains("oracle")) {
            database = string2.contains("11g") ? DatabaseMapping.findDatabase("Oracle11g") : (string2.contains("10g") ? DatabaseMapping.findDatabase("Oracle10g") : (string2.contains("9i") ? DatabaseMapping.findDatabase("Oracle9i") : (string2.contains("8i") ? DatabaseMapping.findDatabase("Oracle8i") : DatabaseMapping.findDatabase("Oracle11g"))));
        } else if (string.contains("pervasive")) {
            database = string2.contains("11") ? DatabaseMapping.findDatabase("Pervasive PSQL v11") : (string2.contains("10") ? DatabaseMapping.findDatabase("Pervasive PSQL v10") : (string2.contains("9") ? DatabaseMapping.findDatabase("Pervasive PSQL v9") : (string2.contains("8") ? DatabaseMapping.findDatabase("Pervasive.SQL v8") : (string2.contains("7") ? DatabaseMapping.findDatabase("Pervasive.SQL 7") : DatabaseMapping.findDatabase("Pervasive PSQL v11")))));
        } else if (string.contains("db2")) {
            database = string2.contains("10") ? DatabaseMapping.findDatabase("IBM DB2 10") : (string2.contains("9") ? DatabaseMapping.findDatabase("IBM DB2 9") : DatabaseMapping.findDatabase("IBM DB2 10"));
        } else if (string.contains("sqlite")) {
            database = string2.contains("3") ? DatabaseMapping.findDatabase("SQLite v3") : (string2.contains("2") ? DatabaseMapping.findDatabase("SQLite v2") : (string2.contains("1") ? DatabaseMapping.findDatabase("SQLite v1") : DatabaseMapping.findDatabase("SQLite v3")));
        } else if (string.contains("firebird")) {
            database = DatabaseMapping.findDatabase("Firebird v2");
        } else if (string.contains("service")) {
            database = DatabaseMapping.findDatabase("ServiceNow");
        } else if (string.contains("mongo")) {
            database = DatabaseMapping.findDatabase("MongoDB 2.2");
        }
        return database;
    }

    public static int getDatabaseId(SourceDatabase sourceDatabase) {
        Database database = DatabaseMapping.getDatabase(sourceDatabase);
        if (database != null) {
            return database.getDatabaseId();
        }
        return 1000;
    }

    public static Database findDatabase(String string) {
        Iterator<Map.Entry<Integer, Database>> iterator = databases.entrySet().iterator();
        while (iterator.hasNext()) {
            Database database = iterator.next().getValue();
            if (!database.getProductName().equalsIgnoreCase(string)) continue;
            return database;
        }
        return null;
    }

    public static Database getDatabase(int n) {
        return databases.get(n);
    }

    public static Map<String, Driver> getDrivers() {
        return drivers;
    }
}

