/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.jdbc.UnityDriver;
import unity.util.StringFunc;

public class UnityResultSetMetaData
implements ResultSetMetaData {
    private String[] columnHeaders;
    private Relation relation;

    public UnityResultSetMetaData(Relation relation) throws SQLException {
        this.relation = relation;
        this.columnHeaders = new String[relation.getNumAttributes()];
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            this.columnHeaders[i] = relation.getAttribute(i).getName();
        }
    }

    public String[] getColumnHeaders() {
        return this.columnHeaders;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return Attribute.getTypeClass(this.relation.getAttributeType(n - 1));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnHeaders.length;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        return this.relation.getAttribute(n - 1).getLength();
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.columnHeaders[n - 1];
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return StringFunc.undelimitName(this.columnHeaders[n - 1], '\"');
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        return this.relation.getAttribute(n - 1).getType();
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        return Attribute.getTypeName(this.relation.getAttribute(n - 1).getType());
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return "";
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 2;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(UnityDriver.i18n.getString("FeatureNotSupported"));
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

