/*
 * Decompiled with CFR 0.152.
 */
package snow.conn;

import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import snow.conn.WSDLParser;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceKey;
import unity.annotation.SourceTable;

public class RequestThread
extends Thread {
    private static int MAX_THREADS = 100;
    private static int THREAD_COUNT = 0;
    private String url;
    private HashMap<String, SourceField> fields;
    private LinkedHashMap<String, SourceTable> tables;
    private SourceKey pkey;
    private ArrayList<SourceForeignKey> fkeys;
    private String tableName;
    private SourceDatabase database;

    public RequestThread(SourceDatabase sourceDatabase, String string, String string2, HashMap<String, SourceField> hashMap, LinkedHashMap<String, SourceTable> linkedHashMap, SourceKey sourceKey, ArrayList<SourceForeignKey> arrayList) {
        this.url = string2;
        this.fields = hashMap;
        this.tables = linkedHashMap;
        this.pkey = sourceKey;
        this.fkeys = arrayList;
        this.tableName = string;
        this.database = sourceDatabase;
    }

    public static synchronized boolean addThread() {
        if (THREAD_COUNT < MAX_THREADS) {
            ++THREAD_COUNT;
            return true;
        }
        return false;
    }

    public static synchronized void removeThread() {
        --THREAD_COUNT;
    }

    public static synchronized int getThreadCount() {
        return THREAD_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            WSDLParser wSDLParser = new WSDLParser(this.tableName);
            URL uRL = new URL(this.url);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            sAXParser.parse(uRLConnection.getInputStream(), (DefaultHandler)wSDLParser);
            this.fields = wSDLParser.getFields();
            AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(null, null, this.tableName, null, this.fields, this.pkey);
            annotatedSourceTable.setSourceFields(this.fields);
            if (this.pkey != null) {
                ArrayList<SourceField> arrayList = this.pkey.getFields();
                arrayList.set(0, this.fields.get(arrayList.get(0).getColumnName()));
                this.pkey.setTable(annotatedSourceTable);
            }
            for (int i = 0; i < this.fkeys.size(); ++i) {
                SourceForeignKey sourceForeignKey = this.fkeys.get(i);
                ArrayList<SourceField> arrayList = sourceForeignKey.getFields();
                for (int j = 0; j < arrayList.size(); ++j) {
                    arrayList.set(j, this.fields.get(arrayList.get(j).getColumnName()));
                }
                sourceForeignKey.setTable(annotatedSourceTable);
            }
            annotatedSourceTable.setParentDatabase(this.database);
            annotatedSourceTable.setForeignKeys(this.fkeys);
            this.tables.put(this.tableName, annotatedSourceTable);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        finally {
            RequestThread.removeThread();
        }
    }
}

