/*
 * Decompiled with CFR 0.152.
 */
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;
import unity.functions.Function;

public class F_Triple
extends Function {
    private static final long serialVersionUID = 1L;
    private Expression expr;

    public F_Triple(Expression expression) {
        this.expr = expression;
        this.returnType = this.expr.getReturnType();
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.expr.evaluate(tuple);
        if (object != null) {
            if (object instanceof Double) {
                return new Double((Double)object * 3.0);
            }
            if (object instanceof Float) {
                return new Float(((Float)object).floatValue() * 3.0f);
            }
            if (object instanceof Integer) {
                return new Integer((Integer)object * 3);
            }
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue() * 3.0);
            }
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{99999};
    }

    public static String getFunctionName() {
        return "TRIPLE";
    }

    @Override
    public String toString(Relation relation) {
        return "TRIPLE(" + this.expr.toString(relation) + ")";
    }
}

