/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.favs.Folder;

public final class FoldersCache {
    private static final ILogger s_log = LoggerController.createLogger(FoldersCache.class);
    private IApplication _app;
    private Folder _rootFolder = null;
    private String _queriesFileName;

    public FoldersCache(IApplication app, FileWrapper userSettingsFolder) {
        this._app = app;
        this._queriesFileName = userSettingsFolder.getAbsolutePath() + File.separator + "queries.xml";
    }

    public Folder getRootFolder() {
        return this._rootFolder;
    }

    public void setRootFolder(Folder folder) {
        this._rootFolder = folder;
    }

    void load() {
        try {
            if (new File(this._queriesFileName).exists()) {
                XMLObjectCache cache = new XMLObjectCache();
                cache.load(this._queriesFileName, this.getClass().getClassLoader());
                Iterator it = cache.getAllForClass(Folder.class);
                if (it.hasNext()) {
                    this._rootFolder = (Folder)it.next();
                }
            }
        }
        catch (FileNotFoundException cache) {
        }
        catch (XMLException ex) {
            s_log.error((Object)("Error loading queries file: " + this._queriesFileName), (Throwable)ex);
        }
        catch (DuplicateObjectException ex) {
            s_log.error((Object)("Error loading queries file: " + this._queriesFileName), (Throwable)ex);
        }
    }

    void save() {
        try {
            XMLObjectCache cache = new XMLObjectCache();
            try {
                if (this._rootFolder != null) {
                    cache.add((IHasIdentifier)this._rootFolder);
                }
            }
            catch (DuplicateObjectException duplicateObjectException) {
                // empty catch block
            }
            cache.save(this._queriesFileName);
        }
        catch (IOException ex) {
            s_log.error((Object)("Error occurred saving queries to " + this._queriesFileName), (Throwable)ex);
        }
        catch (XMLException ex) {
            s_log.error((Object)("Error occurred saving queries to " + this._queriesFileName), (Throwable)ex);
        }
    }
}

