/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.colorrows;

import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ColorPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColorSelectedRowsCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColorSelectedRowsCommand.class);
    private DataSetViewerTable _table;

    public ColorSelectedRowsCommand(DataSetViewerTable table) {
        this._table = table;
    }

    public void execute() {
        Color startColor = this._table.getColoringService().getRowColorHandler().getFirstColorInSelection();
        if (null != startColor) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(this.createChooseColorItem(startColor));
            popupMenu.add(this.createRemoveColorItem());
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this._table);
            popupMenu.show(this._table, p.x, p.y);
        } else {
            this.colorSelection(null, false);
        }
    }

    private JMenuItem createRemoveColorItem() {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("ColorSelectedRowsCommand.remove.color"));
        ret.addActionListener(e -> this.colorSelection(null, true));
        return ret;
    }

    private JMenuItem createChooseColorItem(Color startColor) {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("ColorSelectedRowsCommand.choose.color"));
        ret.addActionListener(e -> this.colorSelection(startColor, false));
        return ret;
    }

    private void colorSelection(Color startColor, boolean remove) {
        Color newColor = null;
        if (!remove && null == (newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(this._table), ColorPropertiesPanel.i18n.ALIAS_BACKGROUND_COLOR_CHOOSER_DIALOG_TITLE, startColor))) {
            return;
        }
        this._table.getColoringService().getRowColorHandler().setColorForSelectedRows(newColor);
    }
}

