/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBase;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.FloatingPointBaseDTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.ParameterWhereClausePart;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataTypeBigDecimal
extends FloatingPointBase
implements IDataTypeComponent {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataTypeBigDecimal.class);
    private static ILogger s_log = LoggerController.createLogger(DataTypeBigDecimal.class);
    private boolean _isNullable;
    private int _precision;
    private int _scale;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private NumberFormat _numberFormat;
    private boolean _renderExceptionHasBeenLogged;

    public DataTypeBigDecimal(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        this._precision = colDef.getPrecision();
        this._scale = colDef.getScale();
        this._numberFormat = this.createNumberFormat();
    }

    @Override
    public String getClassName() {
        return "java.math.BigDecimal";
    }

    @Override
    public String renderObject(Object value) {
        if (value == null || FloatingPointBaseDTProperties.isUseJavaDefaultFormat()) {
            return (String)this._renderer.renderObject(value);
        }
        try {
            return (String)this._renderer.renderObject(this._numberFormat.format(value));
        }
        catch (Exception e) {
            if (!this._renderExceptionHasBeenLogged) {
                this._renderExceptionHasBeenLogged = true;
                s_log.error("Could not format \"" + value + "\" as number type", e);
            }
            return (String)this._renderer.renderObject(value);
        }
    }

    @Override
    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    @Override
    public boolean needToReRead(Object originalValue) {
        return false;
    }

    @Override
    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeBigDecimal.this._textComponent, evt, DataTypeBigDecimal.this._table);
                    CellDataPopup.showDialog(DataTypeBigDecimal.this._table, DataTypeBigDecimal.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    @Override
    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            BigDecimal obj = FloatingPointBaseDTProperties.isUseJavaDefaultFormat() ? new BigDecimal(value) : new BigDecimal("" + this._numberFormat.parse(value));
            if (this._scale >= 0 && obj.scale() > this._scale) {
                Object[] args = new Object[]{obj.scale(), this._scale};
                String msg = s_stringMgr.getString("dataTypeBigDecimal.scaleEceeded", args);
                messageBuffer.append(msg);
                return null;
            }
            int objPrecision = value.length();
            if (value.indexOf("+") > -1 || value.indexOf("-") > -1) {
                --objPrecision;
            }
            if (value.indexOf(".") > -1) {
                --objPrecision;
            }
            if (this._precision > 0 && objPrecision > this._precision) {
                Object[] args = new Object[]{objPrecision, this._precision};
                String msg = s_stringMgr.getString("dataTypeBigDecimal.precisionEceeded", args);
                messageBuffer.append(msg);
                return null;
            }
            return obj;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    @Override
    public boolean useBinaryEditingPanel() {
        return false;
    }

    @Override
    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    @Override
    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    @Override
    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    @Override
    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        BigDecimal data = rs.getBigDecimal(index);
        if (rs.wasNull()) {
            return null;
        }
        return data;
    }

    @Override
    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new ParameterWhereClausePart(this._colDef, value, this);
    }

    @Override
    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            pstmt.setBigDecimal(position, (BigDecimal)value);
        }
    }

    @Override
    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public boolean canDoFileIO() {
        return true;
    }

    @Override
    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    @Override
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int index;
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeBigDecimal.this._textComponent);
            String text = _theComponent.getText();
            if ((c == '\t' || c == '\n') && -1 != (index = text.indexOf(c))) {
                text = index == text.length() - 1 ? text.substring(0, text.length() - 1) : text.substring(0, index) + text.substring(index + 1);
                ((IRestorableTextComponent)((Object)_theComponent)).updateText(text);
                DataTypeBigDecimal.this._beepHelper.beep(_theComponent);
                e.consume();
            }
            this.checkSignCharacter(e, _theComponent, DataTypeBigDecimal.this._colDef, DataTypeBigDecimal.this._beepHelper);
            if (!Character.isDigit(c) && !this.isSignCharacter(c) && c != '.' && c != ',' && c != '\b' && c != '\u007f') {
                DataTypeBigDecimal.this._beepHelper.beep(_theComponent);
                e.consume();
            }
            if (DataTypeBigDecimal.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeBigDecimal.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeBigDecimal.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeBigDecimal.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DataTypeBigDecimal.this._textComponent);
            }
        }
    }
}

