/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import javax.swing.Action;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.action.RedoAction;
import net.sourceforge.squirrel_sql.client.session.action.UndoAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IUndoHandler;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SquirrelDefaultUndoManager;

public class UndoHandlerImpl
implements IUndoHandler {
    private UndoAction _undoAction;
    private RedoAction _redoAction;

    public UndoHandlerImpl(IApplication application, ISQLEntryPanel entry) {
        if (!entry.hasOwnUndoableManager()) {
            SquirrelDefaultUndoManager undoManager = new SquirrelDefaultUndoManager();
            SquirrelResources res = application.getResources();
            this._undoAction = new UndoAction(application, undoManager);
            this._redoAction = new RedoAction(application, undoManager);
            JTextArea comp = entry.getTextComponent();
            comp.registerKeyboardAction(this._undoAction, res.getKeyStroke(this._undoAction), 1);
            comp.registerKeyboardAction(this._redoAction, res.getKeyStroke(this._redoAction), 1);
            entry.setUndoManager(undoManager);
        } else {
            IUndoHandler undoHandler = entry.createUndoHandler();
            this._undoAction = new UndoAction(application, undoHandler.getUndoAction());
            this._redoAction = new RedoAction(application, undoHandler.getRedoAction());
        }
        entry.addRedoUndoActionsToSQLEntryAreaMenu(this._undoAction, this._redoAction);
    }

    @Override
    public Action getUndoAction() {
        return this._undoAction;
    }

    @Override
    public Action getRedoAction() {
        return this._redoAction;
    }
}

