/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.filemanager;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.filemanager.FileChooserManager;
import net.sourceforge.squirrel_sql.client.session.filemanager.IFileEditorAPI;
import net.sourceforge.squirrel_sql.fw.gui.ChooserPreviewer;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FileManagementCore {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(FileManagementCore.class);
    private static ILogger s_log = LoggerController.createLogger(FileManagementCore.class);
    private IFileEditorAPI _fileEditorAPI;
    private TitleFilePathHandler _titleFilePathHandler;
    private File _toSaveTo = null;
    private FileChooserManager _fileChooserManager = new FileChooserManager();
    private IOUtilities ioUtil = new IOUtilitiesImpl();

    public FileManagementCore(IFileEditorAPI fileEditorAPI, TitleFilePathHandler titleFilePathHandler) {
        this._fileEditorAPI = fileEditorAPI;
        if (null == titleFilePathHandler) {
            throw new IllegalStateException("titleFilePathHandler must not be null");
        }
        this._titleFilePathHandler = titleFilePathHandler;
    }

    public boolean save() {
        return this.saveIntern(false);
    }

    public boolean saveAs() {
        return this.saveIntern(true);
    }

    public boolean open(File f, boolean appendToExisting) {
        this._fileEditorAPI.selectWidgetOrTab();
        return this.loadScript(f, appendToExisting);
    }

    public boolean open(boolean appendToExisting) {
        boolean result = false;
        JFileChooser chooser = this._fileChooserManager.getFileChooser();
        chooser.setAccessory(new ChooserPreviewer());
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        if (prefs.isFileOpenInPreviousDir()) {
            String fileName = prefs.getFilePreviousDir();
            if (fileName != null) {
                chooser.setCurrentDirectory(new File(fileName));
            }
        } else {
            String dirName = prefs.getFileSpecifiedDir();
            if (dirName != null) {
                chooser.setCurrentDirectory(new File(dirName));
            }
        }
        Frame frame = this._fileEditorAPI.getOwningFrame();
        this._fileEditorAPI.selectWidgetOrTab();
        if (chooser.showOpenDialog(frame) == 0) {
            File selectedFile = chooser.getSelectedFile();
            result = this.loadScript(selectedFile, appendToExisting);
        }
        return result;
    }

    private String checkFileOk(File selectedFile) {
        String errorMessage = null;
        if (null == selectedFile) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.no.file.selected");
        } else if (!selectedFile.exists()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.does.not.exist", selectedFile.getAbsolutePath());
        } else if (!selectedFile.isFile()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.is.not.a.file", selectedFile.getAbsolutePath());
        } else if (!selectedFile.canRead()) {
            errorMessage = s_stringMgr.getString("FileManager.error.chosen.File.can.not.be.read", selectedFile.getAbsolutePath());
        }
        return errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadScript(File file, boolean appendToExisting) {
        String errorMessage = this.checkFileOk(file);
        if (null != errorMessage) {
            String titel = s_stringMgr.getString("FileManager.error.file.open.failed.title");
            JOptionPane.showMessageDialog(this._fileEditorAPI.getOwningFrame(), errorMessage, titel, 0);
            Main.getApplication().getMessageHandler().showErrorMessage(errorMessage);
            return false;
        }
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            StringBuffer sb = new StringBuffer();
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            byte[] bytes = new byte[2048];
            int iRead = bis.read(bytes);
            while (iRead != -1) {
                sb.append(new String(bytes, 0, iRead));
                iRead = bis.read(bytes);
            }
            if (!appendToExisting) {
                this._fileEditorAPI.setEntireSQLScript("");
            }
            this._fileEditorAPI.appendSQLScript(this.convertPlatformEOLToLineFeed(sb.toString()), true);
            this.setFile(file);
            this.memorizeFile(file, prefs);
            boolean bl = true;
            this.ioUtil.closeInputStream(bis);
            this.ioUtil.closeInputStream(fis);
            return bl;
        }
        catch (Exception e) {
            try {
                Main.getApplication().getMessageHandler().showErrorMessage(e);
                s_log.error(e);
                boolean bl = false;
                this.ioUtil.closeInputStream(bis);
                this.ioUtil.closeInputStream(fis);
                return bl;
            }
            catch (Throwable throwable) {
                this.ioUtil.closeInputStream(bis);
                this.ioUtil.closeInputStream(fis);
                throw throwable;
            }
        }
    }

    private void memorizeFile(File file, SquirrelPreferences prefs) {
        prefs.setFilePreviousDir(file.getAbsolutePath());
        Main.getApplication().getRecentFilesManager().fileTouched(file.getAbsolutePath(), this._fileEditorAPI.getSession().getAlias());
    }

    private boolean saveIntern(boolean toNewFile) {
        boolean result = false;
        if (toNewFile) {
            this._toSaveTo = null;
        }
        JFileChooser chooser = this._fileChooserManager.getFileChooser();
        SquirrelPreferences prefs = this._fileEditorAPI.getSession().getApplication().getSquirrelPreferences();
        Frame frame = this._fileEditorAPI.getOwningFrame();
        if (null == this._toSaveTo) {
            if (prefs.isFileOpenInPreviousDir()) {
                String dirName = prefs.getFilePreviousDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            } else {
                String dirName = prefs.getFileSpecifiedDir();
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
            }
        }
        this._fileEditorAPI.selectWidgetOrTab();
        if (null != this._toSaveTo) {
            if (this.saveScript(frame, this._toSaveTo, false)) {
                result = true;
            }
        } else if (chooser.showSaveDialog(frame) == 0) {
            this._fileChooserManager.saveWasApproved();
            this._toSaveTo = chooser.getSelectedFile();
            if (!this._toSaveTo.exists() && null != this._fileChooserManager.getSelectedFileEnding() && !this._toSaveTo.getAbsolutePath().endsWith(this._fileChooserManager.getSelectedFileEnding())) {
                this._toSaveTo = new File(this._toSaveTo.getAbsolutePath() + this._fileChooserManager.getSelectedFileEnding());
            }
            if (this.saveScript(frame, this._toSaveTo, true)) {
                result = true;
            } else {
                this._toSaveTo = null;
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveScript(Frame frame, File file, boolean askReplace) {
        boolean doSave = false;
        if (file.exists() && !file.canWrite()) {
            String msg = s_stringMgr.getString("FileManager.error.cannotwritefile", file.getAbsolutePath());
            Dialogs.showOk(frame, msg);
            return false;
        }
        if (askReplace && file.exists()) {
            String confirmMsg = s_stringMgr.getString("FileManager.confirm.filereplace", file.getAbsolutePath());
            doSave = Dialogs.showYesNo(frame, confirmMsg);
            if (!doSave) {
                return false;
            }
            file.delete();
        } else {
            doSave = true;
        }
        SquirrelPreferences prefs = this._fileEditorAPI.getSession().getApplication().getSquirrelPreferences();
        if (doSave) {
            this.memorizeFile(file, prefs);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                String sScript = this.getEntireSQLScriptWithPlatformEolChar();
                fos.write(sScript.getBytes());
                this.setFile(file);
                String msg = s_stringMgr.getString("FileManager.savedfile", file.getAbsolutePath());
                this._fileEditorAPI.getSession().showMessage(msg);
            }
            catch (IOException ex) {
                this._fileEditorAPI.getSession().showErrorMessage(ex);
            }
            finally {
                this.ioUtil.closeOutputStream(fos);
            }
        }
        return true;
    }

    private String getEntireSQLScriptWithPlatformEolChar() {
        String result = this._fileEditorAPI.getEntireSQLScript();
        return this.convertLineFeedToPlatformEOL(result);
    }

    private String convertLineFeedToPlatformEOL(String result) {
        String platformEolStr = StringUtilities.getEolStr();
        if (result != null && !"".equals(result)) {
            result = result.replaceAll("\\r", "");
            if (!platformEolStr.equals("\n")) {
                result = result.replaceAll("\\n", platformEolStr);
            }
        }
        return result;
    }

    private String convertPlatformEOLToLineFeed(String s) {
        String platformEolStr = StringUtilities.getEolStr();
        if (null == s || "".equals(s)) {
            return s;
        }
        if (!platformEolStr.equals("\n")) {
            s = s.replaceAll(platformEolStr, "\n");
        }
        return s.replaceAll("\\r", "");
    }

    private void setFile(File file) {
        this._toSaveTo = file;
        this._titleFilePathHandler.setSqlFile(file);
    }

    public File getFile() {
        return this._toSaveTo;
    }

    public void clearCurrentFile() {
        this._toSaveTo = null;
    }

    public void clearSqlFile() {
        this._titleFilePathHandler.setSqlFile(null);
    }

    public void displayUnsavedEditsInTabComponent(boolean unsavedEdits) {
        this._titleFilePathHandler.setUnsavedEdits(unsavedEdits);
    }

    public void replaceSqlFileExtensionFilterBy(FileExtensionFilter fileExtensionFilter, String fileEndingWithDot) {
        this._fileChooserManager.replaceSqlFileExtensionFilterBy(fileExtensionFilter, fileEndingWithDot);
    }
}

