/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.action.EditExtrasUtilities;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

class RemoveQuotesCommand
implements ICommand {
    private final ISQLPanelAPI _api;

    RemoveQuotesCommand(ISQLPanelAPI api) {
        this._api = api;
    }

    @Override
    public void execute() throws BaseException {
        ISQLEntryPanel entryPanel = this._api.getSQLEntryPanel();
        RemoveQuotesCommand.unquoteSQL(entryPanel);
    }

    static void unquoteSQL(ISQLEntryPanel entryPanel) {
        int[] bounds = entryPanel.getBoundsOfSQLToBeExecuted();
        if (bounds[0] == bounds[1]) {
            return;
        }
        String textToUnquote = entryPanel.getSQLToBeExecuted();
        if (null == textToUnquote) {
            return;
        }
        String unquotedText = EditExtrasUtilities.unquoteText(textToUnquote);
        entryPanel.setSelectionStart(bounds[0]);
        entryPanel.setSelectionEnd(bounds[1]);
        entryPanel.replaceSelection(unquotedText);
    }
}

