/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"isExportedClass", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "isExportedInterface", "isExportedMember", "backend.js"})
public final class IrJsUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedMember(@NotNull IrDeclaration $this$isExportedMember, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExportedMember, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!($this$isExportedMember instanceof IrDeclarationWithVisibility)) return false;
        if (!((IrDeclarationWithVisibility)$this$isExportedMember).getVisibility().isPublicAPI()) return false;
        IrClass irClass2 = IrUtilsKt.getParentClassOrNull($this$isExportedMember);
        if (irClass2 == null) return false;
        if (!ExportModelGeneratorKt.isExported(irClass2, context2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedClass(@Nullable IrDeclaration $this$isExportedClass, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!($this$isExportedClass instanceof IrClass)) return false;
        ClassKind $this$isClass$iv = ((IrClass)$this$isExportedClass).getKind();
        boolean $i$f$isClass = false;
        if ($this$isClass$iv != ClassKind.CLASS) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedClass, context2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isExportedInterface(@Nullable IrDeclaration $this$isExportedInterface, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!($this$isExportedInterface instanceof IrClass)) return false;
        ClassKind $this$isInterface$iv = ((IrClass)$this$isExportedInterface).getKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!ExportModelGeneratorKt.isExported($this$isExportedInterface, context2)) return false;
        return true;
    }
}

