/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.temporaryVals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.InsnSequence;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.nullCheck.RedundantNullCheckMethodTransformerKt;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryVal;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.TemporaryValsAnalyzer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LineNumberNode;
import org.jetbrains.org.objectweb.asm.tree.LocalVariableNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001d\u001a\u00020\b*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020\b*\u00020\n2\n\u0010 \u001a\u00020!\"\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "temporaryValsAnalyzer", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryValsAnalyzer;", "isRewritableSafeCallPart", "", "branchInsn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "optimizeTemporaryVals", "", "cfg", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "temporaryVals", "", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVal;", "processLabels", "rewriteSafeCallPart", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "simplifyKnownSafeCallPatterns", "simplifyTrivialInstructions", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "transform", "internalClassName", "", "isIntervening", "context", "matchOpcodes", "opcodes", "", "", "ControlFlowGraph", "backend"})
public final class TemporaryVariablesEliminationTransformer
extends MethodTransformer {
    @NotNull
    private final GenerationState state;
    @NotNull
    private final TemporaryValsAnalyzer temporaryValsAnalyzer;

    public TemporaryVariablesEliminationTransformer(@NotNull GenerationState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.state = state;
        this.temporaryValsAnalyzer = new TemporaryValsAnalyzer();
    }

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(internalClassName, "internalClassName");
            Intrinsics.checkNotNullParameter(methodNode, "methodNode");
            if (!this.state.isIrBackend()) {
                return;
            }
            InsnList insnList = methodNode.instructions;
            Intrinsics.checkNotNullExpressionValue(insnList, "methodNode.instructions");
            Iterable $this$any$iv = insnList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractInsnNode it = (AbstractInsnNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!InlineCodegenUtilsKt.isSuspendInlineMarker(it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        this.simplifyTrivialInstructions(methodNode);
        ControlFlowGraph cfg = new ControlFlowGraph(methodNode);
        this.processLabels(cfg);
        this.simplifyKnownSafeCallPatterns(cfg);
        List<TemporaryVal> temporaryVals = this.temporaryValsAnalyzer.analyze(internalClassName, methodNode);
        if (!((Collection)temporaryVals).isEmpty()) {
            this.optimizeTemporaryVals(cfg, temporaryVals);
        }
        UtilKt.removeUnusedLocalVariables(methodNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void simplifyTrivialInstructions(MethodNode methodNode) {
        void $this$mapTo$iv;
        InsnList insnList = methodNode.instructions;
        AbstractInsnNode[] abstractInsnNodeArray = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue(abstractInsnNodeArray, "insnList.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray) {
            Object popInsn;
            Intrinsics.checkNotNullExpressionValue(insn, "insn");
            int[] nArray = new int[]{21, 87};
            if (this.matchOpcodes(insn, nArray) || this.matchOpcodes(insn, nArray = new int[]{23, 87}) || this.matchOpcodes(insn, nArray = new int[]{25, 87})) {
                popInsn = insn.getNext();
                insnList.insert(insn, new InsnNode(0));
                insnList.remove(insn);
                insnList.remove((AbstractInsnNode)popInsn);
                continue;
            }
            popInsn = new int[2];
            popInsn[0] = 24;
            popInsn[1] = 88;
            if (!this.matchOpcodes(insn, (int[])popInsn)) {
                popInsn = new int[2];
                popInsn[0] = 22;
                popInsn[1] = 88;
                if (!this.matchOpcodes(insn, (int[])popInsn)) continue;
            }
            AbstractInsnNode pop2Insn = insn.getNext();
            insnList.insert(insn, new InsnNode(0));
            insnList.remove(insn);
            insnList.remove(pop2Insn);
        }
        List<TryCatchBlockNode> list2 = methodNode.tryCatchBlocks;
        Intrinsics.checkNotNullExpressionValue(list2, "methodNode.tryCatchBlocks");
        AbstractInsnNode[] abstractInsnNodeArray2 = (AbstractInsnNode[])list2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            TryCatchBlockNode tryCatchBlockNode = (TryCatchBlockNode)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.start);
        }
        HashSet tcbStartLabels = (HashSet)destination$iv;
        AbstractInsnNode[] abstractInsnNodeArray3 = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue(abstractInsnNodeArray3, "insnList.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray3) {
            AbstractInsnNode next;
            AbstractInsnNode prev;
            if (insn.getOpcode() != 0 || CollectionsKt.contains(tcbStartLabels, prev = insn.getPrevious()) || ((next = insn.getNext()) == null || !UtilKt.isMeaningful(next)) && (prev == null || !UtilKt.isMeaningful(prev))) continue;
            insnList.remove(insn);
        }
    }

    private final void processLabels(ControlFlowGraph cfg) {
        AbstractInsnNode last;
        cfg.reset();
        MethodNode methodNode = cfg.getMethodNode();
        InsnList insnList = methodNode.instructions;
        HashSet<LabelNode> usedLabels = new HashSet<LabelNode>();
        AbstractInsnNode first = insnList.getFirst();
        if (first instanceof LabelNode) {
            usedLabels.add((LabelNode)first);
        }
        if ((last = insnList.getLast()) instanceof LabelNode) {
            usedLabels.add((LabelNode)last);
        }
        for (AbstractInsnNode insn : insnList) {
            switch (insn.getType()) {
                case 15: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LineNumberNode");
                    }
                    usedLabels.add(((LineNumberNode)abstractInsnNode).start);
                    break;
                }
                case 7: {
                    Intrinsics.checkNotNullExpressionValue(insn, "insn");
                    LabelNode labelNode = ((JumpInsnNode)insn).label;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "insn as JumpInsnNode).label");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    break;
                }
                case 12: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    }
                    AbstractInsnNode switchInsn = (LookupSwitchInsnNode)abstractInsnNode;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    List<LabelNode> list2 = switchInsn.labels;
                    Intrinsics.checkNotNullExpressionValue(list2, "switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, (Collection<? extends LabelNode>)list2);
                    break;
                }
                case 11: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    }
                    AbstractInsnNode switchInsn = (TableSwitchInsnNode)abstractInsnNode;
                    LabelNode labelNode = ((TableSwitchInsnNode)switchInsn).dflt;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "switchInsn.dflt");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, insn, labelNode);
                    List<LabelNode> list3 = ((TableSwitchInsnNode)switchInsn).labels;
                    Intrinsics.checkNotNullExpressionValue(list3, "switchInsn.labels");
                    TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgesToLabels(usedLabels, cfg, insn, (Collection<? extends LabelNode>)list3);
                }
            }
        }
        for (LocalVariableNode lv : methodNode.localVariables) {
            usedLabels.add(lv.start);
            usedLabels.add(lv.end);
        }
        for (TryCatchBlockNode tcb : methodNode.tryCatchBlocks) {
            usedLabels.add(tcb.start);
            usedLabels.add(tcb.end);
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
            AbstractInsnNode abstractInsnNode = labelNode;
            LabelNode labelNode2 = tcb.handler;
            Intrinsics.checkNotNullExpressionValue(labelNode2, "tcb.handler");
            TemporaryVariablesEliminationTransformer.processLabels$addCfgEdgeToLabel(usedLabels, cfg, abstractInsnNode, labelNode2);
        }
        AbstractInsnNode insn = insnList.getFirst();
        while (insn != null) {
            AbstractInsnNode abstractInsnNode;
            if (insn instanceof LabelNode && !usedLabels.contains(insn)) {
                AbstractInsnNode next = ((LabelNode)insn).getNext();
                insnList.remove(insn);
                abstractInsnNode = next;
            } else {
                abstractInsnNode = insn.getNext();
            }
            insn = abstractInsnNode;
        }
    }

    private final void optimizeTemporaryVals(ControlFlowGraph cfg, List<TemporaryVal> temporaryVals) {
        InsnList insnList = cfg.getMethodNode().instructions;
        int maxStackIncrement = 0;
        for (TemporaryVal tmp : temporaryVals) {
            Object loadInsn;
            block19: {
                Object aLoad1;
                Object $this$none$iv;
                VarInsnNode storeInsn;
                block21: {
                    block20: {
                        boolean bl;
                        block18: {
                            if (tmp.getLoadInsns().isEmpty()) {
                                int n;
                                switch (tmp.getStoreInsn().getOpcode()) {
                                    case 54: 
                                    case 56: 
                                    case 58: {
                                        n = 87;
                                        break;
                                    }
                                    default: {
                                        n = 88;
                                    }
                                }
                                int popOpcode = n;
                                insnList.insertBefore((AbstractInsnNode)tmp.getStoreInsn(), new InsnNode(popOpcode));
                                insnList.remove(tmp.getStoreInsn());
                                continue;
                            }
                            if (tmp.getLoadInsns().size() != 1) break block19;
                            storeInsn = tmp.getStoreInsn();
                            loadInsn = tmp.getLoadInsns().get(0);
                            if (Intrinsics.areEqual(storeInsn.getNext(), loadInsn)) break block20;
                            AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                            Intrinsics.checkNotNullExpressionValue(abstractInsnNode, "storeInsn.next");
                            $this$none$iv = new InsnSequence(abstractInsnNode, (AbstractInsnNode)loadInsn);
                            boolean $i$f$none = false;
                            Iterator iterator2 = $this$none$iv.iterator();
                            while (iterator2.hasNext()) {
                                Object element$iv = iterator2.next();
                                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                                boolean bl2 = false;
                                if (!this.isIntervening(it, cfg)) continue;
                                bl = false;
                                break block18;
                            }
                            bl = true;
                        }
                        if (!bl) break block21;
                    }
                    insnList.remove(storeInsn);
                    insnList.remove((AbstractInsnNode)loadInsn);
                    continue;
                }
                $this$none$iv = new int[3];
                $this$none$iv[0] = 58;
                $this$none$iv[1] = 25;
                $this$none$iv[2] = 25;
                if (this.matchOpcodes(storeInsn, (int[])$this$none$iv)) {
                    AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    aLoad1 = (VarInsnNode)abstractInsnNode;
                    AbstractInsnNode abstractInsnNode2 = ((AbstractInsnNode)aLoad1).getNext();
                    if (abstractInsnNode2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode2;
                    if (Intrinsics.areEqual(aLoad2, loadInsn)) {
                        insnList.remove(storeInsn);
                        insnList.remove((AbstractInsnNode)loadInsn);
                        insnList.insert((AbstractInsnNode)aLoad1, new InsnNode(95));
                        continue;
                    }
                }
                aLoad1 = new int[3];
                aLoad1[0] = 58;
                aLoad1[1] = 178;
                aLoad1[2] = 25;
                if (!this.matchOpcodes(storeInsn, (int[])aLoad1)) continue;
                AbstractInsnNode abstractInsnNode = storeInsn.getNext();
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.FieldInsnNode");
                }
                FieldInsnNode getStaticInsn = (FieldInsnNode)abstractInsnNode;
                AbstractInsnNode abstractInsnNode3 = getStaticInsn.getNext();
                if (abstractInsnNode3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode3;
                if (!Intrinsics.areEqual(aLoad2, loadInsn) || Type.getType(getStaticInsn.desc).getSize() != 1) continue;
                insnList.remove(storeInsn);
                insnList.remove((AbstractInsnNode)loadInsn);
                insnList.insert((AbstractInsnNode)getStaticInsn, new InsnNode(95));
                continue;
            }
            if (tmp.getLoadInsns().size() != 2) continue;
            VarInsnNode storeInsn = tmp.getStoreInsn();
            loadInsn = new int[5];
            loadInsn[0] = 58;
            loadInsn[1] = 25;
            loadInsn[2] = 18;
            loadInsn[3] = 184;
            loadInsn[4] = 25;
            if (!this.matchOpcodes(storeInsn, (int[])loadInsn)) continue;
            AbstractInsnNode aLoad1Insn = storeInsn.getNext();
            AbstractInsnNode ldcInsn = aLoad1Insn.getNext();
            AbstractInsnNode invokeStaticInsn = ldcInsn.getNext();
            AbstractInsnNode aLoad2Insn = invokeStaticInsn.getNext();
            AbstractInsnNode abstractInsnNode = aLoad1Insn;
            if (abstractInsnNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            if (((VarInsnNode)abstractInsnNode).var != tmp.getIndex()) continue;
            AbstractInsnNode abstractInsnNode4 = ldcInsn;
            if (abstractInsnNode4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LdcInsnNode");
            }
            if (!(((LdcInsnNode)abstractInsnNode4).cst instanceof String)) continue;
            Intrinsics.checkNotNullExpressionValue(invokeStaticInsn, "invokeStaticInsn");
            if (!RedundantNullCheckMethodTransformerKt.isCheckExpressionValueIsNotNull(invokeStaticInsn)) continue;
            AbstractInsnNode abstractInsnNode5 = aLoad2Insn;
            if (abstractInsnNode5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            if (((VarInsnNode)abstractInsnNode5).var != tmp.getIndex()) continue;
            insnList.remove(storeInsn);
            insnList.remove(aLoad1Insn);
            insnList.insertBefore(ldcInsn, new InsnNode(89));
            insnList.remove(aLoad2Insn);
            maxStackIncrement = Math.max(maxStackIncrement, 1);
        }
        MethodNode methodNode = cfg.getMethodNode();
        methodNode.maxStack += maxStackIncrement;
    }

    private final void simplifyKnownSafeCallPatterns(ControlFlowGraph cfg) {
        InsnList insnList = cfg.getMethodNode().instructions;
        int maxStackIncrement = 0;
        AbstractInsnNode[] abstractInsnNodeArray = insnList.toArray();
        Intrinsics.checkNotNullExpressionValue(abstractInsnNodeArray, "insnList.toArray()");
        for (AbstractInsnNode insn : abstractInsnNodeArray) {
            AbstractInsnNode it;
            boolean bl;
            List<AbstractInsnNode> predecessors;
            LabelNode ifNullLabel;
            block12: {
                Object aLoad1;
                Intrinsics.checkNotNullExpressionValue(insn, "insn");
                int[] nArray = new int[]{25, 199};
                if (this.matchOpcodes(insn, nArray)) {
                    AbstractInsnNode label1Next;
                    aLoad1 = (VarInsnNode)insn;
                    AbstractInsnNode abstractInsnNode = ((VarInsnNode)insn).getNext();
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                    }
                    JumpInsnNode ifNonNull = (JumpInsnNode)abstractInsnNode;
                    LabelNode label1 = ifNonNull.label;
                    LabelNode labelNode = ifNonNull.label;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "ifNonNull.label");
                    if (!cfg.hasSinglePredecessor(labelNode, ifNonNull) || label1.getNext() == null) continue;
                    if (label1Next.getOpcode() == 25) {
                        VarInsnNode aLoad2 = (VarInsnNode)label1Next;
                        if (aLoad2.var == ((VarInsnNode)aLoad1).var) {
                            insnList.insertBefore((AbstractInsnNode)ifNonNull, new InsnNode(89));
                            insnList.insert((AbstractInsnNode)ifNonNull, new InsnNode(87));
                            insnList.remove(aLoad2);
                            maxStackIncrement = Math.max(maxStackIncrement, 1);
                            continue;
                        }
                        AbstractInsnNode aLoad2Next = aLoad2.getNext();
                        if (aLoad2Next.getOpcode() != 25) continue;
                        AbstractInsnNode abstractInsnNode2 = aLoad2Next;
                        if (abstractInsnNode2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                        }
                        VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode2;
                        if (aLoad3.var != ((VarInsnNode)aLoad1).var) continue;
                        insnList.insertBefore((AbstractInsnNode)ifNonNull, new InsnNode(89));
                        insnList.insert((AbstractInsnNode)ifNonNull, new InsnNode(87));
                        insnList.insert((AbstractInsnNode)aLoad2, new InsnNode(95));
                        insnList.remove(aLoad3);
                        maxStackIncrement = Math.max(maxStackIncrement, 1);
                        continue;
                    }
                    int[] aLoad2 = new int[]{178, 25};
                    if (!this.matchOpcodes(label1Next, aLoad2)) continue;
                    FieldInsnNode getStaticInsn = (FieldInsnNode)label1Next;
                    AbstractInsnNode abstractInsnNode3 = getStaticInsn.getNext();
                    if (abstractInsnNode3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode3;
                    if (Type.getType(getStaticInsn.desc).getSize() != 1 || aLoad3.var != ((VarInsnNode)aLoad1).var) continue;
                    insnList.insertBefore((AbstractInsnNode)ifNonNull, new InsnNode(89));
                    insnList.insert((AbstractInsnNode)ifNonNull, new InsnNode(87));
                    insnList.insert((AbstractInsnNode)getStaticInsn, new InsnNode(95));
                    insnList.remove(aLoad3);
                    maxStackIncrement = Math.max(maxStackIncrement, 1);
                    continue;
                }
                aLoad1 = new int[2];
                aLoad1[0] = 25;
                aLoad1[1] = 198;
                if (!this.matchOpcodes(insn, (int[])aLoad1)) continue;
                AbstractInsnNode abstractInsnNode = insn.getNext();
                if (abstractInsnNode == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                }
                JumpInsnNode ifNull1 = (JumpInsnNode)abstractInsnNode;
                ifNullLabel = ifNull1.label;
                Intrinsics.checkNotNullExpressionValue(ifNullLabel, "ifNullLabel");
                predecessors = cfg.getAllPredecessors(ifNullLabel);
                Iterable $this$all$iv = predecessors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (AbstractInsnNode)element$iv;
                        boolean bl2 = false;
                        if (this.isRewritableSafeCallPart(it)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            Iterable $this$forEach$iv = predecessors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (AbstractInsnNode)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue(insnList, "insnList");
                this.rewriteSafeCallPart(it, insnList);
            }
            insnList.insert((AbstractInsnNode)ifNullLabel, new InsnNode(87));
            maxStackIncrement = Math.max(maxStackIncrement, 1);
        }
        MethodNode methodNode = cfg.getMethodNode();
        methodNode.maxStack += maxStackIncrement;
    }

    private final boolean isRewritableSafeCallPart(AbstractInsnNode branchInsn) {
        AbstractInsnNode abstractInsnNode = branchInsn.getPrevious();
        if (abstractInsnNode == null) {
            return false;
        }
        AbstractInsnNode start = abstractInsnNode;
        int[] nArray = new int[]{25, 198};
        if (this.matchOpcodes(start, nArray)) {
            VarInsnNode aLoad1 = (VarInsnNode)start;
            AbstractInsnNode abstractInsnNode2 = ((VarInsnNode)start).getNext();
            if (abstractInsnNode2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
            }
            JumpInsnNode ifNull2 = (JumpInsnNode)abstractInsnNode2;
            AbstractInsnNode ifNullNext = ifNull2.getNext();
            if (ifNullNext.getOpcode() == 25) {
                AbstractInsnNode abstractInsnNode3 = ifNullNext;
                if (abstractInsnNode3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                }
                VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode3;
                if (aLoad2.var == aLoad1.var) {
                    return true;
                }
                AbstractInsnNode aLoad2Next = aLoad2.getNext();
                if (aLoad2Next.getOpcode() == 25) {
                    AbstractInsnNode abstractInsnNode4 = aLoad2Next;
                    if (abstractInsnNode4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode4;
                    if (aLoad3.var == aLoad1.var) {
                        return true;
                    }
                }
            } else {
                Intrinsics.checkNotNullExpressionValue(ifNullNext, "ifNullNext");
                int[] aLoad2 = new int[]{178, 25};
                if (this.matchOpcodes(ifNullNext, aLoad2)) {
                    FieldInsnNode getStaticInsn = (FieldInsnNode)ifNullNext;
                    if (Type.getType(getStaticInsn.desc).getSize() != 1) {
                        return false;
                    }
                    AbstractInsnNode abstractInsnNode5 = getStaticInsn.getNext();
                    if (abstractInsnNode5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
                    }
                    VarInsnNode aLoad22 = (VarInsnNode)abstractInsnNode5;
                    if (aLoad22.var == aLoad1.var) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final void rewriteSafeCallPart(AbstractInsnNode branchInsn, InsnList insnList) {
        AbstractInsnNode start;
        AbstractInsnNode abstractInsnNode = start = branchInsn.getPrevious();
        if (abstractInsnNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
        }
        VarInsnNode aLoad1 = (VarInsnNode)abstractInsnNode;
        AbstractInsnNode abstractInsnNode2 = ((VarInsnNode)start).getNext();
        if (abstractInsnNode2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        }
        JumpInsnNode ifNull2 = (JumpInsnNode)abstractInsnNode2;
        AbstractInsnNode ifNullNext = ifNull2.getNext();
        if (ifNullNext.getOpcode() == 25) {
            AbstractInsnNode abstractInsnNode3 = ifNullNext;
            if (abstractInsnNode3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            VarInsnNode aLoad2 = (VarInsnNode)abstractInsnNode3;
            if (aLoad2.var == aLoad1.var) {
                insnList.insertBefore((AbstractInsnNode)ifNull2, new InsnNode(89));
                insnList.remove(aLoad2);
                return;
            }
            AbstractInsnNode abstractInsnNode4 = aLoad2.getNext();
            if (abstractInsnNode4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.VarInsnNode");
            }
            VarInsnNode aLoad3 = (VarInsnNode)abstractInsnNode4;
            insnList.insertBefore((AbstractInsnNode)ifNull2, new InsnNode(89));
            insnList.remove(aLoad3);
            insnList.insert((AbstractInsnNode)aLoad2, new InsnNode(95));
            return;
        }
        AbstractInsnNode aLoad2 = ifNullNext.getNext();
        insnList.insertBefore((AbstractInsnNode)ifNull2, new InsnNode(89));
        insnList.remove(aLoad2);
        insnList.insert(ifNullNext, new InsnNode(95));
    }

    private final boolean matchOpcodes(AbstractInsnNode $this$matchOpcodes, int ... opcodes) {
        AbstractInsnNode insn = $this$matchOpcodes;
        int n = opcodes.length;
        for (int i = 0; i < n; ++i) {
            if (insn.getOpcode() != opcodes[i]) {
                return false;
            }
            if (insn.getNext() != null) continue;
            return false;
        }
        return true;
    }

    private final boolean isIntervening(AbstractInsnNode $this$isIntervening, ControlFlowGraph context2) {
        boolean bl;
        switch ($this$isIntervening.getType()) {
            case 14: 
            case 15: {
                bl = false;
                break;
            }
            case 8: {
                bl = context2.hasNonTrivialPredecessors((LabelNode)$this$isIntervening);
                break;
            }
            case 0: {
                if ($this$isIntervening.getOpcode() != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final void processLabels$addCfgEdgeToLabel(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, LabelNode label) {
        usedLabels.add(label);
        $cfg.addNonTrivialPredecessor(label, from2);
    }

    private static final void processLabels$addCfgEdgesToLabels(HashSet<LabelNode> usedLabels, ControlFlowGraph $cfg, AbstractInsnNode from2, Collection<? extends LabelNode> labels2) {
        usedLabels.addAll(labels2);
        for (LabelNode labelNode : labels2) {
            $cfg.addNonTrivialPredecessor(labelNode, from2);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/TemporaryVariablesEliminationTransformer$ControlFlowGraph;", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;)V", "getMethodNode", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nonTrivialPredecessors", "Ljava/util/HashMap;", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lkotlin/collections/HashMap;", "addNonTrivialPredecessor", "", "label", "pred", "getAllPredecessors", "", "hasNonTrivialPredecessors", "", "hasSinglePredecessor", "expectedPredecessor", "reset", "backend"})
    private static final class ControlFlowGraph {
        @NotNull
        private final MethodNode methodNode;
        @NotNull
        private final HashMap<LabelNode, List<AbstractInsnNode>> nonTrivialPredecessors;

        public ControlFlowGraph(@NotNull MethodNode methodNode) {
            Intrinsics.checkNotNullParameter(methodNode, "methodNode");
            this.methodNode = methodNode;
            this.nonTrivialPredecessors = new HashMap();
        }

        @NotNull
        public final MethodNode getMethodNode() {
            return this.methodNode;
        }

        public final void reset() {
            this.nonTrivialPredecessors.clear();
        }

        public final void addNonTrivialPredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode pred) {
            Object object;
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(pred, "pred");
            Map $this$getOrPut$iv = this.nonTrivialPredecessors;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(label);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new SmartList();
                $this$getOrPut$iv.put(label, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(pred);
        }

        public final boolean hasNonTrivialPredecessors(@NotNull LabelNode label) {
            Intrinsics.checkNotNullParameter(label, "label");
            return this.nonTrivialPredecessors.containsKey(label);
        }

        @NotNull
        public final List<AbstractInsnNode> getAllPredecessors(@NotNull LabelNode label) {
            Intrinsics.checkNotNullParameter(label, "label");
            ArrayList<AbstractInsnNode> result2 = new ArrayList<AbstractInsnNode>();
            AbstractInsnNode trivialPredecessor = label.getPrevious();
            if (trivialPredecessor.getOpcode() != 167) {
                int n = trivialPredecessor.getOpcode();
                if (!(172 <= n ? n < 178 : false) && trivialPredecessor.getOpcode() != 191) {
                    result2.add(trivialPredecessor);
                }
            }
            List<AbstractInsnNode> list2 = this.nonTrivialPredecessors.get(label);
            result2.addAll(list2 == null ? (Collection)CollectionsKt.emptyList() : (Collection)list2);
            return result2;
        }

        /*
         * Unable to fully structure code
         */
        public final boolean hasSinglePredecessor(@NotNull LabelNode label, @NotNull AbstractInsnNode expectedPredecessor) {
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(expectedPredecessor, "expectedPredecessor");
            trivialPredecessor = label.getPrevious();
            if (trivialPredecessor.getOpcode() == 167) ** GOTO lbl-1000
            var4_4 = trivialPredecessor.getOpcode();
            v0 = 172 <= var4_4 ? var4_4 < 178 : false;
            if (v0 || trivialPredecessor.getOpcode() == 191) lbl-1000:
            // 2 sources

            {
                trivialPredecessor = null;
            } else if (!Intrinsics.areEqual(trivialPredecessor, expectedPredecessor)) {
                return false;
            }
            v1 = this.nonTrivialPredecessors.get(label);
            if (v1 == null) {
                return trivialPredecessor != null;
            }
            nonTrivialPredecessors = v1;
            return nonTrivialPredecessors.size() > 1 ? false : (nonTrivialPredecessors.size() == 0 ? Intrinsics.areEqual(trivialPredecessor, expectedPredecessor) : trivialPredecessor == null && Intrinsics.areEqual(nonTrivialPredecessors.get(0), expectedPredecessor) != false);
        }
    }
}

