/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.GradleStyleMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.XmlMessageRenderer;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

public interface MessageRenderer {
    public static final String PROPERTY_KEY = "org.jetbrains.kotlin.cliMessageRenderer";
    public static final MessageRenderer XML = new XmlMessageRenderer();
    public static final MessageRenderer WITHOUT_PATHS = new PlainTextMessageRenderer(){

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                1.$$$reportNull$$$1(0);
            }
            if (location == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public String getName() {
            return "Pathless";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$1", "getPath"));
        }
    };
    public static final MessageRenderer PLAIN_FULL_PATHS = new PlainTextMessageRenderer(){

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                2.$$$reportNull$$$1(0);
            }
            if (location == null) {
                2.$$$reportNull$$$0(0);
            }
            String string2 = location.getPath();
            if (string2 == null) {
                2.$$$reportNull$$$0(1);
            }
            if (string2 == null) {
                2.$$$reportNull$$$1(1);
            }
            return string2;
        }

        @Override
        public String getName() {
            return "FullPath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final MessageRenderer PLAIN_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @NotNull
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                3.$$$reportNull$$$1(0);
            }
            if (location == null) {
                3.$$$reportNull$$$0(0);
            }
            String string2 = FileUtilsKt.descendantRelativeTo(new File(location.getPath()), this.cwd).getPath();
            if (string2 == null) {
                3.$$$reportNull$$$0(1);
            }
            if (string2 == null) {
                3.$$$reportNull$$$1(1);
            }
            return string2;
        }

        @Override
        public String getName() {
            return "RelativePath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$3";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final MessageRenderer SYSTEM_INDEPENDENT_RELATIVE_PATHS = new PlainTextMessageRenderer(){
        private final File cwd = new File(".").getAbsoluteFile();

        @Override
        @Nullable
        protected String getPath(@NotNull CompilerMessageSourceLocation location) {
            if (location == null) {
                4.$$$reportNull$$$1(0);
            }
            if (location == null) {
                4.$$$reportNull$$$0(0);
            }
            return FileUtil.toSystemIndependentName(FileUtilsKt.descendantRelativeTo(new File(location.getPath()), this.cwd).getPath());
        }

        @Override
        public String getName() {
            return "SystemIndependentRelativePath";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$4", "getPath"));
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/MessageRenderer$4", "getPath"));
        }
    };
    public static final MessageRenderer GRADLE_STYLE = new GradleStyleMessageRenderer();

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @Nullable CompilerMessageSourceLocation var3);

    public String renderUsage(@NotNull String var1);

    public String renderConclusion();

    public String getName();
}

