/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javacc.Version;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.parser.Options;
import org.javacc.parser.OutputFile;
import org.javacc.utils.OutputFileGenerator;

final class NodeFiles {
    static final String nodeVersion = Version.majorDotMinor;
    static Set nodesGenerated = new HashSet();

    private NodeFiles() {
    }

    static void ensure(IO io, String nodeType) {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), nodeType + ".java");
        if (!nodeType.equals("Node")) {
            if (nodeType.equals("SimpleNode")) {
                NodeFiles.ensure(io, "Node");
            } else {
                NodeFiles.ensure(io, "SimpleNode");
            }
        }
        if (!nodeType.equals("Node") && !JJTreeOptions.getBuildNodeFiles()) {
            return;
        }
        if (file.exists() && nodesGenerated.contains(file.getName())) {
            return;
        }
        try {
            String[] options = new String[]{"MULTI", "NODE_USES_PARSER", "VISITOR", "TRACK_TOKENS", "NODE_PREFIX", "NODE_EXTENDS", "NODE_FACTORY", "SUPPORT_CLASS_VISIBILITY_PUBLIC"};
            OutputFile outputFile = new OutputFile(file, nodeVersion, options);
            outputFile.setToolName("JJTree");
            nodesGenerated.add(file.getName());
            if (!outputFile.needToWrite) {
                return;
            }
            if (nodeType.equals("Node")) {
                NodeFiles.generateNode_java(outputFile);
            } else if (nodeType.equals("SimpleNode")) {
                NodeFiles.generateSimpleNode_java(outputFile);
            } else {
                NodeFiles.generateMULTINode_java(outputFile, nodeType);
            }
            outputFile.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static void generatePrologue(PrintWriter ostr) {
        if (!JJTreeGlobals.nodePackageName.equals("")) {
            ostr.println("package " + JJTreeGlobals.nodePackageName + ";");
            ostr.println();
            if (!JJTreeGlobals.nodePackageName.equals(JJTreeGlobals.packageName)) {
                ostr.println("import " + JJTreeGlobals.packageName + ".*;");
                ostr.println();
            }
        }
    }

    static String nodeConstants() {
        return JJTreeGlobals.parserName + "TreeConstants";
    }

    static void generateTreeConstants_java() {
        String name = NodeFiles.nodeConstants();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), name + ".java");
        try {
            String n;
            int i;
            OutputFile outputFile = new OutputFile(file);
            PrintWriter ostr = outputFile.getPrintWriter();
            List<String> nodeIds = ASTNodeDescriptor.getNodeIds();
            List<String> nodeNames = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(ostr);
            ostr.println("public interface " + name);
            ostr.println("{");
            for (i = 0; i < nodeIds.size(); ++i) {
                n = nodeIds.get(i);
                ostr.println("  public int " + n + " = " + i + ";");
            }
            ostr.println();
            ostr.println();
            ostr.println("  public String[] jjtNodeName = {");
            for (i = 0; i < nodeNames.size(); ++i) {
                n = nodeNames.get(i);
                ostr.println("    \"" + n + "\",");
            }
            ostr.println("  };");
            ostr.println("}");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static String visitorClass() {
        return JJTreeGlobals.parserName + "Visitor";
    }

    static void generateVisitor_java() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        String name = NodeFiles.visitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), name + ".java");
        try {
            OutputFile outputFile = new OutputFile(file);
            PrintWriter ostr = outputFile.getPrintWriter();
            List<String> nodeNames = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(ostr);
            ostr.println("public interface " + name);
            ostr.println("{");
            String ve = NodeFiles.mergeVisitorException();
            String argumentType = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                argumentType = JJTreeOptions.getVisitorDataType();
            }
            ostr.println("  public " + JJTreeOptions.getVisitorReturnType() + " visit(SimpleNode node, " + argumentType + " data)" + ve + ";");
            if (JJTreeOptions.getMulti()) {
                for (int i = 0; i < nodeNames.size(); ++i) {
                    String n = nodeNames.get(i);
                    if (n.equals("void")) continue;
                    String nodeType = JJTreeOptions.getNodePrefix() + n;
                    ostr.println("  public " + JJTreeOptions.getVisitorReturnType() + " " + NodeFiles.getVisitMethodName(nodeType) + "(" + nodeType + " node, " + argumentType + " data)" + ve + ";");
                }
            }
            ostr.println("}");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    static String defaultVisitorClass() {
        return JJTreeGlobals.parserName + "DefaultVisitor";
    }

    private static String getVisitMethodName(String className) {
        StringBuffer sb = new StringBuffer("visit");
        if (JJTreeOptions.booleanValue("VISITOR_METHOD_NAME_INCLUDES_TYPE_NAME")) {
            sb.append(Character.toUpperCase(className.charAt(0)));
            for (int i = 1; i < className.length(); ++i) {
                sb.append(className.charAt(i));
            }
        }
        return sb.toString();
    }

    static void generateDefaultVisitor_java() {
        if (!JJTreeOptions.getVisitor()) {
            return;
        }
        String className = NodeFiles.defaultVisitorClass();
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), className + ".java");
        try {
            OutputFile outputFile = new OutputFile(file);
            PrintWriter ostr = outputFile.getPrintWriter();
            List<String> nodeNames = ASTNodeDescriptor.getNodeNames();
            NodeFiles.generatePrologue(ostr);
            ostr.println("public class " + className + " implements " + NodeFiles.visitorClass() + "{");
            String ve = NodeFiles.mergeVisitorException();
            String argumentType = "Object";
            if (!JJTreeOptions.getVisitorDataType().equals("")) {
                argumentType = JJTreeOptions.getVisitorDataType();
            }
            String ret = JJTreeOptions.getVisitorReturnType();
            ostr.println("  public " + ret + " defaultVisit(SimpleNode node, " + argumentType + " data)" + ve + "{");
            ostr.println("    node.childrenAccept(this, data);");
            ostr.println("    return" + (ret.trim().equals("void") ? "" : " data") + ";");
            ostr.println("  }");
            ostr.println("  public " + ret + " visit(SimpleNode node, " + argumentType + " data)" + ve + "{");
            ostr.println("    " + (ret.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
            ostr.println("  }");
            if (JJTreeOptions.getMulti()) {
                for (int i = 0; i < nodeNames.size(); ++i) {
                    String n = nodeNames.get(i);
                    if (n.equals("void")) continue;
                    String nodeType = JJTreeOptions.getNodePrefix() + n;
                    ostr.println("  public " + ret + " " + NodeFiles.getVisitMethodName(nodeType) + "(" + nodeType + " node, " + argumentType + " data)" + ve + "{");
                    ostr.println("    " + (ret.trim().equals("void") ? "" : "return ") + "defaultVisit(node, data);");
                    ostr.println("  }");
                }
            }
            ostr.println("}");
            ostr.close();
        }
        catch (IOException e) {
            throw new Error(e.toString());
        }
    }

    private static String mergeVisitorException() {
        String ve = JJTreeOptions.getVisitorException();
        if (!"".equals(ve)) {
            ve = " throws " + ve;
        }
        return ve;
    }

    private static void generateNode_java(OutputFile outputFile) throws IOException {
        PrintWriter ostr = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(ostr);
        HashMap<String, Object> options = new HashMap<String, Object>(Options.getOptions());
        options.put("PARSER_NAME", JJTreeGlobals.parserName);
        OutputFileGenerator generator = new OutputFileGenerator("/templates/Node.template", options);
        generator.generate(ostr);
        ostr.close();
    }

    private static void generateSimpleNode_java(OutputFile outputFile) throws IOException {
        PrintWriter ostr = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(ostr);
        HashMap<String, Object> options = new HashMap<String, Object>(Options.getOptions());
        options.put("PARSER_NAME", JJTreeGlobals.parserName);
        options.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
        OutputFileGenerator generator = new OutputFileGenerator("/templates/SimpleNode.template", options);
        generator.generate(ostr);
        ostr.close();
    }

    private static void generateMULTINode_java(OutputFile outputFile, String nodeType) throws IOException {
        PrintWriter ostr = outputFile.getPrintWriter();
        NodeFiles.generatePrologue(ostr);
        HashMap<String, Object> options = new HashMap<String, Object>(Options.getOptions());
        options.put("PARSER_NAME", JJTreeGlobals.parserName);
        options.put("NODE_TYPE", nodeType);
        options.put("VISITOR_RETURN_TYPE_VOID", JJTreeOptions.getVisitorReturnType().equals("void"));
        OutputFileGenerator generator = new OutputFileGenerator("/templates/MultiNode.template", options);
        generator.generate(ostr);
        ostr.close();
    }
}

