/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetterCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetterCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PropertiesToFieldsLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "buildSubstitution", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "needBlock", "", "setOrGetExpr", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "receiver", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "shouldSubstituteAccessorWithField", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "accessor", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "substituteGetter", "irProperty", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substituteSetter", "visitCall", "visitProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend.jvm"})
public final class PropertiesToFieldsLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (declaration.isConst() || this.shouldSubstituteAccessorWithField(declaration, declaration.getGetter())) {
            declaration.setGetter(null);
        }
        if (declaration.isConst() || this.shouldSubstituteAccessorWithField(declaration, declaration.getSetter())) {
            declaration.setSetter(null);
        }
        return super.visitProperty(declaration);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunction irFunction = expression2.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction simpleFunction = irSimpleFunction;
        IrProperty irProperty = simpleFunction.getCorrespondingProperty();
        if (irProperty == null) {
            return super.visitCall(expression2);
        }
        IrProperty property = irProperty;
        if (this.shouldSubstituteAccessorWithField(property, simpleFunction)) {
            IrCall irCall = expression2;
            if (irCall instanceof IrGetterCallImpl) {
                return this.substituteGetter(property, expression2);
            }
            if (irCall instanceof IrSetterCallImpl) {
                return this.substituteSetter(property, expression2);
            }
        }
        return super.visitCall(expression2);
    }

    private final boolean shouldSubstituteAccessorWithField(IrProperty property, IrSimpleFunction accessor) {
        if (accessor == null) {
            return false;
        }
        if (property.isLateinit()) {
            return false;
        }
        IrDeclarationParent irDeclarationParent = property.getParent();
        if (!(irDeclarationParent instanceof IrClass)) {
            irDeclarationParent = null;
        }
        IrClass irClass = (IrClass)irDeclarationParent;
        if ((irClass != null ? irClass.getKind() : null) == ClassKind.ANNOTATION_CLASS) {
            return false;
        }
        IrField irField = property.getBackingField();
        if (irField != null) {
            IrAnnotationContainer irAnnotationContainer = irField;
            FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JVM_FIELD_ANNOTATION_FQ_NAME");
            if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
                return true;
            }
        }
        return Intrinsics.areEqual((Object)accessor.getOrigin(), (Object)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE) && Visibilities.isPrivate(accessor.getVisibility());
    }

    private final IrExpression substituteSetter(IrProperty irProperty, IrCall expression2) {
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            Intrinsics.throwNpe();
        }
        IrField backingField2 = irField;
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrExpression receiver2 = irExpression != null ? irExpression.transform(this, null) : null;
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        IrFieldSymbol irFieldSymbol = (IrFieldSymbol)backingField2.getSymbol();
        IrExpression irExpression2 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        IrSetFieldImpl setExpr = new IrSetFieldImpl(n, n2, irFieldSymbol, receiver2, irExpression2.transform(this, null), expression2.getType(), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        return this.buildSubstitution(backingField2.isStatic(), setExpr, receiver2);
    }

    private final IrExpression substituteGetter(IrProperty irProperty, IrCall expression2) {
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            Intrinsics.throwNpe();
        }
        IrField backingField2 = irField;
        IrExpression irExpression = expression2.getDispatchReceiver();
        IrExpression receiver2 = irExpression != null ? irExpression.transform(this, null) : null;
        IrGetFieldImpl getExpr = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)backingField2.getSymbol(), expression2.getType(), receiver2, expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        return this.buildSubstitution(backingField2.isStatic(), getExpr, receiver2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSubstitution(boolean needBlock, IrFieldAccessExpression setOrGetExpr, IrExpression receiver2) {
        if (receiver2 != null && needBlock) {
            void startOffset$iv$iv;
            void $this$irBlock$iv$iv;
            IrGeneratorWithScope $this$irBlock$iv = LowerUtilsKt.createIrBuilder(this.context, setOrGetExpr.getSymbol(), setOrGetExpr.getStartOffset(), setOrGetExpr.getEndOffset());
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = ((IrExpression)setOrGetExpr).getType();
            boolean $i$f$irBlock = false;
            IrGeneratorWithScope irGeneratorWithScope = $this$irBlock$iv;
            int n = ((IrExpression)setOrGetExpr).getStartOffset();
            int endOffset$iv$iv = ((IrExpression)setOrGetExpr).getEndOffset();
            boolean $i$f$irBlock2 = false;
            IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
            boolean bl = false;
            IrTypeOperatorCallImpl receiverVoid = new IrTypeOperatorCallImpl(receiver2.getStartOffset(), receiver2.getEndOffset(), $this$irBlock.getContext().getIrBuiltIns().getUnitType(), IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, $this$irBlock.getContext().getIrBuiltIns().getUnitType(), IrTypesKt.getClassifierOrFail($this$irBlock.getContext().getIrBuiltIns().getUnitType()), receiver2);
            $this$irBlock.unaryPlus(receiverVoid);
            setOrGetExpr.setReceiver(null);
            $this$irBlock.unaryPlus(setOrGetExpr);
            return this_$iv$iv$iv.doBuild();
        }
        return setOrGetExpr;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public PropertiesToFieldsLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

