/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.internal.tasks.properties.AbstractPropertyNode;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.TypeScheme;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.cache.internal.DefaultCrossBuildInMemoryCacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.event.DefaultListenerManager;
import org.gradle.internal.instantiation.DefaultInstantiatorFactory;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.ParameterValidationContext;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.service.DefaultServiceLocator;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.PluginServiceRegistry;

@NonNullApi
public class PropertyValidationAccess {
    private static final Map<Class<? extends Annotation>, ? extends PropertyValidator> PROPERTY_VALIDATORS = ImmutableMap.of(InputFiles.class, (Object)new MissingNormalizationValidator(false), InputFile.class, (Object)new MissingNormalizationValidator(false), InputDirectory.class, (Object)new MissingNormalizationValidator(false));
    private static final Map<Class<? extends Annotation>, ? extends PropertyValidator> STRICT_PROPERTY_VALIDATORS = ImmutableMap.of(InputFiles.class, (Object)new MissingNormalizationValidator(true), InputFile.class, (Object)new MissingNormalizationValidator(true), InputDirectory.class, (Object)new MissingNormalizationValidator(true));
    private static final PropertyValidationAccess INSTANCE = new PropertyValidationAccess();
    private final TaskClassInfoStore taskClassInfoStore;
    private final List<TypeScheme> typeSchemes;

    @VisibleForTesting
    PropertyValidationAccess() {
        ServiceRegistryBuilder builder = ServiceRegistryBuilder.builder().displayName("Global services");
        builder.provider(new Object(){

            void configure(ServiceRegistration registration) {
                registration.add(DefaultListenerManager.class, (Object)new DefaultListenerManager());
                registration.add(DefaultCrossBuildInMemoryCacheFactory.class);
                registration.add(DefaultInstantiatorFactory.class);
                List pluginServiceFactories = new DefaultServiceLocator(false, new ClassLoader[]{this.getClass().getClassLoader()}).getAll(PluginServiceRegistry.class);
                for (PluginServiceRegistry pluginServiceFactory : pluginServiceFactories) {
                    pluginServiceFactory.registerGlobalServices(registration);
                }
            }
        });
        ServiceRegistry services = builder.build();
        this.taskClassInfoStore = (TaskClassInfoStore)services.get(TaskClassInfoStore.class);
        this.typeSchemes = services.getAll(TypeScheme.class);
    }

    public static void collectTaskValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        INSTANCE.collectTypeValidationProblems(topLevelBean, problems, enableStricterValidation);
    }

    public static void collectValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        INSTANCE.collectTypeValidationProblems(topLevelBean, problems, enableStricterValidation);
    }

    private void collectTypeValidationProblems(Class<?> topLevelBean, Map<String, Boolean> problems, boolean enableStricterValidation) {
        boolean stricterValidation;
        boolean mapErrorsToWarnings;
        boolean cacheable;
        if (topLevelBean.equals(TaskInternal.class)) {
            return;
        }
        TypeMetadataStore metadataStore = null;
        for (TypeScheme typeScheme : this.typeSchemes) {
            if (!typeScheme.appliesTo(topLevelBean)) continue;
            metadataStore = typeScheme.getMetadataStore();
            break;
        }
        if (metadataStore == null) {
            return;
        }
        if (Task.class.isAssignableFrom(topLevelBean)) {
            cacheable = this.taskClassInfoStore.getTaskClassInfo((Class)Cast.uncheckedNonnullCast(topLevelBean)).isCacheable();
            mapErrorsToWarnings = true;
        } else if (TransformAction.class.isAssignableFrom(topLevelBean)) {
            cacheable = topLevelBean.isAnnotationPresent(CacheableTransform.class);
            mapErrorsToWarnings = false;
        } else {
            cacheable = false;
            mapErrorsToWarnings = false;
        }
        ArrayDeque queue = new ArrayDeque();
        BeanTypeNodeFactory nodeFactory = new BeanTypeNodeFactory(metadataStore);
        queue.add(nodeFactory.createRootNode(TypeToken.of(topLevelBean)));
        boolean bl = stricterValidation = enableStricterValidation || cacheable;
        while (!queue.isEmpty()) {
            BeanTypeNode node = (BeanTypeNode)queue.remove();
            node.visit(topLevelBean, stricterValidation, new ProblemCollector(problems, mapErrorsToWarnings), queue, nodeFactory);
        }
    }

    private static <T> TypeToken<?> extractNestedType(TypeToken<T> beanType, Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
        ParameterizedType type = (ParameterizedType)beanType.getSupertype(parameterizedSuperClass).getType();
        return TypeToken.of((Type)type.getActualTypeArguments()[typeParameterIndex]);
    }

    private static class MissingNormalizationValidator
    implements PropertyValidator {
        final boolean stricterValidation;

        public MissingNormalizationValidator(boolean stricterValidation) {
            this.stricterValidation = stricterValidation;
        }

        @Override
        public void validate(@Nullable String ownerPath, PropertyMetadata metadata, ParameterValidationContext validationContext) {
            if (this.stricterValidation && !metadata.hasAnnotationForCategory((AnnotationCategory)ModifierAnnotationCategory.NORMALIZATION)) {
                validationContext.visitError(ownerPath, metadata.getPropertyName(), "is missing a normalization annotation, defaulting to PathSensitivity.ABSOLUTE");
            }
        }
    }

    private static interface PropertyValidator {
        public void validate(@Nullable String var1, PropertyMetadata var2, ParameterValidationContext var3);
    }

    private static class MapBeanTypeNode
    extends BeanTypeNode<Map<?, ?>> {
        public MapBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Map<?, ?>> mapType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, mapType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, ProblemCollector problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Map.class, 1);
            nodeFactory.createAndAddToQueue(this, this.getQualifiedPropertyName("<key>"), nestedType, queue);
        }
    }

    private static class IterableBeanTypeNode
    extends BeanTypeNode<Iterable<?>> {
        public IterableBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<Iterable<?>> iterableType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, iterableType, typeMetadata);
        }

        private String determinePropertyName(TypeToken<?> nestedType) {
            return Named.class.isAssignableFrom(nestedType.getRawType()) ? this.getQualifiedPropertyName("<name>") : this.getPropertyName() + "*";
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, ProblemCollector problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeToken<?> nestedType = this.extractNestedType(Iterable.class, 0);
            nodeFactory.createAndAddToQueue(this, this.determinePropertyName(nestedType), nestedType, queue);
        }
    }

    private static class NestedBeanTypeNode
    extends BeanTypeNode<Object> {
        public NestedBeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String parentPropertyName, TypeToken<?> beanType, TypeMetadata typeMetadata) {
            super(parentNode, parentPropertyName, beanType, typeMetadata);
        }

        @Override
        public void visit(Class<?> topLevelBean, boolean stricterValidation, ProblemCollector problems, Queue<BeanTypeNode<?>> queue, BeanTypeNodeFactory nodeFactory) {
            TypeMetadata typeMetadata = this.getTypeMetadata();
            CollectingParameterValidationContext validationContext = new CollectingParameterValidationContext(topLevelBean, problems);
            typeMetadata.collectValidationFailures(this.getPropertyName(), validationContext);
            for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
                PropertyValidator validator;
                String qualifiedPropertyName = this.getQualifiedPropertyName(propertyMetadata.getPropertyName());
                Class propertyType = propertyMetadata.getPropertyType();
                PropertyValidator propertyValidator = validator = stricterValidation ? (PropertyValidator)STRICT_PROPERTY_VALIDATORS.get(propertyType) : (PropertyValidator)PROPERTY_VALIDATORS.get(propertyType);
                if (validator != null) {
                    validator.validate(null, propertyMetadata, validationContext);
                }
                if (!propertyMetadata.getPropertyType().equals(Nested.class)) continue;
                TypeToken<?> beanType = NestedBeanTypeNode.unpackProvider(propertyMetadata.getGetterMethod());
                nodeFactory.createAndAddToQueue(this, qualifiedPropertyName, beanType, queue);
            }
        }

        private static TypeToken<?> unpackProvider(Method method) {
            Class<?> rawType = method.getReturnType();
            TypeToken genericReturnType = TypeToken.of((Type)method.getGenericReturnType());
            if (Provider.class.isAssignableFrom(rawType)) {
                return PropertyValidationAccess.extractNestedType((TypeToken)Cast.uncheckedNonnullCast((Object)genericReturnType), Provider.class, 0);
            }
            return genericReturnType;
        }

        private class CollectingParameterValidationContext
        implements ParameterValidationContext {
            private final Class<?> topLevelBean;
            private final ProblemCollector problems;

            public CollectingParameterValidationContext(Class<?> topLevelBean, ProblemCollector problems) {
                this.topLevelBean = topLevelBean;
                this.problems = problems;
            }

            private String decorateMessage(String propertyName, String message) {
                return String.format("Type '%s': property '%s' %s.", this.topLevelBean.getName(), NestedBeanTypeNode.this.getQualifiedPropertyName(propertyName), message);
            }

            public void visitError(@Nullable String ownerPath, String propertyName, String message) {
                this.visitError(this.decorateMessage(propertyName, message));
            }

            public void visitError(String message) {
                this.problems.error(message, false);
            }

            public void visitErrorStrict(@Nullable String ownerPath, String propertyName, String message) {
                this.visitErrorStrict(this.decorateMessage(propertyName, message));
            }

            public void visitErrorStrict(String message) {
                this.problems.error(message, true);
            }
        }
    }

    private static abstract class BeanTypeNode<T>
    extends AbstractPropertyNode<TypeToken<?>> {
        private final TypeToken<? extends T> beanType;

        protected BeanTypeNode(@Nullable BeanTypeNode<?> parentNode, @Nullable String propertyName, TypeToken<? extends T> beanType, TypeMetadata typeMetadata) {
            super(parentNode, propertyName, typeMetadata);
            this.beanType = beanType;
        }

        public abstract void visit(Class<?> var1, boolean var2, ProblemCollector var3, Queue<BeanTypeNode<?>> var4, BeanTypeNodeFactory var5);

        public boolean nodeCreatesCycle(TypeToken<?> childType) {
            return this.findNodeCreatingCycle(childType, Equivalence.equals()) != null;
        }

        protected TypeToken<?> extractNestedType(Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
            return PropertyValidationAccess.extractNestedType(this.beanType, parameterizedSuperClass, typeParameterIndex);
        }

        @Override
        protected TypeToken<?> getNodeValue() {
            return this.beanType;
        }
    }

    private static class BeanTypeNodeFactory {
        private final TypeMetadataStore metadataStore;

        public BeanTypeNodeFactory(TypeMetadataStore metadataStore) {
            this.metadataStore = metadataStore;
        }

        public BeanTypeNode<?> createRootNode(TypeToken<?> beanType) {
            return new NestedBeanTypeNode(null, null, beanType, this.metadataStore.getTypeMetadata(beanType.getRawType()));
        }

        public void createAndAddToQueue(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType, Queue<BeanTypeNode<?>> queue) {
            if (!parentNode.nodeCreatesCycle(beanType)) {
                queue.add(this.createChild(parentNode, propertyName, beanType));
            }
        }

        private BeanTypeNode<?> createChild(BeanTypeNode<?> parentNode, String propertyName, TypeToken<?> beanType) {
            Class rawType = beanType.getRawType();
            TypeMetadata typeMetadata = this.metadataStore.getTypeMetadata(rawType);
            if (!typeMetadata.hasAnnotatedProperties()) {
                if (Map.class.isAssignableFrom(rawType)) {
                    return new MapBeanTypeNode(parentNode, propertyName, (TypeToken<Map<?, ?>>)((TypeToken)Cast.uncheckedNonnullCast(beanType)), typeMetadata);
                }
                if (Iterable.class.isAssignableFrom(rawType)) {
                    return new IterableBeanTypeNode(parentNode, propertyName, (TypeToken<Iterable<?>>)((TypeToken)Cast.uncheckedNonnullCast(beanType)), typeMetadata);
                }
            }
            return new NestedBeanTypeNode(parentNode, propertyName, beanType, typeMetadata);
        }
    }

    private static class ProblemCollector {
        final Map<String, Boolean> problems;
        private final boolean mapErrorsToWarnings;

        public ProblemCollector(Map<String, Boolean> problems, boolean mapErrorsToWarnings) {
            this.problems = problems;
            this.mapErrorsToWarnings = mapErrorsToWarnings;
        }

        void error(String message, boolean strict) {
            this.problems.put(message, strict || !this.mapErrorsToWarnings);
        }
    }
}

