/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.ParseText;
import net.htmlparser.jericho.Source;

public class NumericCharacterReference
extends CharacterReference {
    private boolean hex;

    private NumericCharacterReference(Source source, int begin, int end, int codePoint, boolean hex) {
        super(source, begin, end, codePoint);
        this.hex = hex;
    }

    public boolean isDecimal() {
        return !this.hex;
    }

    public boolean isHexadecimal() {
        return this.hex;
    }

    public static String encode(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(unencodedText.length() * 2);
        for (int i = 0; i < unencodedText.length(); ++i) {
            char ch = unencodedText.charAt(i);
            if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(ch, true)) {
                try {
                    NumericCharacterReference.appendDecimalCharacterReferenceString(sb, ch);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String encodeDecimal(CharSequence unencodedText) {
        return NumericCharacterReference.encode(unencodedText);
    }

    public static String encodeHexadecimal(CharSequence unencodedText) {
        if (unencodedText == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(unencodedText.length() * 2);
        for (int i = 0; i < unencodedText.length(); ++i) {
            char ch = unencodedText.charAt(i);
            if (Config.CurrentCharacterReferenceEncodingBehaviour.isEncoded(ch, true)) {
                try {
                    NumericCharacterReference.appendHexadecimalCharacterReferenceString(sb, ch);
                    continue;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String getCharacterReferenceString() {
        return this.hex ? NumericCharacterReference.getHexadecimalCharacterReferenceString(this.codePoint) : NumericCharacterReference.getDecimalCharacterReferenceString(this.codePoint);
    }

    public static String getCharacterReferenceString(int codePoint) {
        return NumericCharacterReference.getDecimalCharacterReferenceString(codePoint);
    }

    static CharacterReference construct(Source source, int begin, Config.UnterminatedCharacterReferenceSettings unterminatedCharacterReferenceSettings) {
        int codePoint;
        int end;
        boolean hex;
        block13: {
            String codePointString;
            int codePointStringBegin;
            ParseText parseText = source.getParseText();
            hex = parseText.charAt(codePointStringBegin = begin + 2) == 'x';
            if (hex) {
                ++codePointStringBegin;
            }
            int unterminatedMaxCodePoint = hex ? unterminatedCharacterReferenceSettings.hexadecimalCharacterReferenceMaxCodePoint : unterminatedCharacterReferenceSettings.decimalCharacterReferenceMaxCodePoint;
            int maxSourcePos = source.end - 1;
            int x = codePointStringBegin;
            boolean unterminated = false;
            while (true) {
                char ch;
                if ((ch = parseText.charAt(x)) == ';') {
                    end = x + 1;
                    codePointString = source.substring(codePointStringBegin, x);
                    break;
                }
                if (ch >= '0' && ch <= '9' || hex && (ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                    if (x == maxSourcePos) {
                        unterminated = true;
                        ++x;
                    }
                } else {
                    unterminated = true;
                }
                if (unterminated) {
                    if (unterminatedMaxCodePoint == -1) {
                        return null;
                    }
                    end = x;
                    codePointString = source.substring(codePointStringBegin, x);
                    break;
                }
                ++x;
            }
            if (codePointString.length() == 0) {
                return null;
            }
            codePoint = -1;
            try {
                codePoint = Integer.parseInt(codePointString, hex ? 16 : 10);
                if (unterminated && codePoint > unterminatedMaxCodePoint) {
                    return null;
                }
                if (codePoint > 0x10FFFF) {
                    codePoint = -1;
                }
            }
            catch (NumberFormatException ex) {
                if (!unterminated) break block13;
                return null;
            }
        }
        return new NumericCharacterReference(source, begin, end, codePoint, hex);
    }

    @Override
    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        try {
            if (this.hex) {
                NumericCharacterReference.appendHexadecimalCharacterReferenceString(sb, this.codePoint);
            } else {
                NumericCharacterReference.appendDecimalCharacterReferenceString(sb, this.codePoint);
            }
            sb.append("\" ");
            NumericCharacterReference.appendUnicodeText(sb, this.codePoint);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        sb.append(' ').append(super.getDebugInfo());
        return sb.toString();
    }
}

