/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.Iterator;
import java.util.List;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.SubCache;
import net.htmlparser.jericho.Tag;
import net.htmlparser.jericho.TagType;

final class Cache {
    public final Source source;
    private final SubCache allTagTypesSubCache;
    private final SubCache[] subCaches;
    static final Cache STREAMED_SOURCE_MARKER = new Cache();

    public Cache(Source source) {
        this.source = source;
        this.allTagTypesSubCache = new SubCache(this, null);
        TagType[] separatelyCachedTagTypes = Cache.getSeparatelyCachedTagTypes();
        this.subCaches = new SubCache[separatelyCachedTagTypes.length + 1];
        this.subCaches[0] = this.allTagTypesSubCache;
        for (int i = 0; i < separatelyCachedTagTypes.length; ++i) {
            this.subCaches[i + 1] = new SubCache(this, separatelyCachedTagTypes[i]);
        }
    }

    private Cache() {
        this.source = null;
        this.allTagTypesSubCache = null;
        this.subCaches = null;
    }

    public void clear() {
        Iterator<Tag> i = this.allTagTypesSubCache.getTagIterator();
        while (i.hasNext()) {
            i.next().orphan();
        }
        for (int i2 = 0; i2 < this.subCaches.length; ++i2) {
            this.subCaches[i2].clear();
        }
    }

    public Tag getTagAt(int pos, boolean serverTagOnly) {
        return this.source.useAllTypesCache ? this.allTagTypesSubCache.getTagAt(pos, serverTagOnly) : Tag.getTagAtUncached(this.source, pos, serverTagOnly);
    }

    public Tag getPreviousTag(int pos) {
        return this.allTagTypesSubCache.getPreviousTag(pos);
    }

    public Tag getNextTag(int pos) {
        return this.allTagTypesSubCache.getNextTag(pos);
    }

    public Tag getPreviousTag(int pos, TagType tagType) {
        int i;
        int n = i = this.source.useAllTypesCache ? 0 : 1;
        while (i < this.subCaches.length) {
            if (tagType == this.subCaches[i].tagType) {
                return this.subCaches[i].getPreviousTag(pos);
            }
            ++i;
        }
        return Tag.getPreviousTagUncached(this.source, pos, tagType, -1);
    }

    public Tag getNextTag(int pos, TagType tagType) {
        int i;
        int n = i = this.source.useAllTypesCache ? 0 : 1;
        while (i < this.subCaches.length) {
            if (tagType == this.subCaches[i].tagType) {
                return this.subCaches[i].getNextTag(pos);
            }
            ++i;
        }
        return Tag.getNextTagUncached(this.source, pos, tagType, -1);
    }

    public Tag addTagAt(int pos, boolean serverTagOnly) {
        Tag tag = Tag.getTagAtUncached(this.source, pos, serverTagOnly);
        if (serverTagOnly && tag == null) {
            return null;
        }
        this.allTagTypesSubCache.addTagAt(pos, tag);
        if (tag == null) {
            return null;
        }
        TagType tagType = tag.getTagType();
        for (int i = 1; i < this.subCaches.length; ++i) {
            if (tagType != this.subCaches[i].tagType) continue;
            this.subCaches[i].addTagAt(pos, tag);
            return tag;
        }
        return tag;
    }

    public int getTagCount() {
        return this.allTagTypesSubCache.size() - 2;
    }

    public Iterator<Tag> getTagIterator() {
        return this.allTagTypesSubCache.getTagIterator();
    }

    public void loadAllTags(List<Tag> tags, Tag[] allRegisteredTags, StartTag[] allRegisteredStartTags) {
        int tagCount = tags.size();
        this.allTagTypesSubCache.bulkLoad_Init(tagCount);
        int registeredTagIndex = 0;
        int registeredStartTagIndex = 0;
        block0: for (int i = 0; i < tagCount; ++i) {
            Tag tag = tags.get(i);
            if (!tag.isUnregistered()) {
                allRegisteredTags[registeredTagIndex++] = tag;
                if (tag instanceof StartTag) {
                    allRegisteredStartTags[registeredStartTagIndex++] = (StartTag)tag;
                }
            }
            this.allTagTypesSubCache.bulkLoad_Set(i, tag);
            for (int x = 1; x < this.subCaches.length; ++x) {
                if (tag.getTagType() != this.subCaches[x].tagType) continue;
                this.subCaches[x].bulkLoad_AddToTypeSpecificCache(tag);
                continue block0;
            }
        }
        for (int x = 1; x < this.subCaches.length; ++x) {
            this.subCaches[x].bulkLoad_FinaliseTypeSpecificCache();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.subCaches.length; ++i) {
            this.subCaches[i].appendTo(sb);
        }
        return sb.toString();
    }

    protected int getSourceLength() {
        return this.source.end;
    }

    private static TagType[] getSeparatelyCachedTagTypes() {
        return TagType.getTagTypesIgnoringEnclosedMarkup();
    }
}

