/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZMA;

import SevenZip.Compression.LZ.OutWindow;
import SevenZip.Compression.LZMA.Base;
import SevenZip.Compression.RangeCoder.BitTreeDecoder;
import SevenZip.ICompressCoder;
import SevenZip.ICompressGetInStreamProcessedSize;
import SevenZip.ICompressProgressInfo;
import SevenZip.ICompressSetDecoderProperties2;
import SevenZip.ICompressSetInStream;
import SevenZip.ICompressSetOutStreamSize;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Decoder
extends InputStream
implements ICompressCoder,
ICompressSetDecoderProperties2,
ICompressGetInStreamProcessedSize,
ICompressSetInStream,
ICompressSetOutStreamSize {
    OutWindow m_OutWindow = new OutWindow();
    SevenZip.Compression.RangeCoder.Decoder m_RangeDecoder = new SevenZip.Compression.RangeCoder.Decoder();
    short[] m_IsMatchDecoders = new short[192];
    short[] m_IsRepDecoders = new short[12];
    short[] m_IsRepG0Decoders = new short[12];
    short[] m_IsRepG1Decoders = new short[12];
    short[] m_IsRepG2Decoders = new short[12];
    short[] m_IsRep0LongDecoders = new short[192];
    BitTreeDecoder[] m_PosSlotDecoder = new BitTreeDecoder[4];
    short[] m_PosDecoders = new short[114];
    BitTreeDecoder m_PosAlignDecoder = new BitTreeDecoder(4);
    LenDecoder m_LenDecoder = new LenDecoder();
    LenDecoder m_RepLenDecoder = new LenDecoder();
    LiteralDecoder m_LiteralDecoder = new LiteralDecoder();
    int m_DictionarySize = -1;
    int m_DictionarySizeCheck = -1;
    int m_posStateMask;
    long _outSize = 0L;
    boolean _outSizeDefined = false;
    int _remainLen;
    static final int kLenIdFinished = -1;
    static final int kLenIdNeedInit = -2;
    int _rep0;
    int _rep1;
    int _rep2;
    int _rep3;
    int _state;

    public Decoder() {
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i] = new BitTreeDecoder(6);
        }
    }

    boolean SetDictionarySize(int n) {
        if (n < 0) {
            return false;
        }
        if (this.m_DictionarySize != n) {
            this.m_DictionarySize = n;
            this.m_DictionarySizeCheck = Math.max(this.m_DictionarySize, 1);
            this.m_OutWindow.Create(Math.max(this.m_DictionarySizeCheck, 4096));
            this.m_RangeDecoder.Create(0x100000);
        }
        return true;
    }

    boolean SetLcLpPb(int n, int n2, int n3) {
        if (n > 8 || n2 > 4 || n3 > 4) {
            return false;
        }
        this.m_LiteralDecoder.Create(n2, n);
        int n4 = 1 << n3;
        this.m_LenDecoder.Create(n4);
        this.m_RepLenDecoder.Create(n4);
        this.m_posStateMask = n4 - 1;
        return true;
    }

    @Override
    public long GetInStreamProcessedSize() {
        throw new UnknownError("GetInStreamProcessedSize");
    }

    @Override
    public int ReleaseInStream() throws IOException {
        this.m_RangeDecoder.ReleaseStream();
        return 0;
    }

    @Override
    public int SetInStream(InputStream inputStream) {
        this.m_RangeDecoder.SetStream(inputStream);
        return 0;
    }

    @Override
    public int SetOutStreamSize(long l) {
        boolean bl = this._outSizeDefined = l != -1L;
        if (this._outSizeDefined) {
            this._outSize = l;
        }
        this._remainLen = -2;
        this.m_OutWindow.Init();
        return 0;
    }

    @Override
    public int read() throws IOException {
        throw new IOException("LZMA Decoder - read() not implemented");
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n != 0) {
            throw new IOException("LZMA Decoder - read(byte [] data, int off != 0, int size)) not implemented");
        }
        long l = this.m_OutWindow.GetProcessedSize();
        this.m_OutWindow.SetMemStream(byArray);
        int n3 = this.CodeSpec(n2);
        if (n3 != 0) {
            throw new IOException("Read - CodeSpec = " + n3);
        }
        n3 = this.Flush();
        if (n3 != 0) {
            throw new IOException("Read - Flush = " + n3);
        }
        int n4 = (int)(this.m_OutWindow.GetProcessedSize() - l);
        if (n4 == 0) {
            n4 = -1;
        }
        return n4;
    }

    void Init() throws IOException {
        this.m_OutWindow.Init(false);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsMatchDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRep0LongDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepDecoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG0Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG1Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_IsRepG2Decoders);
        SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_PosDecoders);
        this._rep3 = 0;
        this._rep2 = 0;
        this._rep1 = 0;
        this._rep0 = 0;
        this._state = Base.StateInit();
        this.m_LiteralDecoder.Init();
        for (int i = 0; i < 4; ++i) {
            this.m_PosSlotDecoder[i].Init();
        }
        this.m_LenDecoder.Init();
        this.m_RepLenDecoder.Init();
        this.m_PosAlignDecoder.Init();
    }

    public int Flush() throws IOException {
        this.m_OutWindow.Flush();
        return 0;
    }

    void ReleaseStreams() throws IOException {
        this.m_OutWindow.ReleaseStream();
        this.ReleaseInStream();
    }

    public int CodeReal(InputStream inputStream, OutputStream outputStream, long l, ICompressProgressInfo iCompressProgressInfo) throws IOException {
        this.SetInStream(inputStream);
        this.m_OutWindow.SetStream(outputStream);
        this.SetOutStreamSize(l);
        do {
            long l2;
            long l3;
            int n;
            int n2;
            if ((n2 = this.CodeSpec(n = 262144)) != 0) {
                return n2;
            }
            if (this._remainLen == -1) break;
            if (iCompressProgressInfo == null || (n2 = iCompressProgressInfo.SetRatioInfo(l3 = this.m_RangeDecoder.GetProcessedSize(), l2 = this.m_OutWindow.GetProcessedSize())) == 0) continue;
            return n2;
        } while (!this._outSizeDefined || this.m_OutWindow.GetProcessedSize() < this._outSize);
        return this.Flush();
    }

    @Override
    public int Code(InputStream inputStream, OutputStream outputStream, long l, ICompressProgressInfo iCompressProgressInfo) throws IOException {
        int n = 1;
        try {
            n = this.CodeReal(inputStream, outputStream, l, iCompressProgressInfo);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        finally {
            this.Flush();
            this.ReleaseStreams();
        }
        return n;
    }

    int CodeSpec(int n) throws IOException {
        byte by;
        long l;
        if (this._outSizeDefined && (long)n > (l = this._outSize - this.m_OutWindow.GetProcessedSize())) {
            n = (int)l;
        }
        if (this._remainLen == -1) {
            return 0;
        }
        if (this._remainLen == -2) {
            this.m_RangeDecoder.Init();
            this.Init();
            this._remainLen = 0;
        }
        if (n == 0) {
            return 0;
        }
        int n2 = this._rep0;
        int n3 = this._rep1;
        int n4 = this._rep2;
        int n5 = this._rep3;
        int n6 = this._state;
        while (this._remainLen > 0 && n > 0) {
            by = this.m_OutWindow.GetByte(n2);
            this.m_OutWindow.PutByte(by);
            --this._remainLen;
            --n;
        }
        long l2 = this.m_OutWindow.GetProcessedSize();
        by = l2 == 0L ? (byte)0 : this.m_OutWindow.GetByte(0);
        while (n > 0) {
            int n7;
            int n8;
            if (this.m_RangeDecoder.bufferedStream.WasFinished()) {
                return 1;
            }
            int n9 = (int)l2 & this.m_posStateMask;
            if (this.m_RangeDecoder.DecodeBit(this.m_IsMatchDecoders, (n6 << 4) + n9) == 0) {
                LiteralDecoder.Decoder2 decoder2 = this.m_LiteralDecoder.GetDecoder((int)l2, by);
                by = !Base.StateIsCharState(n6) ? decoder2.DecodeWithMatchByte(this.m_RangeDecoder, this.m_OutWindow.GetByte(n2)) : decoder2.DecodeNormal(this.m_RangeDecoder);
                this.m_OutWindow.PutByte(by);
                n6 = Base.StateUpdateChar(n6);
                --n;
                ++l2;
                continue;
            }
            if (this.m_RangeDecoder.DecodeBit(this.m_IsRepDecoders, n6) == 1) {
                n8 = 0;
                if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG0Decoders, n6) == 0) {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRep0LongDecoders, (n6 << 4) + n9) == 0) {
                        n6 = Base.StateUpdateShortRep(n6);
                        n8 = 1;
                    }
                } else {
                    if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG1Decoders, n6) == 0) {
                        n7 = n3;
                    } else {
                        if (this.m_RangeDecoder.DecodeBit(this.m_IsRepG2Decoders, n6) == 0) {
                            n7 = n4;
                        } else {
                            n7 = n5;
                            n5 = n4;
                        }
                        n4 = n3;
                    }
                    n3 = n2;
                    n2 = n7;
                }
                if (n8 == 0) {
                    n8 = this.m_RepLenDecoder.Decode(this.m_RangeDecoder, n9) + 2;
                    n6 = Base.StateUpdateRep(n6);
                }
            } else {
                n5 = n4;
                n4 = n3;
                n3 = n2;
                n8 = 2 + this.m_LenDecoder.Decode(this.m_RangeDecoder, n9);
                n6 = Base.StateUpdateMatch(n6);
                n7 = this.m_PosSlotDecoder[Base.GetLenToPosState(n8)].Decode(this.m_RangeDecoder);
                if (n7 >= 4) {
                    int n10 = (n7 >> 1) - 1;
                    n2 = (2 | n7 & 1) << n10;
                    if (n7 < 14) {
                        n2 += BitTreeDecoder.ReverseDecode(this.m_PosDecoders, n2 - n7 - 1, this.m_RangeDecoder, n10);
                    } else {
                        n2 += this.m_RangeDecoder.DecodeDirectBits(n10 - 4) << 4;
                        if ((n2 += this.m_PosAlignDecoder.ReverseDecode(this.m_RangeDecoder)) < 0) {
                            if (n2 == -1) break;
                            return 1;
                        }
                    }
                } else {
                    n2 = n7;
                }
            }
            if ((long)n2 >= l2 || n2 >= this.m_DictionarySizeCheck) {
                this._remainLen = -1;
                return 1;
            }
            n7 = n8;
            if (n8 > n) {
                n7 = n;
            }
            this.m_OutWindow.CopyBlock(n2, n7);
            by = this.m_OutWindow.GetByte(0);
            n -= n7;
            l2 += (long)n7;
            if ((n8 -= n7) == 0) continue;
            this._remainLen = n8;
            break;
        }
        if (this.m_RangeDecoder.bufferedStream.WasFinished()) {
            return 1;
        }
        this._rep0 = n2;
        this._rep1 = n3;
        this._rep2 = n4;
        this._rep3 = n5;
        this._state = n6;
        return 0;
    }

    @Override
    public boolean SetDecoderProperties2(byte[] byArray) {
        if (byArray.length < 5) {
            return false;
        }
        int n = byArray[0] & 0xFF;
        int n2 = n % 9;
        int n3 = n / 9;
        int n4 = n3 % 5;
        int n5 = n3 / 5;
        int n6 = 0;
        for (int i = 0; i < 4; ++i) {
            n6 += (byArray[1 + i] & 0xFF) << i * 8;
        }
        if (!this.SetLcLpPb(n2, n4, n5)) {
            return false;
        }
        return this.SetDictionarySize(n6);
    }

    class LiteralDecoder {
        Decoder2[] m_Coders;
        int m_NumPrevBits;
        int m_NumPosBits;
        int m_PosMask;

        LiteralDecoder() {
        }

        public void Create(int n, int n2) {
            if (this.m_Coders != null && this.m_NumPrevBits == n2 && this.m_NumPosBits == n) {
                return;
            }
            this.m_NumPosBits = n;
            this.m_PosMask = (1 << n) - 1;
            this.m_NumPrevBits = n2;
            int n3 = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            this.m_Coders = new Decoder2[n3];
            for (int i = 0; i < n3; ++i) {
                this.m_Coders[i] = new Decoder2();
            }
        }

        public void Init() {
            int n = 1 << this.m_NumPrevBits + this.m_NumPosBits;
            for (int i = 0; i < n; ++i) {
                this.m_Coders[i].Init();
            }
        }

        Decoder2 GetDecoder(int n, byte by) {
            return this.m_Coders[((n & this.m_PosMask) << this.m_NumPrevBits) + ((by & 0xFF) >>> 8 - this.m_NumPrevBits)];
        }

        class Decoder2 {
            short[] m_Decoders = new short[768];

            Decoder2() {
            }

            public void Init() {
                SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Decoders);
            }

            public byte DecodeNormal(SevenZip.Compression.RangeCoder.Decoder decoder) throws IOException {
                int n = 1;
                while ((n = n << 1 | decoder.DecodeBit(this.m_Decoders, n)) < 256) {
                }
                return (byte)n;
            }

            public byte DecodeWithMatchByte(SevenZip.Compression.RangeCoder.Decoder decoder, byte by) throws IOException {
                int n = 1;
                do {
                    int n2 = by >> 7 & 1;
                    by = (byte)(by << 1);
                    int n3 = decoder.DecodeBit(this.m_Decoders, (1 + n2 << 8) + n);
                    n = n << 1 | n3;
                    if (n2 == n3) continue;
                    while (n < 256) {
                        n = n << 1 | decoder.DecodeBit(this.m_Decoders, n);
                    }
                    break;
                } while (n < 256);
                return (byte)n;
            }
        }
    }

    class LenDecoder {
        short[] m_Choice = new short[2];
        BitTreeDecoder[] m_LowCoder = new BitTreeDecoder[16];
        BitTreeDecoder[] m_MidCoder = new BitTreeDecoder[16];
        BitTreeDecoder m_HighCoder = new BitTreeDecoder(8);
        int m_NumPosStates = 0;

        LenDecoder() {
        }

        public void Create(int n) {
            while (this.m_NumPosStates < n) {
                this.m_LowCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                this.m_MidCoder[this.m_NumPosStates] = new BitTreeDecoder(3);
                ++this.m_NumPosStates;
            }
        }

        public void Init() {
            SevenZip.Compression.RangeCoder.Decoder.InitBitModels(this.m_Choice);
            for (int i = 0; i < this.m_NumPosStates; ++i) {
                this.m_LowCoder[i].Init();
                this.m_MidCoder[i].Init();
            }
            this.m_HighCoder.Init();
        }

        public int Decode(SevenZip.Compression.RangeCoder.Decoder decoder, int n) throws IOException {
            if (decoder.DecodeBit(this.m_Choice, 0) == 0) {
                return this.m_LowCoder[n].Decode(decoder);
            }
            int n2 = 8;
            n2 = decoder.DecodeBit(this.m_Choice, 1) == 0 ? (n2 += this.m_MidCoder[n].Decode(decoder)) : (n2 += 8 + this.m_HighCoder.Decode(decoder));
            return n2;
        }
    }
}

