/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.BoolVector;
import Common.ByteBuffer;
import Common.CRC;
import Common.IntVector;
import Common.LongVector;
import Common.ObjectVector;
import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Decoder;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.Header;
import SevenZip.Archive.SevenZip.InArchiveInfo;
import SevenZip.Archive.SevenZip.InByte2;
import SevenZip.Archive.SevenZip.StreamSwitch;
import SevenZip.Common.SequentialOutStreamImp2;
import SevenZip.Common.StreamUtils;
import SevenZip.IInStream;
import java.io.IOException;

class InArchive
extends Header {
    public static final int kNumMax = Integer.MAX_VALUE;
    public static final int kNumNoIndex = -1;
    IInStream _stream;
    ObjectVector<InByte2> _inByteVector = new ObjectVector();
    InByte2 _inByteBack = new InByte2();
    long _arhiveBeginStreamPosition;
    long _position;
    static final long SECS_BETWEEN_EPOCHS = 11644473600L;
    static final long SECS_TO_100NS = 10000000L;

    public void AddByteStream(byte[] byArray, int n) {
        this._inByteVector.add(new InByte2());
        this._inByteBack = this._inByteVector.Back();
        this._inByteBack.Init(byArray, n);
    }

    void DeleteByteStream() {
        this._inByteVector.DeleteBack();
        if (!this._inByteVector.isEmpty()) {
            this._inByteBack = this._inByteVector.Back();
        }
    }

    static boolean TestSignatureCandidate(byte[] byArray, int n) {
        for (int i = 0; i < 6; ++i) {
            if (byArray[i + n] == kSignature[i]) continue;
            return false;
        }
        return true;
    }

    int ReadDirect(IInStream iInStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = StreamUtils.ReadStream(iInStream, byArray, n, n2);
        if (n3 != -1) {
            this._position += (long)n3;
        }
        return n3;
    }

    int ReadDirect(byte[] byArray, int n) throws IOException {
        return this.ReadDirect(this._stream, byArray, 0, n);
    }

    int SafeReadDirectUInt32() throws IOException {
        int n = 0;
        byte[] byArray = new byte[4];
        int n2 = this.ReadDirect(byArray, 4);
        if (n2 != 4) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 4; ++i) {
            n |= (byArray[i] & 0xFF) << 8 * i;
        }
        return n;
    }

    int ReadUInt32() throws IOException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = this.ReadByte();
            n |= n2 << 8 * i;
        }
        return n;
    }

    long ReadUInt64() throws IOException {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            int n = this.ReadByte();
            l |= (long)n << 8 * i;
        }
        return l;
    }

    int ReadBytes(byte[] byArray, int n) throws IOException {
        if (!this._inByteBack.ReadBytes(byArray, n)) {
            return -2147467259;
        }
        return 0;
    }

    int ReadByte() throws IOException {
        return this._inByteBack.ReadByte();
    }

    long SafeReadDirectUInt64() throws IOException {
        long l = 0L;
        byte[] byArray = new byte[8];
        int n = this.ReadDirect(byArray, 8);
        if (n != 8) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 8; ++i) {
            l |= (long)(byArray[i] & 0xFF) << 8 * i;
        }
        return l;
    }

    char ReadWideCharLE() throws IOException {
        int n = this._inByteBack.ReadByte();
        int n2 = this._inByteBack.ReadByte();
        char c = (char)(((char)n2 << 8) + n);
        return c;
    }

    long ReadNumber() throws IOException {
        int n = this.ReadByte();
        int n2 = 128;
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            if ((n & n2) == 0) {
                long l2 = n & n2 - 1;
                return l += l2 << i * 8;
            }
            int n3 = this.ReadByte();
            if (n3 < 0) {
                throw new IOException("ReadNumber - Can't read stream");
            }
            l |= (long)n3 << 8 * i;
            n2 >>= 1;
        }
        return l;
    }

    int ReadNum() throws IOException {
        long l = this.ReadNumber();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("ReadNum - value > CNum.kNumMax");
        }
        return (int)l;
    }

    long ReadID() throws IOException {
        return this.ReadNumber();
    }

    int FindAndReadSignature(IInStream iInStream, long l) throws IOException {
        this._position = this._arhiveBeginStreamPosition;
        iInStream.Seek(this._arhiveBeginStreamPosition, 0);
        byte[] byArray = new byte[6];
        int n = this.ReadDirect(iInStream, byArray, 0, 6);
        if (n != 6) {
            return 1;
        }
        if (InArchive.TestSignatureCandidate(byArray, 0)) {
            return 0;
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.SetCapacity(65536);
        byte[] byArray2 = byteBuffer.data();
        int n2 = 5;
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        long l2 = this._arhiveBeginStreamPosition + 1L;
        while (l == -1L || l2 - this._arhiveBeginStreamPosition <= l) {
            int n3 = 65536 - n2;
            n = this.ReadDirect(iInStream, byArray2, n2, n3);
            if (n == -1) {
                return 1;
            }
            int n4 = n2 + n;
            if (n4 < 6) break;
            int n5 = n4 - 6 + 1;
            int n6 = 0;
            while (n6 < n5) {
                if (InArchive.TestSignatureCandidate(byArray2, n6)) {
                    this._arhiveBeginStreamPosition = l2;
                    this._position = l2 + 6L;
                    iInStream.Seek(this._position, 0);
                    return 0;
                }
                ++n6;
                ++l2;
            }
            n2 = n4 - n5;
            System.arraycopy(byArray2, n5, byArray2, 0, n2);
        }
        return 1;
    }

    int SkeepData(long l) throws IOException {
        for (long i = 0L; i < l; ++i) {
            int n = this.ReadByte();
        }
        return 0;
    }

    int SkeepData() throws IOException {
        long l = this.ReadNumber();
        return this.SkeepData(l);
    }

    int ReadArchiveProperties(InArchiveInfo inArchiveInfo) throws IOException {
        long l;
        while ((l = this.ReadID()) != 0L) {
            this.SkeepData();
        }
        return 0;
    }

    int GetNextFolderItem(Folder folder) throws IOException {
        Object object;
        int n;
        int n2;
        int n3 = this.ReadNum();
        folder.Coders.clear();
        folder.Coders.Reserve(n3);
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            folder.Coders.add(new CoderInfo());
            CoderInfo coderInfo = folder.Coders.Back();
            do {
                coderInfo.AltCoders.add(new AltCoderInfo());
                object = coderInfo.AltCoders.Back();
                n = this.ReadByte();
                ((AltCoderInfo)object).MethodID.IDSize = (byte)(n & 0xF);
                int n6 = this.ReadBytes(((AltCoderInfo)object).MethodID.ID, ((AltCoderInfo)object).MethodID.IDSize);
                if (n6 != 0) {
                    return n6;
                }
                if ((n & 0x10) != 0) {
                    coderInfo.NumInStreams = this.ReadNum();
                    coderInfo.NumOutStreams = this.ReadNum();
                } else {
                    coderInfo.NumInStreams = 1;
                    coderInfo.NumOutStreams = 1;
                }
                if ((n & 0x20) == 0) continue;
                int n7 = this.ReadNum();
                ((AltCoderInfo)object).Properties.SetCapacity(n7);
                n6 = this.ReadBytes(((AltCoderInfo)object).Properties.data(), n7);
            } while ((n & 0x80) != 0);
            n4 += coderInfo.NumInStreams;
            n5 += coderInfo.NumOutStreams;
        }
        int n8 = n5 - 1;
        folder.BindPairs.clear();
        folder.BindPairs.Reserve(n8);
        for (n2 = 0; n2 < n8; ++n2) {
            object = new BindPair();
            ((BindPair)object).InIndex = this.ReadNum();
            ((BindPair)object).OutIndex = this.ReadNum();
            folder.BindPairs.add((BindPair)object);
        }
        int n9 = n4 - n8;
        folder.PackStreams.Reserve(n9);
        if (n9 == 1) {
            for (n = 0; n < n4; ++n) {
                if (folder.FindBindPairForInStream(n) >= 0) continue;
                folder.PackStreams.add(n);
                break;
            }
        } else {
            for (n2 = 0; n2 < n9; ++n2) {
                n = this.ReadNum();
                folder.PackStreams.add(n);
            }
        }
        return 0;
    }

    int WaitAttribute(long l) throws IOException {
        int n;
        do {
            long l2;
            if ((l2 = this.ReadID()) == l) {
                return 0;
            }
            if (l2 != 0L) continue;
            return 1;
        } while ((n = this.SkeepData()) == 0);
        return n;
    }

    int Open(IInStream iInStream, long l) throws IOException {
        this.Close();
        this._position = this._arhiveBeginStreamPosition = iInStream.Seek(0L, 1);
        int n = this.FindAndReadSignature(iInStream, l);
        if (n != 0) {
            return n;
        }
        this._stream = iInStream;
        return 0;
    }

    void Close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    int ReadStreamsInfo(ObjectVector<ByteBuffer> objectVector, long[] lArray, LongVector longVector, BoolVector boolVector, IntVector intVector, ObjectVector<Folder> objectVector2, IntVector intVector2, LongVector longVector2, BoolVector boolVector2, IntVector intVector3) throws IOException {
        while (true) {
            long l = this.ReadID();
            switch ((int)l) {
                case 0: {
                    return 0;
                }
                case 6: {
                    int n = this.ReadPackInfo(lArray, longVector, boolVector, intVector);
                    if (n == 0) break;
                    return n;
                }
                case 7: {
                    int n = this.ReadUnPackInfo(objectVector, objectVector2);
                    if (n == 0) break;
                    return n;
                }
                case 8: {
                    int n = this.ReadSubStreamsInfo(objectVector2, intVector2, longVector2, boolVector2, intVector3);
                    if (n == 0) break;
                    return n;
                }
            }
        }
    }

    int ReadFileNames(ObjectVector<FileItem> objectVector) throws IOException {
        for (int i = 0; i < objectVector.size(); ++i) {
            char c;
            String string = new String();
            while ((c = this.ReadWideCharLE()) != '\u0000') {
                string = string + c;
            }
            ((FileItem)objectVector.get((int)i)).name = string;
        }
        return 0;
    }

    int ReadBoolVector(int n, BoolVector boolVector) throws IOException {
        boolVector.clear();
        boolVector.Reserve(n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (n3 == 0) {
                n2 = this.ReadByte();
                n3 = 128;
            }
            boolVector.add((n2 & n3) != 0);
            n3 >>= 1;
        }
        return 0;
    }

    int ReadBoolVector2(int n, BoolVector boolVector) throws IOException {
        int n2 = this.ReadByte();
        if (n2 == 0) {
            return this.ReadBoolVector(n, boolVector);
        }
        boolVector.clear();
        boolVector.Reserve(n);
        for (int i = 0; i < n; ++i) {
            boolVector.add(true);
        }
        return 0;
    }

    int ReadHashDigests(int n, BoolVector boolVector, IntVector intVector) throws IOException {
        int n2 = this.ReadBoolVector2(n, boolVector);
        if (n2 != 0) {
            return n2;
        }
        intVector.clear();
        intVector.Reserve(n);
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            if (boolVector.get(i)) {
                n3 = this.ReadUInt32();
            }
            intVector.add(n3);
        }
        return 0;
    }

    int ReadPackInfo(long[] lArray, LongVector longVector, BoolVector boolVector, IntVector intVector) throws IOException {
        long l;
        lArray[0] = this.ReadNumber();
        int n = this.ReadNum();
        int n2 = this.WaitAttribute(9L);
        if (n2 != 0) {
            return n2;
        }
        longVector.clear();
        longVector.Reserve(n);
        for (int i = 0; i < n; ++i) {
            long l2 = this.ReadNumber();
            longVector.add(l2);
        }
        while ((l = this.ReadID()) != 0L) {
            if (!(l == 10L ? (n2 = this.ReadHashDigests(n, boolVector, intVector)) != 0 : (n2 = this.SkeepData()) != 0)) continue;
            return n2;
        }
        if (boolVector.isEmpty()) {
            boolVector.Reserve(n);
            boolVector.clear();
            intVector.Reserve(n);
            intVector.clear();
            for (int i = 0; i < n; ++i) {
                boolVector.add(false);
                intVector.add(0);
            }
        }
        return 0;
    }

    int ReadUnPackInfo(ObjectVector<ByteBuffer> objectVector, ObjectVector<Folder> objectVector2) throws IOException {
        int n = this.WaitAttribute(11L);
        if (n != 0) {
            return n;
        }
        int n2 = this.ReadNum();
        StreamSwitch streamSwitch = new StreamSwitch();
        n = streamSwitch.Set(this, objectVector);
        if (n != 0) {
            return n;
        }
        objectVector2.clear();
        objectVector2.Reserve(n2);
        for (int i = 0; i < n2; ++i) {
            objectVector2.add(new Folder());
            n = this.GetNextFolderItem(objectVector2.Back());
            if (n == 0) continue;
            streamSwitch.close();
            return n;
        }
        streamSwitch.close();
        n = this.WaitAttribute(12L);
        if (n != 0) {
            return n;
        }
        for (int i = 0; i < n2; ++i) {
            Folder folder = (Folder)objectVector2.get(i);
            int n3 = folder.GetNumOutStreams();
            folder.UnPackSizes.Reserve(n3);
            for (int j = 0; j < n3; ++j) {
                long l = this.ReadNumber();
                folder.UnPackSizes.add(l);
            }
        }
        block3: while (true) {
            long l;
            if ((l = this.ReadID()) == 0L) {
                return 0;
            }
            if (l == 10L) {
                BoolVector boolVector = new BoolVector();
                IntVector intVector = new IntVector();
                n = this.ReadHashDigests(n2, boolVector, intVector);
                if (n != 0) {
                    return n;
                }
                int n4 = 0;
                while (true) {
                    if (n4 >= n2) continue block3;
                    Folder folder = (Folder)objectVector2.get(n4);
                    folder.UnPackCRCDefined = boolVector.get(n4);
                    folder.UnPackCRC = intVector.get(n4);
                    ++n4;
                }
            }
            n = this.SkeepData();
            if (n != 0) break;
        }
        return n;
    }

    int ReadSubStreamsInfo(ObjectVector<Folder> objectVector, IntVector intVector, LongVector longVector, BoolVector boolVector, IntVector intVector2) throws IOException {
        int n;
        int n2;
        int n3;
        long l;
        block21: {
            intVector.clear();
            intVector.Reserve(objectVector.size());
            block0: while (true) {
                if ((l = this.ReadID()) == 13L) {
                    n3 = 0;
                    while (true) {
                        if (n3 >= objectVector.size()) continue block0;
                        n2 = this.ReadNum();
                        intVector.add(n2);
                        ++n3;
                    }
                }
                if (l == 10L || l == 9L || l == 0L) break block21;
                n3 = this.SkeepData();
                if (n3 != 0) break;
            }
            return n3;
        }
        if (intVector.isEmpty()) {
            for (n3 = 0; n3 < objectVector.size(); ++n3) {
                intVector.add(1);
            }
        }
        for (n3 = 0; n3 < intVector.size(); ++n3) {
            n2 = intVector.get(n3);
            if (n2 == 0) continue;
            long l2 = 0L;
            for (n = 1; n < n2; ++n) {
                if (l != 9L) continue;
                long l3 = this.ReadNumber();
                longVector.add(l3);
                l2 += l3;
            }
            longVector.add(((Folder)objectVector.get(n3)).GetUnPackSize() - l2);
        }
        if (l == 9L) {
            l = this.ReadID();
        }
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < objectVector.size(); ++i) {
            int n4 = intVector.get(i);
            if (n4 != 1 || !((Folder)objectVector.get((int)i)).UnPackCRCDefined) {
                n3 += n4;
            }
            n2 += n4;
        }
        while (true) {
            if (l == 10L) {
                BoolVector boolVector2 = new BoolVector();
                IntVector intVector3 = new IntVector();
                n = this.ReadHashDigests(n3, boolVector2, intVector3);
                if (n != 0) {
                    return n;
                }
                int n5 = 0;
                for (int i = 0; i < objectVector.size(); ++i) {
                    int n6 = intVector.get(i);
                    Folder folder = (Folder)objectVector.get(i);
                    if (n6 == 1 && folder.UnPackCRCDefined) {
                        boolVector.add(true);
                        intVector2.add(folder.UnPackCRC);
                        continue;
                    }
                    int n7 = 0;
                    while (n7 < n6) {
                        boolVector.add(boolVector2.get(n5));
                        intVector2.add(intVector3.get(n5));
                        ++n7;
                        ++n5;
                    }
                }
            } else {
                if (l == 0L) {
                    if (boolVector.isEmpty()) {
                        boolVector.clear();
                        intVector2.clear();
                        for (int i = 0; i < n2; ++i) {
                            boolVector.add(false);
                            intVector2.add(0);
                        }
                    }
                    return 0;
                }
                int n8 = this.SkeepData();
                if (n8 != 0) {
                    return n8;
                }
            }
            l = this.ReadID();
        }
    }

    static long FileTimeToLong(int n, int n2) {
        long l = n;
        l <<= 32;
        return ((l |= (long)n2 & 0xFFFFFFFFL) - 116444736000000000L) / 10000L;
    }

    int ReadTime(ObjectVector<ByteBuffer> objectVector, ObjectVector<FileItem> objectVector2, long l) throws IOException {
        BoolVector boolVector = new BoolVector();
        int n = this.ReadBoolVector2(objectVector2.size(), boolVector);
        if (n != 0) {
            return n;
        }
        StreamSwitch streamSwitch = new StreamSwitch();
        n = streamSwitch.Set(this, objectVector);
        if (n != 0) {
            streamSwitch.close();
            return n;
        }
        block5: for (int i = 0; i < objectVector2.size(); ++i) {
            FileItem fileItem = (FileItem)objectVector2.get(i);
            int n2 = 0;
            int n3 = 0;
            boolean bl = boolVector.get(i);
            if (bl) {
                n2 = this.ReadUInt32();
                n3 = this.ReadUInt32();
            }
            switch ((int)l) {
                case 18: {
                    if (!bl) continue block5;
                    fileItem.CreationTime = InArchive.FileTimeToLong(n3, n2);
                    continue block5;
                }
                case 20: {
                    if (!bl) continue block5;
                    fileItem.LastWriteTime = InArchive.FileTimeToLong(n3, n2);
                    continue block5;
                }
                case 19: {
                    if (!bl) continue block5;
                    fileItem.LastAccessTime = InArchive.FileTimeToLong(n3, n2);
                }
            }
        }
        streamSwitch.close();
        return 0;
    }

    int ReadAndDecodePackedStreams(long l, long[] lArray, ObjectVector<ByteBuffer> objectVector) throws IOException {
        LongVector longVector = new LongVector();
        BoolVector boolVector = new BoolVector();
        IntVector intVector = new IntVector();
        ObjectVector<Folder> objectVector2 = new ObjectVector<Folder>();
        IntVector intVector2 = new IntVector();
        LongVector longVector2 = new LongVector();
        BoolVector boolVector2 = new BoolVector();
        IntVector intVector3 = new IntVector();
        int n = this.ReadStreamsInfo(null, lArray, longVector, boolVector, intVector, objectVector2, intVector2, longVector2, boolVector2, intVector3);
        int n2 = 0;
        Decoder decoder = new Decoder(false);
        long l2 = l + lArray[0];
        for (int i = 0; i < objectVector2.size(); ++i) {
            SequentialOutStreamImp2 sequentialOutStreamImp2;
            Folder folder = (Folder)objectVector2.get(i);
            objectVector.add(new ByteBuffer());
            ByteBuffer byteBuffer = objectVector.Back();
            long l3 = folder.GetUnPackSize();
            if (l3 > Integer.MAX_VALUE) {
                return -2147467259;
            }
            if (l3 > 0xFFFFFFFFL) {
                return -2147467259;
            }
            byteBuffer.SetCapacity((int)l3);
            SequentialOutStreamImp2 sequentialOutStreamImp22 = sequentialOutStreamImp2 = new SequentialOutStreamImp2();
            sequentialOutStreamImp2.Init(byteBuffer.data(), (int)l3);
            int n3 = decoder.Decode(this._stream, l2, longVector, n2, folder, sequentialOutStreamImp22, null);
            if (n3 != 0) {
                return n3;
            }
            if (folder.UnPackCRCDefined && !CRC.VerifyDigest(folder.UnPackCRC, byteBuffer.data(), (int)l3)) {
                throw new IOException("Incorrect Header");
            }
            for (int j = 0; j < folder.PackStreams.size(); ++j) {
                l2 += longVector.get(n2++);
            }
        }
        return 0;
    }

    int ReadDatabase(ArchiveDatabaseEx archiveDatabaseEx) throws IOException {
        long l;
        archiveDatabaseEx.Clear();
        archiveDatabaseEx.ArchiveInfo.StartPosition = this._arhiveBeginStreamPosition;
        byte[] byArray = new byte[2];
        int n = this.ReadDirect(byArray, 2);
        if (n != 2) {
            throw new IOException("Unexpected End Of Archive");
        }
        archiveDatabaseEx.ArchiveInfo.ArchiveVersion_Major = byArray[0];
        archiveDatabaseEx.ArchiveInfo.ArchiveVersion_Minor = byArray[1];
        if (archiveDatabaseEx.ArchiveInfo.ArchiveVersion_Major != kMajorVersion) {
            throw new IOException("Unsupported Version");
        }
        CRC cRC = new CRC();
        int n2 = this.SafeReadDirectUInt32();
        long l2 = this.SafeReadDirectUInt64();
        long l3 = this.SafeReadDirectUInt64();
        int n3 = this.SafeReadDirectUInt32();
        cRC.UpdateUInt64(l2);
        cRC.UpdateUInt64(l3);
        cRC.UpdateUInt32(n3);
        archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader = this._position;
        if (cRC.GetDigest() != n2) {
            throw new IOException("Incorrect Header");
        }
        if (l3 == 0L) {
            return 0;
        }
        if (l3 >= 0xFFFFFFFFL) {
            return -2147467259;
        }
        this._position = this._stream.Seek(l2, 1);
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.SetCapacity((int)l3);
        n = this.ReadDirect(byteBuffer.data(), (int)l3);
        if (n != (int)l3) {
            throw new IOException("Unexpected End Of Archive");
        }
        if (!CRC.VerifyDigest(n3, byteBuffer.data(), (int)l3)) {
            throw new IOException("Incorrect Header");
        }
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this, byteBuffer);
        ObjectVector<ByteBuffer> objectVector = new ObjectVector<ByteBuffer>();
        while ((l = this.ReadID()) != 1L) {
            if (l != 23L) {
                throw new IOException("Incorrect Header");
            }
            long[] lArray = new long[]{archiveDatabaseEx.ArchiveInfo.DataStartPosition2};
            int n4 = this.ReadAndDecodePackedStreams(archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader, lArray, objectVector);
            if (n4 != 0) {
                return n4;
            }
            archiveDatabaseEx.ArchiveInfo.DataStartPosition2 = lArray[0];
            if (objectVector.size() == 0) {
                return 0;
            }
            if (objectVector.size() > 1) {
                throw new IOException("Incorrect Header");
            }
            streamSwitch.Remove();
            streamSwitch.Set(this, (ByteBuffer)objectVector.get(0));
        }
        streamSwitch.close();
        return this.ReadHeader(archiveDatabaseEx);
    }

    int ReadHeader(ArchiveDatabaseEx archiveDatabaseEx) throws IOException {
        int n;
        Object object;
        long l = this.ReadID();
        if (l == 2L) {
            int n2 = this.ReadArchiveProperties(archiveDatabaseEx.ArchiveInfo);
            if (n2 != 0) {
                return n2;
            }
            l = this.ReadID();
        }
        ObjectVector<ByteBuffer> objectVector = new ObjectVector<ByteBuffer>();
        if (l == 3L) {
            object = new long[]{archiveDatabaseEx.ArchiveInfo.DataStartPosition2};
            int n3 = this.ReadAndDecodePackedStreams(archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader, (long[])object, objectVector);
            if (n3 != 0) {
                return n3;
            }
            archiveDatabaseEx.ArchiveInfo.DataStartPosition2 = object[0];
            archiveDatabaseEx.ArchiveInfo.DataStartPosition2 += archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader;
            l = this.ReadID();
        }
        object = new LongVector();
        BoolVector boolVector = new BoolVector();
        IntVector intVector = new IntVector();
        if (l == 4L) {
            long[] lArray = new long[]{archiveDatabaseEx.ArchiveInfo.DataStartPosition};
            n = this.ReadStreamsInfo(objectVector, lArray, archiveDatabaseEx.PackSizes, archiveDatabaseEx.PackCRCsDefined, archiveDatabaseEx.PackCRCs, archiveDatabaseEx.Folders, archiveDatabaseEx.NumUnPackStreamsVector, (LongVector)object, boolVector, intVector);
            if (n != 0) {
                return n;
            }
            archiveDatabaseEx.ArchiveInfo.DataStartPosition = lArray[0];
            archiveDatabaseEx.ArchiveInfo.DataStartPosition += archiveDatabaseEx.ArchiveInfo.StartPositionAfterHeader;
            l = this.ReadID();
        } else {
            for (int i = 0; i < archiveDatabaseEx.Folders.size(); ++i) {
                archiveDatabaseEx.NumUnPackStreamsVector.add(1);
                Folder folder = (Folder)archiveDatabaseEx.Folders.get(i);
                object.add(folder.GetUnPackSize());
                boolVector.add(folder.UnPackCRCDefined);
                intVector.add(folder.UnPackCRC);
            }
        }
        archiveDatabaseEx.Files.clear();
        if (l == 0L) {
            return 0;
        }
        if (l != 5L) {
            throw new IOException("Incorrect Header");
        }
        int n4 = this.ReadNum();
        archiveDatabaseEx.Files.Reserve(n4);
        for (n = 0; n < n4; ++n) {
            archiveDatabaseEx.Files.add(new FileItem());
        }
        archiveDatabaseEx.ArchiveInfo.FileInfoPopIDs.add(9L);
        if (!archiveDatabaseEx.PackSizes.isEmpty()) {
            archiveDatabaseEx.ArchiveInfo.FileInfoPopIDs.add(6L);
        }
        if (n4 > 0 && !intVector.isEmpty()) {
            archiveDatabaseEx.ArchiveInfo.FileInfoPopIDs.add(10L);
        }
        BoolVector boolVector2 = new BoolVector();
        boolVector2.Reserve(n4);
        for (int i = 0; i < n4; ++i) {
            boolVector2.add(false);
        }
        BoolVector boolVector3 = new BoolVector();
        BoolVector boolVector4 = new BoolVector();
        int n5 = 0;
        block12: while ((l = this.ReadID()) != 0L) {
            long l2 = this.ReadNumber();
            archiveDatabaseEx.ArchiveInfo.FileInfoPopIDs.add(l);
            switch ((int)l) {
                case 17: {
                    StreamSwitch streamSwitch = new StreamSwitch();
                    int n6 = streamSwitch.Set(this, objectVector);
                    if (n6 != 0) {
                        return n6;
                    }
                    n6 = this.ReadFileNames(archiveDatabaseEx.Files);
                    streamSwitch.close();
                    if (n6 == 0) continue block12;
                    return n6;
                }
                case 21: {
                    FileItem fileItem;
                    int n7;
                    BoolVector boolVector5 = new BoolVector();
                    int n6 = this.ReadBoolVector2(archiveDatabaseEx.Files.size(), boolVector5);
                    if (n6 != 0) {
                        return n6;
                    }
                    StreamSwitch streamSwitch = new StreamSwitch();
                    n6 = streamSwitch.Set(this, objectVector);
                    if (n6 != 0) {
                        return n6;
                    }
                    for (n7 = 0; n7 < n4; ++n7) {
                        fileItem = (FileItem)archiveDatabaseEx.Files.get(n7);
                        fileItem.AreAttributesDefined = boolVector5.get(n7);
                        if (!fileItem.AreAttributesDefined) continue;
                        fileItem.Attributes = this.ReadUInt32();
                    }
                    streamSwitch.close();
                    break;
                }
                case 24: {
                    FileItem fileItem;
                    int n7;
                    BoolVector boolVector6 = new BoolVector();
                    int n6 = this.ReadBoolVector2(archiveDatabaseEx.Files.size(), boolVector6);
                    if (n6 != 0) {
                        return n6;
                    }
                    StreamSwitch streamSwitch = new StreamSwitch();
                    n6 = streamSwitch.Set(this, objectVector);
                    if (n6 != 0) {
                        return n6;
                    }
                    for (n7 = 0; n7 < n4; ++n7) {
                        fileItem = (FileItem)archiveDatabaseEx.Files.get(n7);
                        fileItem.IsStartPosDefined = boolVector6.get(n7);
                        if (!fileItem.IsStartPosDefined) continue;
                        fileItem.StartPos = this.ReadUInt64();
                    }
                    streamSwitch.close();
                    break;
                }
                case 14: {
                    int n6;
                    int n8 = this.ReadBoolVector(n4, boolVector2);
                    if (n8 != 0) {
                        return n8;
                    }
                    for (n6 = 0; n6 < boolVector2.size(); ++n6) {
                        if (!boolVector2.get(n6)) continue;
                        ++n5;
                    }
                    boolVector3.Reserve(n5);
                    boolVector4.Reserve(n5);
                    for (n6 = 0; n6 < n5; ++n6) {
                        boolVector3.add(false);
                        boolVector4.add(false);
                    }
                    continue block12;
                }
                case 15: {
                    int n9 = this.ReadBoolVector(n5, boolVector3);
                    if (n9 == 0) continue block12;
                    return n9;
                }
                case 16: {
                    int n10 = this.ReadBoolVector(n5, boolVector4);
                    if (n10 == 0) continue block12;
                    return n10;
                }
                case 18: 
                case 19: 
                case 20: {
                    int n11 = this.ReadTime(objectVector, archiveDatabaseEx.Files, l);
                    if (n11 == 0) continue block12;
                    return n11;
                }
                default: {
                    archiveDatabaseEx.ArchiveInfo.FileInfoPopIDs.DeleteBack();
                    int n12 = this.SkeepData(l2);
                    if (n12 == 0) continue block12;
                    return n12;
                }
            }
        }
        int n13 = 0;
        int n14 = 0;
        for (int i = 0; i < n4; ++i) {
            FileItem fileItem = (FileItem)archiveDatabaseEx.Files.get(i);
            boolean bl = fileItem.HasStream = !boolVector2.get(i);
            if (fileItem.HasStream) {
                fileItem.IsDirectory = false;
                fileItem.IsAnti = false;
                fileItem.UnPackSize = object.get(n14);
                fileItem.FileCRC = intVector.get(n14);
                fileItem.IsFileCRCDefined = boolVector.get(n14);
                ++n14;
                continue;
            }
            fileItem.IsDirectory = !boolVector3.get(n13);
            fileItem.IsAnti = boolVector4.get(n13);
            ++n13;
            fileItem.UnPackSize = 0L;
            fileItem.IsFileCRCDefined = false;
        }
        return 0;
    }
}

