/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class CellSymphony
extends JFrame
implements ActionListener,
ItemListener {
    public static final String BLANK = "";
    public static final String NOMIDI = "midi synthesizer unavailable on this system";
    public static final Dimension SIZE = new Dimension(250, 160);
    public static final int[] DUR = new int[]{10, 20, 50, 100, 200, 500, 1000};
    public static final int[] TOT = new int[]{10000, 1000, 500, 200, 100, 50, 20, 10};
    public static final int DEFAULTDURATION = 4;
    public static final int DEFAULTTOTAL = 4;
    public static final int HISTOGRAM = 0;
    public static final int DOTPLOT = 1;
    public static final int CONTOUR = 2;
    public static final int DOTPLOT3D = 3;
    public static final int BIPLOT = 4;
    public static final int MAXREGIONS = 16;
    public static final int MAXWINDOWS = 16;
    public static final int MAXGATES = 16;
    public static final int MAXDISPLAYS = 3;
    public static final int[] GDTYPE = new int[]{1, 1, 3};
    public static final int[] GDXPARPITCHNUM;
    public static final int[] GDYPARPITCHNUM;
    public static final int[] GDZPARPITCHNUM;
    public static final int MAXINSTRUMENTS = 3;
    public boolean virgin = true;
    public int[] gdXPar;
    public int[] gdYPar;
    public int[] gdZPar;
    public int sizePar = 0;
    private int volumePar;
    private int duration;
    private int total;
    private int[] program;
    private boolean isSetting = true;
    private GDisplay[] gd;
    public FileSpec fs;
    public int regionNum = 0;
    public int windowNum = 0;
    public int gateNum = 0;
    public int[] pitchPar = new int[3];
    public String[] instrName = new String[3];
    private Message msg;
    HelpBox helper;
    JButton bStart;
    JButton deleteSelect;
    JToggleButton bRecord;
    FileViewPanel fileView;
    JComboBox volumeC;
    JComboBox durationC;
    JComboBox totalC;
    JComboBox[] pitchC;
    JComboBox[] instrC;
    Container mycp;
    static final JMenuBar mainMenuBar;
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    protected JMenuItem filei_1;
    protected JMenuItem helpi_1;
    private FCMPlayer player;
    private boolean programsSet = false;

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        GDXPARPITCHNUM = nArray;
        GDYPARPITCHNUM = new int[]{1, 1, 1};
        GDZPARPITCHNUM = new int[]{2, 2, 2};
        mainMenuBar = new JMenuBar();
    }

    public CellSymphony() {
        super("Cellular Symphony");
        this.program = new int[3];
        this.gd = new GDisplay[3];
        this.pitchC = new JComboBox[3];
        this.instrC = new JComboBox[3];
        this.setJMenuBar(mainMenuBar);
        this.fileMenu = new JMenu("File");
        mainMenuBar.add(this.fileMenu);
        this.fileMenu.addSeparator();
        this.filei_1 = new JMenuItem("Quit");
        this.filei_1.setActionCommand("File");
        this.filei_1.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.filei_1.addActionListener(this);
        this.fileMenu.add(this.filei_1);
        this.helpMenu = new JMenu("Help");
        mainMenuBar.add(this.helpMenu);
        this.helpi_1 = new JMenuItem("Cellular Symphony Help..");
        this.helpi_1.setActionCommand("Help");
        this.helpi_1.addActionListener(this);
        this.helpMenu.add(this.helpi_1);
        this.mycp = this.getContentPane();
        JPanel centre = new JPanel();
        centre.setLayout(new BoxLayout(centre, 0));
        this.fileView = new FileViewPanel(this);
        this.fileView.setAlignmentY(0.0f);
        centre.add(this.fileView);
        JPanel parPan = new JPanel();
        parPan.setLayout(new GridLayout(0, 2));
        int i = 0;
        while (i < 3) {
            this.pitchC[i] = new JComboBox();
            parPan.add(this.addChoicePanel("Pitch" + (i + 1) + ":", this.pitchC[i]));
            this.instrC[i] = new JComboBox();
            parPan.add(this.addChoicePanel("Instrument" + (i + 1) + ":", this.instrC[i]));
            this.instrC[i].addItem("<none>");
            ++i;
        }
        parPan.add(new JPanel());
        this.volumeC = new JComboBox();
        parPan.add(this.addChoicePanel("Volume:", this.volumeC));
        this.volumeC.addItem("<none>");
        this.durationC = new JComboBox();
        i = 0;
        while (i < DUR.length) {
            this.durationC.addItem(String.valueOf(DUR[i]));
            ++i;
        }
        this.durationC.setSelectedIndex(4);
        parPan.add(this.addChoicePanel("Duration(ms):", this.durationC));
        this.totalC = new JComboBox();
        i = 0;
        while (i < TOT.length) {
            this.totalC.addItem(String.valueOf(TOT[i]));
            ++i;
        }
        this.totalC.setSelectedIndex(4);
        parPan.add(this.addChoicePanel("Total cells:", this.totalC));
        parPan.setAlignmentY(0.0f);
        centre.add(parPan);
        this.mycp.add((Component)centre, "Center");
        JPanel south = new JPanel();
        south.setLayout(new FlowLayout(0));
        URL bStartImageURL = CellSymphony.class.getResource("images/quaver.gif");
        this.bStart = new JButton(new ImageIcon(bStartImageURL));
        this.bStart.setToolTipText("Play..");
        this.bStart.addActionListener(this);
        south.add(this.bStart);
        this.bRecord = new JToggleButton("Record");
        this.bRecord.setToolTipText("Record a Midi file..");
        south.add(this.bRecord);
        this.mycp.add((Component)south, "South");
        this.player = new FCMPlayer(this);
        if (this.player != null) {
            String[] allInstrumentNames = this.player.getInstruments();
            if (allInstrumentNames != null) {
                this.setInstr(allInstrumentNames);
            }
            if (!this.player.midiAvailable) {
                this.showMessage(NOMIDI);
            }
        }
        this.pack();
        this.isSetting = false;
        this.setVisible(true);
    }

    private JPanel addChoicePanel(String lab, JComboBox combo) {
        JPanel choicePan = new JPanel();
        choicePan.setLayout(new BoxLayout(choicePan, 0));
        choicePan.add(Box.createHorizontalGlue());
        choicePan.add(new JLabel(lab));
        combo.addItemListener(this);
        choicePan.add(combo);
        return choicePan;
    }

    public void setInstr(String[] instr) {
        if (instr != null) {
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < instr.length) {
                    if (instr[i] != null && instr[i].length() > 0) {
                        this.instrC[j].insertItemAt(instr[i], i + 1);
                    }
                    ++i;
                }
                this.instrC[j].setSelectedIndex(0);
                ++j;
            }
            this.programsSet = true;
        }
    }

    public void setInstr(int[] prog) {
        if (prog != null && prog.length > 0) {
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < prog.length) {
                    String item = String.valueOf(String.valueOf(i)) + ": " + String.valueOf(prog[i]);
                    this.instrC[j].insertItemAt(item, i + 1);
                    ++i;
                }
                this.instrC[j].setSelectedIndex(0);
                ++j;
            }
            this.programsSet = true;
        }
    }

    public void set(FileSpec fs) {
        int k;
        int[] oldp = new int[3];
        this.isSetting = true;
        int items = this.pitchC[0].getItemCount();
        int i = 0;
        while (i < 3) {
            oldp[i] = this.pitchC[i].getSelectedIndex();
            ++i;
        }
        int oldv = this.volumeC.getSelectedIndex();
        i = 0;
        while (i < fs.nPars) {
            String pn = fs.parstain[i];
            if (pn != null && pn.length() > 0) {
                k = 0;
                while (k < 3) {
                    this.pitchC[k].insertItemAt(pn, i);
                    ++k;
                }
                this.volumeC.insertItemAt(pn, i + 1);
            } else {
                pn = fs.parname[i];
                if (pn != null && pn.length() > 0) {
                    k = 0;
                    while (k < 3) {
                        this.pitchC[k].insertItemAt(pn, i);
                        ++k;
                    }
                    this.volumeC.insertItemAt(pn, i + 1);
                }
            }
            ++i;
        }
        int j = i;
        while (j < items + i) {
            k = 0;
            while (k < 3) {
                this.pitchC[k].removeItemAt(i);
                ++k;
            }
            this.volumeC.removeItemAt(i + 1);
            ++j;
        }
        k = 0;
        while (k < 3) {
            if (oldp[k] < fs.nPars && oldp[k] >= 0) {
                this.pitchC[k].setSelectedIndex(oldp[k]);
            } else {
                this.pitchC[k].setSelectedIndex(0);
            }
            ++k;
        }
        if (oldv < fs.nPars && oldv >= 0) {
            this.volumeC.setSelectedIndex(oldv);
        } else {
            this.volumeC.setSelectedIndex(0);
        }
        this.fs = fs;
        this.virgin = true;
        this.isSetting = false;
        this.updateGDs();
        this.showPlots();
        this.pack();
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        if (!this.isSetting && ev.getStateChange() == 1) {
            this.isSetting = true;
            this.resetGDs();
            if (this.player != null && this.player.midiAvailable) {
                int j = 0;
                while (j < 3) {
                    if (ev.getSource() == this.instrC[j]) {
                        this.player.testPlay(j, this.instrC[j].getSelectedIndex() - 1);
                    }
                    ++j;
                }
            }
            this.isSetting = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object target = evt.getSource();
        if (target instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)target;
            String menu_label = mi.getActionCommand();
            if (menu_label.compareTo("File") == 0) {
                if (mi.getText().compareTo("Quit") == 0) {
                    System.exit(0);
                }
            } else if (menu_label.compareTo("Help") == 0 && mi.getText().compareTo("Cellular Symphony Help..") == 0) {
                this.showHelp();
            }
        } else if (target == this.bStart) {
            this.resetGDs();
            if (this.player == null || !this.player.midiAvailable) {
                this.showMessage(NOMIDI);
            } else if (this.fs != null) {
                boolean isRecording = this.bRecord.isSelected();
                this.player.play(this.fs, this.pitchPar, this.program, this.volumePar, 1, this.total, this.duration, isRecording);
                this.bRecord.setSelected(false);
            }
        }
    }

    private void showHelp() {
        if (this.helper == null) {
            this.helper = new HelpBox();
        }
        this.helper.setVisible(true);
    }

    private void showPlots() {
        int i = 0;
        while (i < 3) {
            GDisplay agd = this.gd[i];
            if (agd != null) {
                agd.setVisible(true);
            }
            ++i;
        }
    }

    private void resetGDs() {
        int k = 0;
        while (k < 3) {
            this.pitchPar[k] = this.pitchC[k].getSelectedIndex();
            this.instrName[k] = (String)this.instrC[k].getSelectedItem();
            ++k;
        }
        k = 0;
        while (k < 3) {
            this.program[k] = this.programsSet ? this.instrC[k].getSelectedIndex() - 1 : 0;
            ++k;
        }
        this.volumePar = this.volumeC.getSelectedIndex() - 1;
        this.duration = DUR[this.durationC.getSelectedIndex()];
        this.total = TOT[this.totalC.getSelectedIndex()];
        if (this.fs == null) {
            String path;
            File file = this.fileView.getSingleSelectedFile();
            if (file == null || (path = file.getPath()) != null) {
                return;
            }
            this.fs = new FileSpec(path);
        }
        if (this.fs != null) {
            this.fs.scale[0] = this.total;
            int i = 0;
            while (i < 3) {
                if (this.gd[i] != null) {
                    this.gd[i].parameter[0] = this.pitchPar[GDXPARPITCHNUM[i]];
                    this.gd[i].instrName[0] = this.instrName[GDXPARPITCHNUM[i]];
                    this.gd[i].parameter[1] = this.pitchPar[GDYPARPITCHNUM[i]];
                    this.gd[i].instrName[1] = this.instrName[GDYPARPITCHNUM[i]];
                    this.gd[i].parameter[2] = this.pitchPar[GDZPARPITCHNUM[i]];
                    this.gd[i].instrName[2] = this.instrName[GDZPARPITCHNUM[i]];
                    if (this.volumePar >= 0) {
                        this.gd[i].parameter[7] = this.volumePar;
                        this.gd[i].style |= 0x80;
                    } else {
                        this.gd[i].parameter[7] = 0;
                        this.gd[i].style &= 0xFFFFFF7F;
                    }
                    this.gd[i].parameter[4] = this.pitchPar[1];
                    this.gd[i].parameter[5] = this.pitchPar[0];
                    this.gd[i].parameter[6] = this.pitchPar[2];
                    try {
                        this.fs.readData(this.gd[i]);
                        this.gd[i].dsp.fullRepaint();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.gd[i].toFront();
                }
                ++i;
            }
        }
    }

    private void updateGDs() {
        Rectangle myBounds = this.getBounds();
        int yOffset = myBounds.y + myBounds.height;
        int xOffset = myBounds.x;
        int i = 0;
        while (i < 3) {
            boolean setGD;
            GDisplay agd = this.gd[i];
            if (agd != null) {
                setGD = false;
                agd.changeFile(this.fs);
                agd.dsp.updatePumParameters();
            } else {
                Point location = new Point(xOffset, yOffset);
                setGD = true;
                this.gd[i] = new GDisplay(this, GDTYPE[i], this.pitchPar[GDXPARPITCHNUM[i]], this.pitchPar[GDYPARPITCHNUM[i]], this.pitchPar[GDZPARPITCHNUM[i]], location);
            }
            DotPlotInitializer.initialize(this.gd[i], this.fs, setGD);
            this.gd[i].toFront();
            xOffset += this.gd[i].getWidth();
            ++i;
        }
    }

    public void reportClose(GDisplay agd) {
        int i = 0;
        while (i < 3) {
            if (agd == this.gd[i]) {
                this.gd[i] = null;
                break;
            }
            ++i;
        }
    }

    private void showMessage(String msgText) {
        this.msg = new Message(this, msgText);
    }

    public static void main(String[] args) {
        new CellSymphony();
    }
}

