/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationSnp {
    boolean debug;
    boolean verbose;

    public TestCasesIntegrationSnp() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test_02_Start_NonSyn() {
        Gpr.debug("Test");
        String genome = "testHg19ChrM";
        String vcf = "tests/test_chrM_start_codon_nonSyn.vcf";
        String[] args = new String[]{"-noLog", "-classic", "-ud", "0", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.NON_SYNONYMOUS_START) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.LOW, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }

    @Test
    public void test_02_StopGained_HighImpact() {
        Gpr.debug("Test");
        String genome = "testHg3775Chr2";
        String vcf = "tests/stop_gained_chr2.vcf";
        String[] args = new String[]{"-noLog", "-classic", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.STOP_GAINED) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.HIGH, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }

    @Test
    public void test_03_Start_Loss() {
        Gpr.debug("Test");
        String genome = "testHg19ChrM";
        String vcf = "tests/test_chrM_start_codon.vcf";
        String[] args = new String[]{"-noLog", "-classic", "-ud", "0", genome, vcf};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setVerbose(this.verbose);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        boolean checked = false;
        List<VcfEntry> vcfEntries = seff.run(true);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\t\t" + veff);
                }
                if (veff.getEffectType() != EffectType.START_LOST) continue;
                Assert.assertEquals((Object)VariantEffect.EffectImpact.HIGH, (Object)veff.getImpact());
                checked = true;
            }
        }
        Assert.assertEquals(true, checked);
    }
}

