/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import org.junit.Test;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;

public class TestCasesIntegrationNmd
extends TestCasesIntegrationBase {
    @Test
    public void test_01() {
        Gpr.debug("Test");
        String genomeVer = "testHg3766Chr1";
        Gpr.debug("Loading database '" + genomeVer + "'");
        Config config = new Config(genomeVer, "snpEff.config");
        config.setTreatAllAsProteinCoding(true);
        config.loadSnpEffectPredictor();
        int countTest = 1;
        for (Gene gene : config.getGenome().getGenes()) {
            if (this.verbose) {
                System.err.println("NMD test\tGene ID:" + gene.getId());
            }
            for (Transcript tr : gene) {
                if (this.debug) {
                    System.err.println(tr);
                }
                this.checkNmd(config, gene, tr);
                if (this.verbose) {
                    System.err.print("\tTranscript " + tr.getId() + " " + (tr.isStrandPlus() ? (char)'+' : '-') + " :");
                    continue;
                }
                Gpr.showMark(countTest++, SHOW_EVERY);
            }
        }
    }
}

