/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import org.junit.Assert;
import org.junit.Test;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;

public class TestCasesIntegrationCircularGenome
extends TestCasesIntegrationBase {
    @Test
    public void testCase_01_CircularGenome() {
        Gpr.debug("Test");
        String genomeName = "testCase";
        String genBankFile = "tests/genes_circular.gbk";
        SnpEffectPredictor sep = this.buildGeneBank(genomeName, genBankFile);
        sep.buildForest();
        Genome genome = sep.getGenome();
        Variant var = new Variant((Marker)genome.getChromosome("chr"), 2, "", "TATTTTTCAG", "");
        VariantEffects varEffs = sep.variantEffect(var);
        for (VariantEffect varEff : varEffs) {
            VcfEffect vcfEff = new VcfEffect(varEff, EffFormatVersion.FORMAT_ANN_1);
            if (!this.verbose) continue;
            System.out.println("\t" + vcfEff);
        }
    }

    @Test
    public void testCase_02_CircularGenome() {
        Gpr.debug("Test");
        String genomeName = "test_circular_GCA_000210475.1.22";
        SnpEffectPredictor sep = this.build(genomeName);
        sep.buildForest();
        if (this.verbose) {
            Genome genome = sep.getGenome();
            for (Chromosome chr : genome.getChromosomes()) {
                System.out.println(chr);
            }
        }
        this.checkAnnotations(sep, "p948", 0, "T", "A", "p.Phe297Ile", "c.889T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", -3, "T", "A", "p.Trp296Arg", "c.886T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", -885, "G", "T", "p.Asp2Tyr", "c.4G>T", "missense_variant");
        this.checkAnnotations(sep, "p948", 94797, "T", "A", "p.Phe297Ile", "c.889T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", 94794, "T", "A", "p.Trp296Arg", "c.886T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", 93912, "G", "T", "p.Asp2Tyr", "c.4G>T", "missense_variant");
    }

    @Test
    public void testCase_02_CircularGenome_end() {
        Gpr.debug("Test");
        String genomeName = "test_circular_GCA_000210475.1.22_end";
        SnpEffectPredictor sep = this.build(genomeName);
        sep.buildForest();
        if (this.verbose) {
            Genome genome = sep.getGenome();
            for (Chromosome chr : genome.getChromosomes()) {
                System.out.println(chr);
            }
        }
        this.checkAnnotations(sep, "p948", 0, "T", "A", "p.Phe297Ile", "c.889T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", -3, "T", "A", "p.Trp296Arg", "c.886T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", -885, "G", "T", "p.Asp2Tyr", "c.4G>T", "missense_variant");
        this.checkAnnotations(sep, "p948", 94797, "T", "A", "p.Phe297Ile", "c.889T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", 94794, "T", "A", "p.Trp296Arg", "c.886T>A", "missense_variant");
        this.checkAnnotations(sep, "p948", 93912, "G", "T", "p.Asp2Tyr", "c.4G>T", "missense_variant");
    }

    @Test
    public void testCase_03_CircularGenome() {
        Gpr.debug("Test");
        String prot = "MQTECSAGAYEFPASCGRRVVARFDGGRMSSDGGVILVKQADDILGLSRRFAACFRDKRHPGFVEYIPQSRDAAYRENRQQSGG*";
        String cds = "ATGCAGACAGAGTGTAGCGCAGGCGCGTATGAGTTTCCAGCCTCCTGTGGACGGCGTGTTGTGGCCCGTTTTGACGGGGGTCGCATGAGTTCGGATGGGGGCGTCATTCTGGTGAAGCAGGCTGATGACATTCTGGGTCTCAGCCGCCGCTTTGCTGCCTGTTTTCGCGATAAGCGGCATCCCGGCTTTGTGGAATATATTCCACAAAGCCGGGATGCCGCTTATCGCGAAAACAGGCAGCAAAGCGGCGGCTGA";
        String genomeName = "test_Acetobacter_pasteurianus";
        SnpEffectPredictor sep = this.build(genomeName);
        Gene g = sep.getGene("DB34_00005");
        Transcript tr = (Transcript)g.subIntervals().iterator().next();
        Assert.assertEquals("Protein sequence differs", prot, tr.protein());
        Assert.assertEquals("CDS sequence differs", cds, tr.cds().toUpperCase());
    }

    @Test
    public void testCase_04_CircularGenome() {
        Gpr.debug("Test");
        String prot = "MTNNIVIAGRLVADAELFFTNNGSAICNFTLANNKRYKDIEKSTFIEASIFGNYAESMNKYLKKGVSIDVIGELVQESWSKDGKIYYKHKIKVKEIDFRTPKDNISEANFENEDTPSNHLLYLVEDNMRAVTIPIIISEQTPNIAKFSNVISKECKLSLAICSMVLLLSSIIFNHIQPSYSKSSIQIFVKTTPNKNAITYIARNPTNSSIINNSLLVLICKLCILWQFIIYYYIHSL*";
        String cds = "ATGACAAATAATATAGTAATTGCAGGAAGATTGGTGGCAGACGCTGAACTATTTTTTACAAATAATGGCTCTGCTATTTGTAATTTTACTTTGGCGAATAATAAAAGATACAAAGACATAGAAAAAAGCACTTTTATAGAAGCTAGTATTTTTGGCAACTATGCAGAATCTATGAATAAGTATCTAAAAAAAGGCGTATCAATTGATGTAATAGGAGAGCTGGTTCAAGAAAGCTGGAGCAAAGATGGAAAAATATATTATAAACATAAAATCAAAGTCAAAGAGATTGATTTTAGAACACCAAAAGATAATATTTCAGAAGCAAACTTTGAAAATGAAGATACACCCTCAAATCATCTGCTTTATCTGGTGGAAGACAATATGAGAGCTGTAACTATTCCTATTATCATAAGTGAGCAAACGCCAAATATAGCAAAATTCTCAAATGTCATTTCTAAAGAATGCAAACTTTCTCTTGCTATTTGCTCTATGGTTTTATTACTTTCTTCTATCATTTTCAATCATATTCAACCAAGTTATTCAAAAAGCTCAATCCAAATTTTTGTAAAAACAACACCTAATAAGAATGCAATAACGTACATTGCAAGAAATCCTACTAACTCGTCCATAATCAATAATTCCTTATTAGTCTTAATTTGTAAGCTCTGTATTTTATGGCAATTTATTATTTATTATTATATCCATTCTCTATGA";
        String genomeName = "test_Campylobacter_fetus_subsp_venerealis_nctc_10354";
        SnpEffectPredictor sep = this.build(genomeName);
        Gene g = sep.getGene("CFV354_1968");
        Transcript tr = (Transcript)g.subIntervals().iterator().next();
        Assert.assertEquals("Protein sequence differs", prot, tr.protein());
        Assert.assertEquals("CDS sequence differs", cds, tr.cds().toUpperCase());
    }

    @Test
    public void testCase_05_CircularGenome_ExonsOrder() {
        Gpr.debug("Test");
        String expectedProtein = "MGSLEMVPMGAGPPSPGGDPDGYDGGNNSQYPSASGSSGNTPTPPNDEERESNEEPPPPYEDPYWGNGDRHSDYQPLGTQDQSLYLGLQHDGNDGLPPPPYSPRDDSSQHIYEEAGRGSMNPVCLPVIVAPYLFWLAAIAASCFTASVSTVVTATGLALSLLLLAAVASSYAAAQRKLLTPVTVLTAVVTFFAICLTWRIEDPPFNSLLFALLAAAGGLQGIYVLVMLVLLILAYRRRWRRLTVCGGIMFLACVLVLIVDAVLQLSPLLGAVTVVSMTLLLLAFVLWLSSPGGLGTLGAALLTLAAALALLASLILGTLNLTTMFLLMLLWTLVVLLICSSCSSCPLSKILLARLFLYALALLLLASALIAGGSILQTNFKSLSSTEFIPNLFCMLLLIVAGILFILAILTEWGSGNRTYGPVFMCLGGLLTMVAGAVWLTVMSNTLLSAWILTAGFLIFLIGFALFGVIRCCRYCCYYCLTLESEERPPTPYRNTV*";
        String genomeName = "testCase";
        String genBankFile = "tests/Human_herpesvirus_4_uid14413.gbk.gz";
        SnpEffectPredictor sep = this.buildGeneBank(genomeName, genBankFile);
        sep.buildForest();
        Genome genome = sep.getGenome();
        Gene gene = genome.getGenes().getGeneByName("LMP2");
        Transcript tr = (Transcript)gene.get("YP_401631.1");
        Assert.assertTrue("Transcript ID not found", tr != null);
        if (this.verbose) {
            Gpr.debug("Transcript: " + tr);
        }
        String prot = tr.protein();
        Assert.assertEquals("Protein sequence deas not match", expectedProtein, prot);
    }

    @Test
    public void testCase_06_CircularGenome_ExonsOrder() {
        Gpr.debug("Test");
        String expectedProtein = "MALQTDTQAWRVEIGTRGLMFSNCVPLHLPEGQYHKLRLPVSAYEALAVARYGLVGSLWEVPAVNSALQCLAAAAPCKDVKIYPSCIFQVHAPMFVTIKTSLRCLNPHDLCLCLICVGAAILDIPLLCAPRDGAGARAAEGQAAAAQGGKLRVWGRLSPSSPTSLSLAFPYAGPPPVAWYRHSINLTRSEGVGIGKDCAQDHACPVPPQGHASSAADQAGVPERGRKRAHEGPGAGEAASAGRGDVALSQSRALLWRGLGWDTGRGRLAPGLAMSRDAASGSVHLDIQVDRAEEGWVCDVLLEPGPPTAREGCSLSMDPGLVTLKDAWTLFPLHPEHDAVVPPKEEIHVMAQGHLQGGTPSLWGFTFQEAACDQWVLRPRVWTAHSPIKMTVYNCGHKPLHIGPSTRLGLALFWPAERSDNLDAGRIFYQLTSGELYWGRTVARPPTLTLPVDELRPWPKLTPEEPMQH*";
        String genomeName = "testCase";
        String genBankFile = "tests/Human_herpesvirus_4_uid14413.gbk.gz";
        SnpEffectPredictor sep = this.buildGeneBank(genomeName, genBankFile);
        sep.buildForest();
        Genome genome = sep.getGenome();
        Gene gene = genome.getGenes().getGeneByName("LF1");
        Transcript tr = (Transcript)gene.iterator().next();
        String prot = tr.protein();
        if (this.verbose) {
            Gpr.debug("Transcript: " + tr);
        }
        Assert.assertEquals("Protein sequence does not match", expectedProtein, prot);
    }
}

