/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VariantEffect;

public class Hgvs {
    public static final int MAX_SEQUENCE_LEN_HGVS = 100;
    protected VariantEffect variantEffect;
    protected Variant variant;
    protected Marker marker;
    protected Transcript tr;
    protected Genome genome;
    protected boolean duplication;
    protected boolean strandPlus;
    protected boolean strandMinus;
    protected boolean hgvsTrId;

    public static String parseTranscript(String hgvs) {
        int idxTr = hgvs.indexOf(58);
        if (idxTr < 0) {
            return null;
        }
        return hgvs.substring(0, idxTr);
    }

    public static String removeTranscript(String hgvs) {
        int idxTr = hgvs.indexOf(58);
        if (idxTr < 0) {
            return hgvs;
        }
        return hgvs.substring(idxTr + 1);
    }

    public Hgvs(VariantEffect variantEffect) {
        this.variantEffect = variantEffect;
        this.variant = variantEffect.getVariant();
        this.marker = variantEffect.getMarker();
        this.tr = variantEffect.getTranscript();
        this.genome = this.marker != null ? this.marker.getGenome() : null;
        this.hgvsTrId = Config.get().isHgvsTrId();
        this.initStrand();
    }

    protected void initStrand() {
        if (this.tr != null) {
            this.strandMinus = this.tr.isStrandMinus();
        } else if (this.marker != null) {
            this.strandMinus = this.marker.isStrandMinus();
        }
        this.strandPlus = !this.strandMinus;
    }
}

