/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.serializer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerParentId;
import org.snpeff.interval.MarkerSeq;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Motif;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.RareAminoAcid;
import org.snpeff.interval.Regulation;
import org.snpeff.interval.SpliceSiteAcceptor;
import org.snpeff.interval.SpliceSiteBranch;
import org.snpeff.interval.SpliceSiteBranchU12;
import org.snpeff.interval.SpliceSiteDonor;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.serializer.TxtSerializable;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.Gpr;

public class MarkerSerializer {
    PrintStream outFile;
    int lineNum;
    String line;
    int parsedField;
    String[] fields;
    int currId = 0;
    Genome genome;
    Map<Integer, TxtSerializable> byId;
    Map<TxtSerializable, Integer> byMarker;
    Set<TxtSerializable> doNotSave;

    public MarkerSerializer() {
        this(null);
    }

    public MarkerSerializer(Genome genome) {
        this.genome = genome;
        this.byId = new HashMap<Integer, TxtSerializable>();
        this.byMarker = new HashMap<TxtSerializable, Integer>();
    }

    public void doNotSave(Marker m) {
        if (this.doNotSave == null) {
            this.doNotSave = new HashSet<TxtSerializable>();
        }
        this.doNotSave.add(m);
    }

    protected TxtSerializable getById(int id) {
        return this.byId.get(id);
    }

    public int getIdByMarker(Marker m) {
        Integer id = this.byMarker.get(m);
        if (this.isDoNotSave(m)) {
            return -1;
        }
        if (id == null) {
            throw new RuntimeException("Marker has no numeric ID. \n\tClass    : " + m.getClass().getSimpleName() + "\n\tMarker ID: '" + m.getId() + "'\n\t" + m);
        }
        return id;
    }

    protected Marker getMarkerById(int id) {
        return (Marker)this.getById(id);
    }

    public String getNextField() {
        if (this.fields.length <= this.parsedField) {
            return "";
        }
        return this.fields[this.parsedField++];
    }

    public boolean getNextFieldBoolean() {
        return Gpr.parseBoolSafe(this.getNextField());
    }

    public int getNextFieldInt() {
        return Gpr.parseIntSafe(this.getNextField());
    }

    public Marker getNextFieldMarker() {
        return this.getMarkerById(this.getNextFieldInt());
    }

    public Markers getNextFieldMarkers() {
        String[] fieldIds;
        Markers markers = new Markers();
        String fieldIdsStr = this.getNextField();
        if (fieldIdsStr.isEmpty()) {
            return markers;
        }
        for (String idStr : fieldIds = fieldIdsStr.split(",")) {
            int id = Gpr.parseIntSafe(idStr);
            Marker m = this.getMarkerById(id);
            if (m == null) {
                throw new RuntimeException("Marker '" + id + "' not found. This should never happen!");
            }
            markers.add(m);
        }
        return markers;
    }

    protected int getNextId() {
        return ++this.currId;
    }

    boolean isDoNotSave(Marker m) {
        return this.doNotSave != null && this.doNotSave.contains(m);
    }

    public Markers load(String fileName) {
        LineFileIterator lfi = new LineFileIterator(fileName, true);
        int lineNum = 0;
        Iterator<String> iterator2 = lfi.iterator();
        while (iterator2.hasNext()) {
            String l;
            this.line = l = iterator2.next();
            if (lineNum == 0) {
                String[] fields = this.line.split("\t");
                if (fields.length > 1) {
                    String soft = fields[0];
                    String versionNumber = fields[1];
                    if (!soft.equals("SnpEff")) {
                        throw new RuntimeException("Database file '" + fileName + "' is not compatible with this program version. Try installing the appropriate database.");
                    }
                    if (!versionNumber.equals("4.3")) {
                        throw new RuntimeException("Database file '" + fileName + "' is not compatible with this program version:\n\tDatabase version : '" + versionNumber + "'\n\tProgram version  : '" + "4.3" + "'\nTry installing the appropriate database.");
                    }
                }
            } else {
                this.parsedField = 0;
                this.fields = this.line.split("\t", -1);
                String typeStr = this.fields[0];
                EffectType type = EffectType.valueOf(typeStr);
                String idStr = this.fields[1];
                int id = Gpr.parseIntSafe(idStr);
                Marker m = null;
                switch (type) {
                    case GENOME: {
                        if (this.genome == null) {
                            m = new Genome();
                            break;
                        }
                        m = this.genome;
                        break;
                    }
                    case CHROMOSOME: {
                        m = new Chromosome();
                        break;
                    }
                    case SEQUENCE: {
                        m = new MarkerSeq();
                        break;
                    }
                    case GENE: {
                        m = new Gene();
                        break;
                    }
                    case TRANSCRIPT: {
                        m = new Transcript();
                        break;
                    }
                    case CDS: {
                        m = new Cds();
                        break;
                    }
                    case EXON: {
                        m = new Exon();
                        break;
                    }
                    case UTR_3_PRIME: {
                        m = new Utr3prime();
                        break;
                    }
                    case UTR_5_PRIME: {
                        m = new Utr5prime();
                        break;
                    }
                    case RARE_AMINO_ACID: {
                        m = new RareAminoAcid();
                        break;
                    }
                    case SPLICE_SITE_ACCEPTOR: {
                        m = new SpliceSiteAcceptor();
                        break;
                    }
                    case SPLICE_SITE_BRANCH: {
                        m = new SpliceSiteBranch();
                        break;
                    }
                    case SPLICE_SITE_BRANCH_U12: {
                        m = new SpliceSiteBranchU12();
                        break;
                    }
                    case SPLICE_SITE_DONOR: {
                        m = new SpliceSiteDonor();
                        break;
                    }
                    case NEXT_PROT: {
                        m = new NextProt();
                        break;
                    }
                    case MOTIF: {
                        m = new Motif();
                        break;
                    }
                    case REGULATION: {
                        m = new Regulation();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unimplemented for type '" + (Object)((Object)type) + "'");
                    }
                }
                try {
                    m.serializeParse(this);
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                    throw new RuntimeException("Error parsing line " + (lineNum + 1) + " from file '" + fileName + "'\n\t" + this.line + "\n\tField [" + this.parsedField + "] : '" + (this.parsedField < this.fields.length ? this.fields[this.parsedField] : "-") + "'", t2);
                }
                this.byId.put(id, m);
            }
            ++lineNum;
        }
        Markers markers = new Markers();
        for (TxtSerializable tm : this.byId.values()) {
            if (!(tm instanceof Marker)) continue;
            Marker m = (Marker)tm;
            if (m.getParent() instanceof MarkerParentId) {
                MarkerParentId mpid = (MarkerParentId)m.getParent();
                int parentId = mpid.getParentId();
                Marker parent = this.getMarkerById(parentId);
                m.setParent(parent);
            }
            markers.add(m);
        }
        return markers;
    }

    public String save(Iterable<Marker> markersCollection) {
        StringBuilder idStr = new StringBuilder();
        for (Marker m : markersCollection) {
            int id = this.save(m);
            if (idStr.length() > 0) {
                idStr.append(",");
            }
            idStr.append(id);
        }
        return idStr.toString();
    }

    public int save(Marker m) {
        if (m == null) {
            return -1;
        }
        if (this.shouldSkip(m)) {
            return this.getIdByMarker(m);
        }
        int id = this.getNextId();
        this.byMarker.put(m, id);
        String line = m.serializeSave(this);
        this.outFile.print(line + "\n");
        ++this.lineNum;
        return id;
    }

    public void save(String fileName, Markers markers) {
        try {
            this.lineNum = 0;
            this.currId = 0;
            this.outFile = new PrintStream(new GZIPOutputStream(new FileOutputStream(fileName)));
            this.outFile.print("SnpEff\t4.3\n");
            for (Marker m : markers) {
                this.save(m);
            }
            this.outFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean shouldSkip(Marker m) {
        return this.byMarker.containsKey(m) || this.isDoNotSave(m);
    }
}

