/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nmer;

import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.procedure.TLongIntProcedure;
import java.io.Serializable;
import java.util.Random;
import org.snpeff.nmer.Nmer;
import org.snpeff.spliceSites.AcgtTree;
import org.snpeff.stats.Counter;
import org.snpeff.stats.CounterDouble;

public class NmerCount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean debug = false;
    int nmerSize;
    TLongIntHashMap hash;

    public NmerCount(int nmerSize) {
        this.nmerSize = nmerSize;
        this.hash = new TLongIntHashMap();
    }

    public double avg() {
        double total = this.total();
        double size2 = this.size();
        return size2 > 0.0 ? total / size2 : 0.0;
    }

    public void count(Nmer nmer) {
        long key = nmer.getNmer();
        int count2 = this.hash.get(key) + 1;
        this.hash.put(key, count2);
    }

    public long countLessThan(final int threshold) {
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value2) {
                if (value2 > threshold) {
                    counter.inc();
                }
                return true;
            }
        });
        return counter.count;
    }

    protected int get(long key) {
        return this.hash.get(key);
    }

    public int get(Nmer nmer) {
        long key = nmer.getNmer();
        return this.hash.get(key);
    }

    public long max() {
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value2) {
                if ((long)value2 > counter.get()) {
                    counter.set(value2);
                }
                return true;
            }
        });
        return counter.count;
    }

    public long max(final NmerCount nullDistribution) {
        final CounterDouble max2 = new CounterDouble();
        final Counter counter = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value2) {
                int countNull = nullDistribution.get(key);
                double d = (double)value2 / (double)countNull;
                if (d > max2.get()) {
                    max2.set(d);
                    counter.set(value2);
                }
                return true;
            }
        });
        return counter.count;
    }

    public void random(int iterations) {
        Nmer nmer = new Nmer(this.nmerSize);
        NmerCount nmerCount = new NmerCount(this.nmerSize);
        Random rand = new Random();
        for (int i = 0; i < iterations; ++i) {
            char base = AcgtTree.BASES[rand.nextInt(AcgtTree.BASES.length)];
            nmer.rol(base);
            nmerCount.count(nmer);
        }
    }

    public int size() {
        return this.hash.size();
    }

    public String toString() {
        return "Size: " + this.hash.size() + "\tTotal: " + this.total() + "\tAvg: " + this.avg() + "\tMax: " + this.max();
    }

    public String toStringAll() {
        return this.toStringAll(0);
    }

    public String toStringAll(final int minCount) {
        final StringBuilder sb = new StringBuilder();
        final Nmer nmer = new Nmer(this.nmerSize);
        this.hash.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value2) {
                nmer.setNmer(key);
                if (value2 >= minCount) {
                    sb.append(nmer + "\t" + value2 + "\n");
                }
                return true;
            }
        });
        return sb.toString();
    }

    public long total() {
        final Counter sum2 = new Counter();
        this.hash.forEachEntry(new TLongIntProcedure(){

            @Override
            public boolean execute(long key, int value2) {
                sum2.set(sum2.get() + (long)value2);
                return true;
            }
        });
        return sum2.get();
    }
}

