/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChangeStructural;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class CodonChangeDup
extends CodonChangeStructural {
    public CodonChangeDup(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.coding = transcript.isProteinCoding() || Config.get().isTreatAllAsProteinCoding();
    }

    boolean beyondTranscript() {
        if (this.coding) {
            if (this.transcript.isStrandPlus()) {
                return this.variant.getEnd() > this.transcript.getCdsEnd();
            }
            return this.variant.getEnd() > this.transcript.getCdsStart();
        }
        return this.variant.getEnd() > this.transcript.getEnd();
    }

    @Override
    protected void effectTranscript() {
        this.effectNoCodon(this.transcript, EffectType.TRANSCRIPT_DUPLICATION);
    }

    @Override
    protected void exons() {
        if (this.beyondTranscript()) {
            VariantEffect.EffectImpact impact;
            VariantEffect.EffectImpact effectImpact = impact = this.coding ? VariantEffect.EffectImpact.LOW : VariantEffect.EffectImpact.MODIFIER;
            if (this.exonFull > 0) {
                this.effectNoCodon(this.transcript, EffectType.EXON_DUPLICATION, impact);
            }
            if (this.exonPartial > 0) {
                this.effectNoCodon(this.transcript, EffectType.EXON_DUPLICATION_PARTIAL, impact);
            }
            return;
        }
        if (this.coding) {
            this.exonsCoding();
        } else {
            this.exonsNoncoding();
        }
    }

    @Override
    protected void exonsCoding() {
        int lenDiff;
        this.codonsRefAlt();
        if (this.exonFull > 0) {
            this.effect(this.transcript, EffectType.EXON_DUPLICATION, false);
        }
        if (this.exonPartial > 0) {
            this.effect(this.transcript, EffectType.EXON_DUPLICATION_PARTIAL, false);
        }
        if ((lenDiff = this.cdsAlt.length() - this.cdsRef.length()) % 3 != 0) {
            this.effect(this.transcript, EffectType.FRAME_SHIFT, false);
        }
    }

    @Override
    protected void exonsNoncoding() {
        if (this.exonFull > 0) {
            this.effectNoCodon(this.transcript, EffectType.EXON_DUPLICATION, VariantEffect.EffectImpact.MODIFIER);
        }
        if (this.exonPartial > 0) {
            this.effectNoCodon(this.transcript, EffectType.EXON_DUPLICATION_PARTIAL, VariantEffect.EffectImpact.MODIFIER);
        }
    }

    @Override
    protected void intron() {
        this.effectNoCodon(this.transcript, EffectType.INTRON);
    }
}

