/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.snpEffect.EffectType;

public class Intergenic
extends Marker {
    private static final long serialVersionUID = -2487664381262354896L;
    public static final String CHROMOSOME_START = "CHR_START";
    public static final String CHROMOSOME_END = "CHR_END";
    String name;

    public static Intergenic createIntergenic(Gene geneLeft, Gene geneRight) {
        if (geneLeft == null && geneRight == null) {
            return null;
        }
        int start = 0;
        String gidLeft = CHROMOSOME_START;
        String gnameLeft = CHROMOSOME_START;
        Interval chr = null;
        if (geneLeft != null) {
            start = geneLeft.getEnd() + 1;
            gidLeft = geneLeft.getId();
            gnameLeft = geneLeft.getGeneName();
            chr = geneLeft.getChromosome();
        }
        int end = -1;
        String gidRight = CHROMOSOME_END;
        String gnameRight = CHROMOSOME_END;
        if (geneRight != null) {
            gidRight = geneRight.getId();
            gnameRight = geneRight.getGeneName();
            end = geneRight.getStart() - 1;
            chr = geneRight.getChromosome();
        } else {
            end = chr.getEnd();
        }
        return start <= end ? new Intergenic((Chromosome)chr, start, end, false, gidLeft + "-" + gidRight, gnameLeft + "-" + gnameRight) : null;
    }

    public Intergenic() {
        this.type = EffectType.INTERGENIC;
        this.name = "";
    }

    public Intergenic(Chromosome parent, int start, int end, boolean strandMinus, String id, String name) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.INTERGENIC;
        this.name = name;
    }

    @Override
    public Intergenic cloneShallow() {
        Intergenic clone2 = (Intergenic)super.cloneShallow();
        clone2.name = this.name;
        return clone2;
    }

    public String getName() {
        return this.name;
    }
}

