/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.genotypes;

import java.io.Serializable;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.genotypes.GenotypeVector;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfGenotype;

public class Genotypes
implements Serializable {
    private static final long serialVersionUID = 5417498450863908076L;
    public static int MARK = 100;
    String vcfFileName;
    GenotypeVector[] genotypeVectors;

    public static Genotypes load(String fileName) {
        return (Genotypes)Gpr.readFileSerializedGz(fileName);
    }

    public static void main(String[] args) {
        Genotypes genotypes = new Genotypes();
        genotypes.parse(args);
        genotypes.loadVcf();
        genotypes.save("/tmp/geno.bin");
    }

    public boolean loadVcf() {
        Timer.showStdErr("Counting lines form file: " + this.vcfFileName);
        int numLines = Gpr.countLines(this.vcfFileName);
        Timer.showStdErr("Done. Number of lines: " + numLines);
        Timer.showStdErr("Loading file " + this.vcfFileName);
        VcfFileIterator vcf = new VcfFileIterator(this.vcfFileName);
        int entryNum = 0;
        for (VcfEntry ve : vcf) {
            if (this.genotypeVectors == null) {
                long mem = (long)ve.getVcfGenotypes().size() * (long)numLines / 4L;
                double memG = (double)mem / 1.073741824E9;
                Timer.showStdErr(String.format("Initializing data structures. Expected memory consumption (lower bound): %d bytes (%.2f Gb).", mem, memG));
                this.genotypeVectors = new GenotypeVector[ve.getVcfGenotypes().size()];
                for (int i = 0; i < this.genotypeVectors.length; ++i) {
                    this.genotypeVectors[i] = new GenotypeVector(numLines);
                }
                Timer.showStdErr("Done.");
                Timer.showStdErr("Loading: ");
            }
            int sampleNum = 0;
            for (VcfGenotype vg : ve) {
                this.set(entryNum, sampleNum++, vg);
            }
            Gpr.showMark(++entryNum, MARK);
        }
        System.err.println("");
        Timer.showStdErr("Done");
        return true;
    }

    public void parse(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: " + Genotypes.class.getSimpleName() + " vcfFile");
            System.exit(-1);
        }
        this.vcfFileName = args[0];
    }

    public void save(String fileName) {
        Timer.showStdErr("Saving to file: " + fileName);
        Gpr.toFileSerializeGz(fileName, this);
    }

    public void set(int entryNum, int sampleNum, VcfGenotype vg) {
        this.genotypeVectors[sampleNum].set(entryNum, vg);
    }
}

