/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.fileIterator.FileIterator;
import org.snpeff.interval.Chromosome;

public class FastaFileIterator
extends FileIterator<String> {
    public static String TRANSCRIPT_ID_SEPARATORS_REGEX = "[ \t:,.=]";
    public static char[] TRANSCRIPT_ID_SEPARATORS = TRANSCRIPT_ID_SEPARATORS_REGEX.substring(1, TRANSCRIPT_ID_SEPARATORS_REGEX.length() - 1).toCharArray();
    Pattern transcriptPattern = Pattern.compile("transcript:(\\S*)");
    String header = null;
    String nextHeader = null;

    public FastaFileIterator(String fastaFileName) {
        super(fastaFileName);
    }

    public List<String> fastaHeader2Ids() {
        String[] ids;
        String fastaHeaderLine = this.getName();
        LinkedList<String> list2 = new LinkedList<String>();
        for (char sep : TRANSCRIPT_ID_SEPARATORS) {
            String[] ids2;
            for (String id : ids2 = fastaHeaderLine.split(sep + "")) {
                list2.add(id);
            }
        }
        for (String id : ids = fastaHeaderLine.split(TRANSCRIPT_ID_SEPARATORS_REGEX)) {
            list2.add(id);
        }
        return list2;
    }

    public String getHeader() {
        return this.header;
    }

    public String getName() {
        if (this.header == null) {
            return "";
        }
        String name = this.header.split("\\s+")[0];
        return Chromosome.simpleName(name);
    }

    public String getTranscriptId() {
        Matcher mmatcher = this.transcriptPattern.matcher(this.getHeader());
        if (mmatcher.find()) {
            return mmatcher.group(1);
        }
        return this.getName();
    }

    void header(String line) {
        this.header = this.header == null ? line.substring(1).trim() : this.nextHeader;
        this.nextHeader = line.substring(1).trim();
    }

    @Override
    protected String readNext() {
        StringBuffer sb = new StringBuffer();
        try {
            State state = State.DESCRIPTION;
            while (this.ready()) {
                if (this.line == null) {
                    this.line = this.readLine();
                }
                switch (state) {
                    case DESCRIPTION: {
                        if (!this.line.startsWith(">")) break;
                        state = State.SEQUENCE;
                        this.header(this.line);
                        break;
                    }
                    case SEQUENCE: {
                        if (this.line.startsWith(">")) {
                            state = State.COMPLETE;
                            this.header(this.line);
                        } else {
                            sb.append(this.line.trim());
                        }
                        state = State.COMPLETE;
                        break;
                    }
                    case COMPLETE: {
                        if (this.line.startsWith(">")) {
                            this.header(this.line);
                            state = State.COMPLETE;
                            return sb.toString();
                        }
                        sb.append(this.line.trim());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unkown state '" + (Object)((Object)state) + "'");
                    }
                }
                this.line = null;
            }
            if (state == State.COMPLETE) {
                return sb.toString();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private static enum State {
        DESCRIPTION,
        SEQUENCE,
        COMPLETE;

    }
}

