/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.math;

import java.io.Serializable;
import org.biojava.bio.structure.math.SparseVector;

public class SparseSquareMatrix
implements Serializable {
    private static final long serialVersionUID = -5217767192992868955L;
    private final int N;
    private SparseVector[] rows;

    public SparseSquareMatrix(int N) {
        this.N = N;
        this.rows = new SparseVector[N];
        for (int i = 0; i < N; ++i) {
            this.rows[i] = new SparseVector(N);
        }
    }

    public void put(int i, int j, double value2) {
        if (i < 0 || i >= this.N) {
            throw new IllegalArgumentException("Illegal index");
        }
        if (j < 0 || j >= this.N) {
            throw new IllegalArgumentException("Illegal index");
        }
        this.rows[i].put(j, value2);
    }

    public double get(int i, int j) {
        if (i < 0 || i >= this.N) {
            throw new IllegalArgumentException("Illegal index " + i + " should be > 0 and < " + this.N);
        }
        if (j < 0 || j >= this.N) {
            throw new IllegalArgumentException("Illegal index " + j + " should be > 0 and < " + this.N);
        }
        return this.rows[i].get(j);
    }

    public int nnz() {
        int sum2 = 0;
        for (int i = 0; i < this.N; ++i) {
            sum2 += this.rows[i].nnz();
        }
        return sum2;
    }

    public SparseVector times(SparseVector x2) {
        SparseSquareMatrix A = this;
        if (this.N != x2.size()) {
            throw new IllegalArgumentException("Dimensions disagree. " + this.N + " != " + x2.size());
        }
        SparseVector b = new SparseVector(this.N);
        for (int i = 0; i < this.N; ++i) {
            b.put(i, A.rows[i].dot(x2));
        }
        return b;
    }

    public SparseSquareMatrix plus(SparseSquareMatrix B) {
        SparseSquareMatrix A = this;
        if (A.N != B.N) {
            throw new IllegalArgumentException("Dimensions disagree. " + A.N + " != " + B.N);
        }
        SparseSquareMatrix C = new SparseSquareMatrix(this.N);
        for (int i = 0; i < this.N; ++i) {
            C.rows[i] = A.rows[i].plus(B.rows[i]);
        }
        return C;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("N = ");
        s.append(this.N);
        s.append(", nonzeros = ");
        s.append(this.nnz());
        s.append(System.getProperty("line.separator"));
        for (int i = 0; i < this.N; ++i) {
            s.append(i);
            s.append(": ");
            s.append(this.rows[i]);
            s.append(System.getProperty("line.separator"));
        }
        return s.toString();
    }
}

