/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBParseException;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;

public class HetatomImpl
implements Group,
Serializable {
    private static final long serialVersionUID = 4491470432023820382L;
    public static final String type = "hetatm";
    private static final List<String> WATERNAMES = Arrays.asList("HOH", "DOD", "WAT");
    Map<String, Object> properties;
    long id;
    protected boolean pdb_flag = false;
    protected String pdb_name = null;
    protected ResidueNumber residueNumber = null;
    protected List<Atom> atoms;
    Chain parent = null;
    Map<String, Atom> atomLookup = new HashMap<String, Atom>();
    Map<String, Atom> atomSingleCharLookup = new HashMap<String, Atom>();
    ChemComp chemComp = null;
    List<Group> altLocs = null;

    public HetatomImpl() {
        this.atoms = new ArrayList<Atom>();
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public boolean has3D() {
        return this.pdb_flag;
    }

    @Override
    public void setPDBFlag(boolean flag) {
        this.pdb_flag = flag;
    }

    @Override
    @Deprecated
    public String getPDBCode() {
        if (this.residueNumber != null) {
            return this.residueNumber.toString();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setPDBCode(String pdb_code) {
        this.residueNumber = ResidueNumber.fromString(pdb_code);
        String chainId = null;
        if (this.parent != null) {
            chainId = this.parent.getName();
        }
        this.residueNumber.setChainId(chainId);
    }

    @Override
    public void setPDBName(String s) throws PDBParseException {
        if (s != null && s.equals("?")) {
            System.err.println("HetatomImpl: invalid pdbname: ?");
        }
        this.pdb_name = s;
    }

    @Override
    public String getPDBName() {
        return this.pdb_name;
    }

    @Override
    public void addAtom(Atom atom) {
        atom.setGroup(this);
        this.atoms.add(atom);
        if (atom.getCoords() != null) {
            this.setPDBFlag(true);
        }
        this.atomLookup.put(atom.getFullName(), atom);
        this.atomSingleCharLookup.put(atom.getName(), atom);
    }

    @Override
    public void clearAtoms() {
        this.atoms.clear();
        this.setPDBFlag(false);
        this.atomLookup.clear();
        this.atomSingleCharLookup.clear();
    }

    @Override
    public int size() {
        return this.atoms.size();
    }

    @Override
    public List<Atom> getAtoms() {
        return this.atoms;
    }

    @Override
    public void setAtoms(List<Atom> atoms) {
        for (Atom a : atoms) {
            a.setGroup(this);
            this.atomLookup.put(a.getFullName(), a);
            this.atomSingleCharLookup.put(a.getName(), a);
        }
        this.atoms = atoms;
        if (atoms.size() > 0) {
            this.pdb_flag = true;
        }
    }

    @Override
    public Atom getAtom(String name) throws StructureException {
        Atom a = this.atomLookup.get(name);
        if (a != null) {
            return a;
        }
        a = this.atomSingleCharLookup.get(name);
        if (a != null) {
            return a;
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            if (name.length() > 2 && atom.getFullName().equals(name)) {
                return atom;
            }
            if (!atom.getName().equals(name) || !name.equals("CA") || !atom.getElement().equals(Element.C)) continue;
            return atom;
        }
        if (this.hasAltLoc()) {
            for (Group alt : this.altLocs) {
                try {
                    a = alt.getAtom(name);
                    this.addAtom(a);
                    if (a == null) continue;
                    return a;
                }
                catch (StructureException e) {
                }
            }
        }
        throw new StructureException(" No atom " + name + " in group " + this.pdb_name + " " + this.residueNumber + " !");
    }

    @Override
    public Atom getAtomByPDBname(String name) throws StructureException {
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            if (!atom.getFullName().equals(name)) continue;
            return atom;
        }
        throw new StructureException(" No atom " + name + " in group " + this.pdb_name + " " + this.residueNumber + " !");
    }

    @Override
    public Atom getAtom(int position) throws StructureException {
        if (position < 0 || position >= this.atoms.size()) {
            throw new StructureException("No atom found at position " + position);
        }
        Atom a = this.atoms.get(position);
        return a;
    }

    @Override
    public boolean hasAtom(String fullName) {
        Atom a = this.atomLookup.get(fullName);
        if (a != null) {
            return true;
        }
        a = this.atomSingleCharLookup.get(fullName.trim());
        if (a != null) {
            return true;
        }
        if (this.hasAltLoc()) {
            for (Group alt : this.altLocs) {
                if (!alt.hasAtom(fullName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return type;
    }

    public String toString() {
        String str = "Hetatom " + this.residueNumber + " " + this.pdb_name + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + " atoms: " + this.atoms.size();
        }
        if (this.altLocs != null) {
            str = str + " has altLocs :" + this.altLocs.size();
        }
        return str;
    }

    @Override
    public boolean hasAminoAtoms() {
        String[] atoms = this.getType().equals("amino") & this.getPDBName().equals("GLY") ? new String[]{"N", " CA ", "C", "O"} : new String[]{"N", " CA ", "C", "O", "CB"};
        for (int i = 0; i < atoms.length; ++i) {
            if (this.hasAtom(atoms[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String key, Object value2) {
        this.properties.put(key, value2);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Iterator<Atom> iterator() {
        AtomIterator iter2 = new AtomIterator(this);
        return iter2;
    }

    @Override
    public Object clone() {
        HetatomImpl n = new HetatomImpl();
        n.setPDBFlag(this.has3D());
        n.setPDBCode(this.getPDBCode());
        n.setResidueNumber(this.residueNumber);
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }

    @Override
    public void setParent(Chain parent) {
        this.parent = parent;
    }

    @Override
    public Chain getParent() {
        return this.parent;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public ChemComp getChemComp() {
        if (this.chemComp == null) {
            this.chemComp = ChemCompGroupFactory.getChemComp(this.pdb_name);
            if (this.chemComp == null) {
                System.out.println("HetatomImpl: getChemComp: " + this.pdb_name);
            }
        }
        return this.chemComp;
    }

    @Override
    public void setChemComp(ChemComp cc) {
        this.chemComp = cc;
    }

    @Override
    public void setChain(Chain chain2) {
        this.parent = chain2;
        if (this.residueNumber != null) {
            this.residueNumber.setChainId(chain2.getChainID());
        }
    }

    @Override
    public Chain getChain() {
        return this.parent;
    }

    @Override
    public String getChainId() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getChainID();
    }

    @Override
    public ResidueNumber getResidueNumber() {
        return this.residueNumber;
    }

    @Override
    public void setResidueNumber(ResidueNumber residueNumber) {
        this.residueNumber = residueNumber;
    }

    @Override
    public void setResidueNumber(String chainId, Integer resNum, Character iCode) {
        this.residueNumber = new ResidueNumber(chainId, resNum, iCode);
    }

    @Override
    public boolean hasAltLoc() {
        if (this.altLocs == null) {
            return false;
        }
        return this.altLocs.size() > 0;
    }

    @Override
    public List<Group> getAltLocs() {
        if (this.altLocs == null) {
            return new ArrayList<Group>();
        }
        return this.altLocs;
    }

    @Override
    public Group getAltLocGroup(Character altLoc) {
        try {
            if (this.getAtom(0).getAltLoc().equals(altLoc)) {
                return this;
            }
            if (this.altLocs == null || this.altLocs.size() == 0) {
                return null;
            }
            for (Group group : this.altLocs) {
                if (group.getAtoms().isEmpty() || !group.getAtom(0).getAltLoc().equals(altLoc)) continue;
                return group;
            }
        }
        catch (StructureException structureException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void addAltLoc(Group group) {
        if (this.altLocs == null) {
            this.altLocs = new ArrayList<Group>();
        }
        this.altLocs.add(group);
    }

    @Override
    public boolean isWater() {
        return WATERNAMES.contains(this.pdb_name);
    }
}

