/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntDiskDataStorage;
import org.apfloat.internal.IntMemoryDataStorage;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.DataStorageBuilder;

public class IntDataStorageBuilder
implements DataStorageBuilder {
    public DataStorage createDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= (long)ctx.getMemoryTreshold()) {
            return new IntMemoryDataStorage();
        }
        return new IntDiskDataStorage();
    }

    public DataStorage createCachedDataStorage(long size2) throws ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        if (size2 <= ctx.getMaxMemoryBlockSize()) {
            return new IntMemoryDataStorage();
        }
        return new IntDiskDataStorage();
    }

    public DataStorage createDataStorage(DataStorage dataStorage) throws ApfloatRuntimeException {
        ApfloatContext ctx;
        long size2;
        if (dataStorage instanceof IntMemoryDataStorage && (size2 = dataStorage.getSize()) > (long)(ctx = ApfloatContext.getContext()).getMemoryTreshold()) {
            IntDiskDataStorage tmp = new IntDiskDataStorage();
            tmp.copyFrom(dataStorage);
            dataStorage = tmp;
        }
        return dataStorage;
    }
}

