/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.DoubleTableFNTStrategy;
import org.apfloat.internal.ParallelNTTStrategy;
import org.apfloat.internal.ParallelRunnable;
import org.apfloat.internal.ParallelRunner;
import org.apfloat.spi.ArrayAccess;

public abstract class DoubleParallelFNTStrategy
extends DoubleTableFNTStrategy
implements ParallelNTTStrategy {
    protected ParallelRunner parallelRunner;

    protected DoubleParallelFNTStrategy() {
    }

    public void setParallelRunner(ParallelRunner parallelRunner) {
        this.parallelRunner = parallelRunner;
    }

    protected void multiplyElements(final ArrayAccess arrayAccess, final int startRow, final int rows, final int columns, final double w, final double scaleFactor) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return rows;
            }

            public Runnable getRunnable(int strideStartRow, int strideRows) {
                ArrayAccess subArrayAccess = arrayAccess.subsequence(strideStartRow * columns, strideRows * columns);
                return new MultiplyRunnable(subArrayAccess, startRow + strideStartRow, strideRows, columns, w, scaleFactor);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    protected void transformRows(final int length, final int count2, final boolean isInverse, final ArrayAccess arrayAccess, final double[] wTable, final int[] permutationTable) throws ApfloatRuntimeException {
        ParallelRunnable parallelRunnable = new ParallelRunnable(){

            public int getLength() {
                return count2;
            }

            public Runnable getRunnable(int startIndex, int strideCount) {
                ArrayAccess subArrayAccess = arrayAccess.subsequence(startIndex * length, strideCount * length);
                return new TableFNTRunnable(length, isInverse, subArrayAccess, wTable, permutationTable);
            }
        };
        this.parallelRunner.runParallel(parallelRunnable);
    }

    private class MultiplyRunnable
    implements Runnable {
        private ArrayAccess arrayAccess;
        private int startRow;
        private int rows;
        private int columns;
        private double w;
        private double scaleFactor;

        public MultiplyRunnable(ArrayAccess arrayAccess, int startRow, int rows, int columns, double w, double scaleFactor) {
            this.arrayAccess = arrayAccess;
            this.startRow = startRow;
            this.rows = rows;
            this.columns = columns;
            this.w = w;
            this.scaleFactor = scaleFactor;
        }

        public void run() {
            double[] data2 = this.arrayAccess.getDoubleData();
            int position = this.arrayAccess.getOffset();
            double tmp = DoubleParallelFNTStrategy.this.modPow(this.w, this.startRow);
            for (int i = 0; i < this.rows; ++i) {
                double tmp2 = this.scaleFactor;
                int j = 0;
                while (j < this.columns) {
                    data2[position] = DoubleParallelFNTStrategy.this.modMultiply(data2[position], tmp2);
                    tmp2 = DoubleParallelFNTStrategy.this.modMultiply(tmp2, tmp);
                    ++j;
                    ++position;
                }
                tmp = DoubleParallelFNTStrategy.this.modMultiply(tmp, this.w);
            }
        }
    }

    private class TableFNTRunnable
    implements Runnable {
        private int length;
        private boolean isInverse;
        private ArrayAccess arrayAccess;
        private double[] wTable;
        private int[] permutationTable;

        public TableFNTRunnable(int length, boolean isInverse, ArrayAccess arrayAccess, double[] wTable, int[] permutationTable) {
            this.length = length;
            this.isInverse = isInverse;
            this.arrayAccess = arrayAccess;
            this.wTable = wTable;
            this.permutationTable = permutationTable;
        }

        public void run() {
            int maxI = this.arrayAccess.getLength();
            for (int i = 0; i < maxI; i += this.length) {
                ArrayAccess arrayAccess = this.arrayAccess.subsequence(i, this.length);
                if (this.isInverse) {
                    DoubleParallelFNTStrategy.this.inverseTableFNT(arrayAccess, this.wTable, this.permutationTable);
                    continue;
                }
                DoubleParallelFNTStrategy.this.tableFNT(arrayAccess, this.wTable, this.permutationTable);
            }
        }
    }
}

