/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util.zip;

import java.io.File;
import java.net.URL;
import java.util.zip.Deflater;
import net.sf.samtools.Defaults;
import net.sf.samtools.util.zip.ZStreamRef;

public class IntelDeflater
extends Deflater {
    private final ZStreamRef zsRef;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    public static final int NO_FLUSH = 0;
    public static final int SYNC_FLUSH = 2;
    public static final int FULL_FLUSH = 3;

    public IntelDeflater(int level, boolean nowrap) {
        this.level = level;
        this.strategy = 0;
        this.zsRef = new ZStreamRef(IntelDeflater.init(level, 0, nowrap));
    }

    public IntelDeflater(int level) {
        this(level, false);
    }

    public IntelDeflater() {
        this(-1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.buf = b;
            this.off = off;
            this.len = len;
        }
    }

    @Override
    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDictionary(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            IntelDeflater.setDictionary(this.zsRef.address(), b, off, len);
        }
    }

    @Override
    public void setDictionary(byte[] b) {
        this.setDictionary(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.strategy != strategy) {
                this.strategy = strategy;
                this.setParams = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            if (this.level != level) {
                this.level = level;
                this.setParams = true;
            }
        }
    }

    @Override
    public boolean needsInput() {
        return this.len <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.finish = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean finished() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            return this.finished;
        }
    }

    @Override
    public int deflate(byte[] b, int off, int len) {
        return this.deflate(b, off, len, 0);
    }

    @Override
    public int deflate(byte[] b) {
        return this.deflate(b, 0, b.length, 0);
    }

    @Override
    public int deflate(byte[] b, int off, int len, int flush) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            if (flush == 0 || flush == 2 || flush == 3) {
                return this.deflateBytes(this.zsRef.address(), b, off, len, flush);
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAdler() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getAdler(this.zsRef.address());
        }
    }

    @Override
    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesRead() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getBytesRead(this.zsRef.address());
        }
    }

    @Override
    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesWritten() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            return IntelDeflater.getBytesWritten(this.zsRef.address());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            this.ensureOpen();
            IntelDeflater.reset(this.zsRef.address());
            this.finish = false;
            this.finished = false;
            this.len = 0;
            this.off = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        ZStreamRef zStreamRef = this.zsRef;
        synchronized (zStreamRef) {
            long addr = this.zsRef.address();
            this.zsRef.clear();
            if (addr != 0L) {
                IntelDeflater.end(addr);
                this.buf = null;
            }
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        assert (Thread.holdsLock(this.zsRef));
        if (this.zsRef.address() == 0L) {
            throw new NullPointerException("IntelDeflater has been closed");
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(long var1, byte[] var3, int var4, int var5, int var6);

    private static native int getAdler(long var0);

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        try {
            File sharedLibrary;
            if (Defaults.INTEL_DEFLATER_SHARED_LIBRARY_PATH != null) {
                sharedLibrary = new File(Defaults.INTEL_DEFLATER_SHARED_LIBRARY_PATH);
            } else {
                URL jarUrl = IntelDeflater.class.getProtectionDomain().getCodeSource().getLocation();
                sharedLibrary = new File(new File(jarUrl.getPath()).getParentFile(), "libIntelDeflater.so");
            }
            System.load(sharedLibrary.getAbsolutePath());
        }
        catch (Throwable e) {
            System.loadLibrary("IntelDeflater");
        }
        IntelDeflater.initIDs();
    }
}

