/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMNodeModel
implements TemplateHashModel {
    private static HashMap equivalenceTable = new HashMap();
    private Node node;
    private HashMap cache = new HashMap();

    public DOMNodeModel(Node node) {
        this.node = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TemplateModel get(String key) throws TemplateModelException {
        TemplateModel result2 = null;
        if (equivalenceTable.containsKey(key)) {
            key = (String)equivalenceTable.get(key);
        }
        if (this.cache.containsKey(key)) {
            result2 = (TemplateModel)this.cache.get(key);
        }
        if (result2 != null) return result2;
        if ("attributes".equals(key)) {
            NamedNodeMap attributes = this.node.getAttributes();
            if (attributes != null) {
                SimpleHash hash2 = new SimpleHash();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr att = (Attr)attributes.item(i);
                    hash2.put(att.getName(), att.getValue());
                }
                result2 = hash2;
            }
        } else if (key.charAt(0) == '@') {
            if (!(this.node instanceof Element)) throw new TemplateModelException("Trying to get an attribute value for a non-element node");
            String attValue = ((Element)this.node).getAttribute(key.substring(1));
            result2 = new SimpleScalar(attValue);
        } else if ("is_element".equals(key)) {
            result2 = this.node instanceof Element ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("is_text".equals(key)) {
            result2 = this.node instanceof Text ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("name".equals(key)) {
            result2 = new SimpleScalar(this.node.getNodeName());
        } else if ("children".equals(key)) {
            result2 = new NodeListTM(this.node.getChildNodes());
        } else if ("parent".equals(key)) {
            Node parent = this.node.getParentNode();
            result2 = parent == null ? null : new DOMNodeModel(parent);
        } else if ("ancestorByName".equals(key)) {
            result2 = new AncestorByName();
        } else if ("nextSibling".equals(key)) {
            Node next2 = this.node.getNextSibling();
            result2 = next2 == null ? null : new DOMNodeModel(next2);
        } else if ("previousSibling".equals(key)) {
            Node previous = this.node.getPreviousSibling();
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("nextSiblingElement".equals(key)) {
            Element next3 = DOMNodeModel.nextSiblingElement(this.node);
            result2 = next3 == null ? null : new DOMNodeModel(next3);
        } else if ("previousSiblingElement".equals(key)) {
            Element previous = DOMNodeModel.previousSiblingElement(this.node);
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("nextElement".equals(key)) {
            Element next4 = DOMNodeModel.nextElement(this.node);
            result2 = next4 == null ? null : new DOMNodeModel(next4);
        } else if ("previousElement".equals(key)) {
            Element previous = DOMNodeModel.previousElement(this.node);
            result2 = previous == null ? null : new DOMNodeModel(previous);
        } else if ("text".equals(key)) {
            result2 = new SimpleScalar(DOMNodeModel.getText(this.node));
        }
        this.cache.put(key, result2);
        return result2;
    }

    public boolean isEmpty() {
        return false;
    }

    private static String getText(Node node) {
        String result2 = "";
        if (node instanceof Text) {
            result2 = ((Text)node).getData();
        } else if (node instanceof Element) {
            NodeList children2 = node.getChildNodes();
            for (int i = 0; i < children2.getLength(); ++i) {
                result2 = result2 + DOMNodeModel.getText(children2.item(i));
            }
        }
        return result2;
    }

    private static Element nextSiblingElement(Node node) {
        Node next2 = node;
        while (next2 != null) {
            if (!((next2 = next2.getNextSibling()) instanceof Element)) continue;
            return (Element)next2;
        }
        return null;
    }

    private static Element previousSiblingElement(Node node) {
        Node previous = node;
        while (previous != null) {
            if (!((previous = previous.getPreviousSibling()) instanceof Element)) continue;
            return (Element)previous;
        }
        return null;
    }

    private static Element nextElement(Node node) {
        Element nextSiblingElement;
        if (node.hasChildNodes()) {
            NodeList children2 = node.getChildNodes();
            for (int i = 0; i < children2.getLength(); ++i) {
                Node child = children2.item(i);
                if (!(child instanceof Element)) continue;
                return (Element)child;
            }
        }
        if ((nextSiblingElement = DOMNodeModel.nextSiblingElement(node)) != null) {
            return nextSiblingElement;
        }
        Node parent = node.getParentNode();
        while (parent instanceof Element) {
            Element next2 = DOMNodeModel.nextSiblingElement(parent);
            if (next2 != null) {
                return next2;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    private static Element previousElement(Node node) {
        Element result2 = DOMNodeModel.previousSiblingElement(node);
        if (result2 != null) {
            return result2;
        }
        Node parent = node.getParentNode();
        if (parent instanceof Element) {
            return (Element)parent;
        }
        return null;
    }

    void setParent(DOMNodeModel parent) {
        if (parent != null) {
            this.cache.put("parent", parent);
        }
    }

    String getNodeName() {
        return this.node.getNodeName();
    }

    static {
        equivalenceTable.put("*", "children");
        equivalenceTable.put("@*", "attributes");
    }

    class NodeListTM
    implements TemplateSequenceModel,
    TemplateMethodModel {
        private NodeList nodeList;
        private TemplateModel[] nodes;

        NodeListTM(NodeList nodeList) {
            this.nodeList = nodeList;
            this.nodes = new TemplateModel[nodeList.getLength()];
        }

        public TemplateModel get(int index2) {
            DOMNodeModel result2 = (DOMNodeModel)this.nodes[index2];
            if (result2 == null) {
                result2 = new DOMNodeModel(this.nodeList.item(index2));
                this.nodes[index2] = result2;
                result2.setParent(DOMNodeModel.this);
            }
            return result2;
        }

        public int size() {
            return this.nodes.length;
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            if (!(DOMNodeModel.this.node instanceof Element)) {
                throw new TemplateModelException("Expecting element here.");
            }
            Element elem2 = (Element)DOMNodeModel.this.node;
            return new NodeListTM(elem2.getElementsByTagName((String)arguments.get(0)));
        }
    }

    class AncestorByName
    implements TemplateMethodModel {
        AncestorByName() {
        }

        public Object exec(List arguments) throws TemplateModelException {
            if (arguments.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            String nodeName = (String)arguments.get(0);
            for (DOMNodeModel ancestor = (DOMNodeModel)DOMNodeModel.this.get("parent"); ancestor != null; ancestor = (DOMNodeModel)ancestor.get("parent")) {
                if (!nodeName.equals(ancestor.getNodeName())) continue;
                return ancestor;
            }
            return null;
        }
    }
}

