/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.StdUniformRng;
import DistLib.rng.WichmannHill;

public class uniform {
    public static StdUniformRng uniRng = new WichmannHill();

    public static double density(double x2, double a, double b) {
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b)) {
            return x2 + a + b;
        }
        if (b <= a) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (a <= x2 && x2 <= b) {
            return 1.0 / (b - a);
        }
        return 0.0;
    }

    public static double cumulative(double x2, double a, double b) {
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b)) {
            return x2 + a + b;
        }
        if (b <= a) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= a) {
            return 0.0;
        }
        if (x2 >= b) {
            return 1.0;
        }
        return (x2 - a) / (b - a);
    }

    public static double quantile(double x2, double a, double b) {
        if (Double.isNaN(x2) || Double.isNaN(a) || Double.isNaN(b)) {
            return x2 + a + b;
        }
        if (b <= a || x2 < 0.0 || x2 > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return a + x2 * (b - a);
    }

    public static double random(double a, double b) {
        if (Double.isInfinite(a) || Double.isInfinite(b) || b < a) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (a == b) {
            return a;
        }
        return a + (b - a) * uniform.random();
    }

    public static double random() {
        return uniRng.random();
    }
}

