/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.misc;
import org.apache.commons.math.MathException;
import org.apache.commons.math.special.Erf;

public class tukey {
    static final double nleg = 12.0;
    static final double ihalf = 6.0;
    static final double nlegq = 16.0;
    static final double ihalfq = 8.0;

    static double wprob(double w, double rr, double cc) throws MathException {
        double eps = 1.0;
        double eps1 = -30.0;
        double eps2 = -50.0;
        double eps3 = 60.0;
        double bb = 8.0;
        double wlar = 3.0;
        double wincr1 = 2.0;
        double wincr2 = 3.0;
        double[] xleg = new double[]{0.9815606342467192, 0.9041172563704749, 0.7699026741943047, 0.5873179542866175, 0.3678314989981802, 0.1252334085114689};
        double[] aleg = new double[]{0.04717533638651183, 0.10693932599531843, 0.16007832854334622, 0.20316742672306592, 0.2334925365383548, 0.24914704581340277};
        double qsqz = w * 0.5;
        double ans = 1.0;
        if (qsqz >= 8.0) {
            return 1.0;
        }
        ans = Erf.erf((double)(qsqz / 1.4142135623730951));
        ans = ans >= Math.exp(-50.0 / cc) ? Math.pow(ans, cc) : 0.0;
        double wincr = w > 3.0 ? 2.0 : 3.0;
        double blb = qsqz;
        double binc = (8.0 - qsqz) / wincr;
        double bub = blb + binc;
        double einsum = 0.0;
        double cc1 = cc - 1.0;
        double wi = 1.0;
        while (wi <= wincr) {
            double elsum = 0.0;
            double a = 0.5 * (bub + blb);
            double b = 0.5 * (bub - blb);
            int jj = 1;
            while ((double)jj <= 12.0) {
                double pminus;
                double xx;
                int j;
                if (6.0 < (double)jj) {
                    j = (int)(12.0 - (double)jj) + 1;
                    xx = xleg[j - 1];
                } else {
                    j = jj;
                    xx = -xleg[j - 1];
                }
                double c = b * xx;
                double ac = a + c;
                double qexpo = ac * ac;
                if (qexpo > 60.0) break;
                double pplus = ac > 0.0 ? 1.0 + Erf.erf((double)(ac / 1.4142135623730951)) : 1.0 - Erf.erf((double)(-(ac / 1.4142135623730951)));
                double rinsum = pplus * 0.5 - (pminus = ac > w ? 1.0 + Erf.erf((double)(ac / 1.4142135623730951 - w / 1.4142135623730951)) : 1.0 - Erf.erf((double)(w / 1.4142135623730951 - ac / 1.4142135623730951))) * 0.5;
                if (rinsum >= Math.exp(-30.0 / cc1)) {
                    rinsum = aleg[j - 1] * Math.exp(-(0.5 * qexpo)) * Math.pow(rinsum, cc1);
                    elsum += rinsum;
                }
                ++jj;
            }
            elsum = 2.0 * b * cc * 0.3989422804014327 * elsum;
            einsum += elsum;
            blb = bub;
            bub += binc;
            wi += 1.0;
        }
        if ((ans = einsum + ans) <= Math.exp(-30.0 / rr)) {
            return 0.0;
        }
        if ((ans = Math.pow(ans, rr)) >= 1.0) {
            ans = 1.0;
        }
        return ans;
    }

    public static double cumulative(double q, double rr, double cc, double df) {
        double eps = 1.0;
        double eps1 = -30.0;
        double eps2 = 1.0E-14;
        double dhaf = 100.0;
        double dquar = 800.0;
        double deigh = 5000.0;
        double dlarg = 25000.0;
        double ulen1 = 1.0;
        double ulen2 = 0.5;
        double ulen3 = 0.25;
        double ulen4 = 0.125;
        double[] xlegq = new double[]{0.9894009349916499, 0.9445750230732326, 0.8656312023878318, 0.755404408355003, 0.6178762444026438, 0.45801677765722737, 0.2816035507792589, 0.09501250983763744};
        double[] alegq = new double[]{0.027152459411754096, 0.062253523938647894, 0.09515851168249279, 0.12462897125553388, 0.14959598881657674, 0.16915651939500254, 0.18260341504492358, 0.1894506104550685};
        if (Double.isNaN(q) || Double.isNaN(rr) || Double.isNaN(cc) || Double.isNaN(df)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (q <= 0.0) {
            return 0.0;
        }
        if (df < 2.0 || rr < 1.0 || cc < 2.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(q)) {
            return 1.0;
        }
        if (df > 25000.0) {
            double ans;
            try {
                ans = tukey.wprob(q, rr, cc);
            }
            catch (MathException me) {
                throw new ArithmeticException("Doesn't converge.");
            }
            return ans;
        }
        double f2 = df * 0.5;
        double f2lf = f2 * Math.log(df) - df * 0.6931471805599453 - misc.lgammafn(f2);
        double f21 = f2 - 1.0;
        double ff4 = df * 0.25;
        double ulen = df <= 100.0 ? 1.0 : (df <= 800.0 ? 0.5 : (df <= 5000.0 ? 0.25 : 0.125));
        f2lf += Math.log(ulen);
        double ans = 0.0;
        int i = 1;
        while (i <= 50) {
            double otsum = 0.0;
            double twa1 = (2.0 * (double)i - 1.0) * ulen;
            int jj = 1;
            while ((double)jj <= 16.0) {
                double t1;
                int j;
                if (8.0 < (double)jj) {
                    j = (int)((double)jj - 8.0 - 1.0);
                    t1 = f2lf + f21 * Math.log(twa1 + xlegq[j] * ulen) - (xlegq[j] * ulen + twa1) * ff4;
                } else {
                    j = jj - 1;
                    t1 = f2lf + f21 * Math.log(twa1 - xlegq[j] * ulen) + (xlegq[j] * ulen - twa1) * ff4;
                }
                if (t1 >= -30.0) {
                    double wprb;
                    double qsqz = 8.0 < (double)jj ? q * Math.sqrt((xlegq[j] * ulen + twa1) * 0.5) : q * Math.sqrt((-(xlegq[j] * ulen) + twa1) * 0.5);
                    try {
                        wprb = tukey.wprob(qsqz, rr, cc);
                    }
                    catch (MathException e) {
                        throw new ArithmeticException("Doesn't converge");
                    }
                    double rotsum = wprb * alegq[j] * Math.exp(t1);
                    otsum = rotsum + otsum;
                }
                ++jj;
            }
            if ((double)i * ulen >= 1.0 && otsum <= 1.0E-14) break;
            ans += otsum;
            ++i;
        }
        if (ans > 1.0) {
            ans = 1.0;
        }
        return ans;
    }

    static double qinv(double p, double c, double v) {
        double p0 = 0.322232421088;
        double q0 = 0.099348462606;
        double p1 = -1.0;
        double q1 = 0.588581570495;
        double p2 = -0.342242088547;
        double q2 = 0.531103462366;
        double p3 = -0.204231210125;
        double q3 = 0.10353775285;
        double p4 = -4.53642210148E-5;
        double q4 = 0.0038560700634;
        double c1 = 0.8832;
        double c2 = 0.2368;
        double c3 = 1.214;
        double c4 = 1.208;
        double c5 = 1.4142;
        double vmax = 120.0;
        double ps = 0.5 - 0.5 * p;
        double yi = Math.sqrt(Math.log(1.0 / (ps * ps)));
        double t2 = yi + ((((yi * -4.53642210148E-5 + -0.204231210125) * yi + -0.342242088547) * yi + -1.0) * yi + 0.322232421088) / ((((yi * 0.0038560700634 + 0.10353775285) * yi + 0.531103462366) * yi + 0.588581570495) * yi + 0.099348462606);
        if (v < 120.0) {
            t2 += (t2 * t2 * t2 + t2) / v / 4.0;
        }
        double q = 0.8832 - 0.2368 * t2;
        if (v < 120.0) {
            q += -1.214 / v + 1.208 * t2 / v;
        }
        return t2 * (q * Math.log(c - 1.0) + 1.4142);
    }

    public static double quantile(double p, double rr, double cc, double df) {
        double eps = 1.0E-4;
        int maxiter = 50;
        if (Double.isNaN(p) || Double.isNaN(rr) || Double.isNaN(cc) || Double.isNaN(df)) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p < 0.0 || p > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p < 0.0 || p >= 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (df < 2.0 || rr < 1.0 || cc < 2.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p <= 0.0) {
            return 0.0;
        }
        double x0 = tukey.qinv(p, cc, df);
        double valx0 = tukey.cumulative(x0, rr, cc, df) - p;
        double x1 = valx0 > 0.0 ? Math.max(0.0, x0 - 1.0) : x0 + 1.0;
        double valx1 = tukey.cumulative(x1, rr, cc, df) - p;
        int iter2 = 1;
        while (iter2 < 50) {
            double ans = x1 - valx1 * (x1 - x0) / (valx1 - valx0);
            valx0 = valx1;
            x0 = x1;
            if (ans < 0.0) {
                ans = 0.0;
                valx1 = -p;
            }
            valx1 = tukey.cumulative(ans, rr, cc, df) - p;
            x1 = ans;
            double xabs = Math.abs(x1 - x0);
            if (xabs < 1.0E-4) {
                return ans;
            }
            ++iter2;
        }
        throw new ArithmeticException("No convergence.");
    }
}

