/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.uniform;

public class exponential {
    private static double[] q = new double[]{0.6931471805599453, 0.9333736875190459, 0.9888777961838675, 0.998495925291496, 0.9998292811061389, 0.9999833164100727, 0.9999985691438767, 0.9999998906925558, 0.9999999924734159, 0.9999999995283275, 0.9999999999728814, 0.9999999999985598, 0.999999999999929, 0.9999999999999968, 0.9999999999999999, 1.0};

    public static double density(double x2, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(scale)) {
            return x2 + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 < 0.0) {
            return 0.0;
        }
        return Math.exp(-x2 / scale) / scale;
    }

    public static double cumulative(double x2, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(scale)) {
            return x2 + scale;
        }
        if (scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x2 / scale);
    }

    public static double quantile(double x2, double scale) {
        if (Double.isNaN(x2) || Double.isNaN(scale)) {
            return x2 + scale;
        }
        if (scale <= 0.0 || x2 < 0.0 || x2 > 1.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (x2 <= 0.0) {
            return 0.0;
        }
        return -scale * Math.log(1.0 - x2);
    }

    public static double random(double scale, uniform PRNG) {
        if (Double.isInfinite(scale) || scale <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        return scale * exponential.random(PRNG);
    }

    public static double random(uniform PRNG) {
        double ustar;
        double a = 0.0;
        double u = uniform.random();
        while (!((u += u) > 1.0)) {
            a += q[0];
        }
        u -= 1.0;
        if (u <= q[0]) {
            return a + u;
        }
        int i = 0;
        double umin = ustar = uniform.random();
        do {
            if (!((ustar = uniform.random()) < umin)) continue;
            umin = ustar;
        } while (u > q[++i]);
        return a + umin * q[0];
    }
}

